#ifndef _ZIGBEE_H_
#define _ZIGBEE_H_

typedef struct {
	uint8_t header[3];
	uint8_t	id_package; //TX or RX or TX response
	uint8_t id_frame;   // if 0 no return package for TX 
	uint16_t address;
	uint8_t option;     //0x01 no ACK; 0x04 broadcast PAN id
	uint8_t size_data;	
	uint8_t checksum;
} zigbee_frame_tx;

typedef struct {
        uint8_t size_data;
	uint16_t address;
	uint8_t rssi;
	uint8_t option;
        char data[100];  
	uint8_t checksum;
} zigbee_frame_rx;

zigbee_frame_tx wrap_frame(uint8_t frame_number, uint16_t address, uint8_t option, char *data);

void zigbee_init(void);
void zigbee_send_msg(char *str, uint16_t addr);
void process_frame(zigbee_frame_rx frame);
void loop_ok(char *str);
int str_in_str(char *src, char *pattern, int length);

#endif
