#ifndef _REMOTE_FLASH_H_
#define _REMOTE_FLASH_H_

/*
 * Robot's registers
 */
#define REGB_MODE       0
#define REGB_ELCOUNT    8
#define REGB_VER        26

#define REGB_FREQ       1
#define REGB_FREQ_B     1
#define REGB_FREQ_L     5
#define REGB_AMPL       3
#define REGB_AMPL_B     3
#define REGB_AMPL_L     6
#define REGB_TURN       2
#define REGB_PHASE      4
#define REGB_LED        7

#define REGMB_GAINS     0

/*
 * Salamandra's modes
 */
#define MODE_IDLE             0
#define MODE_INIT             1
#define MODE_RUN              2
#define MODE_STOP             3
#define MODE_BATTERY_CHARGE   4
#define MODE_RUN_NO_DRIVE     5
#define MODE_RUN_IR_FOLLOW    6

void salamandra_connect(uint8_t channel);
uint8_t salamandra_init(char error_buffer[]);
void salamandra_stop(void);

#endif
