#ifndef _RADIO_REG_OP_H_
#define _RADIO_REG_OP_H_

#define REG_OP_OK 1
#define REG_OP_ERROR 0

#define REG_INTF_VER 0x3C0   // Radio interface's version
#define REG_INTF_CH  0x3C1   // Local (radio interface) channel number
#define REG_RWL_VER  0x3E0   // Remote radio firmware's version
#define REG_RWL_CH   0x3E1   // Remote channel number (= REG_INTF_CH, if the communication is set)

uint8_t reg_op(uint8_t op, uint16_t addr, uint8_t *data, uint8_t length);
uint8_t get_reg_b(uint16_t addr, uint8_t *result);
uint8_t get_reg_w(uint16_t addr, uint16_t *result);
uint8_t get_reg_dw(uint16_t addr, uint32_t *result);
uint8_t get_reg_mb(uint16_t addr, uint8_t *length, uint8_t *result);
uint8_t set_reg_b(uint16_t addr, uint8_t data);
uint8_t set_reg_w(uint16_t addr, uint16_t data);
uint8_t set_reg_dw(uint16_t addr, uint32_t data);
uint8_t set_reg_mb(uint16_t addr, uint8_t *data, uint8_t length);

#endif
