#ifndef _REMOTE_FLASH_H_
#define _REMOTE_FLASH_H_

#define CHOICE_NUMBER        5
#define BUFFER_DEPTH         32
#define ERROR_MSG_MAX_LENGTH 64
#define CONNECTION_ATTEMPT   16
#define SLIDING_TEXT_LENGTH  64

typedef enum {UP, DOWN, LEFT, RIGHT, NONE} PRESSED_BUTTON;
typedef enum {MAIN, MUSIC, BATTERY, CONNECTION, RADIO, SELECT_CHANNEL, SCAN, SELECT_ROBOT, IN_PROGRESS, ROBOT, ROBOT_STARTING, ROBOT_STARTED, FLASHING, ERROR_STATE} MENU;

typedef struct {
  char menu_buffer[BUFFER_DEPTH];
  MENU next_menu;
} MENU_ENTRY;

void menu_entry_define(MENU_ENTRY *menu_entry, char *str, MENU next_menu);
void menu_do_pressed_button(MENU_ENTRY menu_entry[], uint8_t *current_menu_entry);
void lcd_copy_str_in_buffer(char *str, char buffer[], uint8_t *str_length);
void menu_init(void);

#endif
