#include "ch.h"
#include "hal.h"
#include "buzzer.h"

static void pwmpcb(PWMDriver *pwmp) {

  (void)pwmp;
  palSetPad(GPIOA, 8);
}

static void pwmc1cb(PWMDriver *pwmp) {

  (void)pwmp;
  palClearPad(GPIOA, 8);
}

static PWMConfig pwmcfg = {
  2000000,                              /* 2MHz PWM clock frequency.              */
  2000000/440,                          /* Initial PWM period, playing a 440Hz LA.*/
  pwmpcb,
  {
    {PWM_OUTPUT_ACTIVE_HIGH, pwmc1cb},
    {PWM_OUTPUT_DISABLED, NULL},
    {PWM_OUTPUT_DISABLED, NULL},
    {PWM_OUTPUT_DISABLED, NULL}
  },
  0,
#if STM32_PWM_USE_ADVANCED
  0
#endif
};

void buzzer_init(void)
{
  /*
   * Initializes the PWM driver 1.
   */
  pwmStart(&PWMD1, &pwmcfg);
  chThdSleepMilliseconds(2000);
  
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmChangePeriod(&PWMD1, 2000000/440);
}

void play_mario(void)
{
  pwmStart(&PWMD1, &pwmcfg);
  chThdSleepMilliseconds(2000);

  pwmChangePeriod(&PWMD1, 2000000/660);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/660);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/660);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/510);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(100);
  pwmChangePeriod(&PWMD1, 2000000/660);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/770);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(550);
  pwmChangePeriod(&PWMD1, 2000000/380);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(575);

  pwmChangePeriod(&PWMD1, 2000000/510);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(450);
  pwmChangePeriod(&PWMD1, 2000000/380);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(400);
  pwmChangePeriod(&PWMD1, 2000000/320);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(500);
  pwmChangePeriod(&PWMD1, 2000000/440);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/480);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(330);
  pwmChangePeriod(&PWMD1, 2000000/450);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/430);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/380);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(200);
  pwmChangePeriod(&PWMD1, 2000000/660);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(200);
  pwmChangePeriod(&PWMD1, 2000000/760);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(50);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/860);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/700);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/760);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(50);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(350);
  pwmChangePeriod(&PWMD1, 2000000/660);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/520);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/580);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/480);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(500);

  pwmChangePeriod(&PWMD1, 2000000/510);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(450);
  pwmChangePeriod(&PWMD1, 2000000/380);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(400);
  pwmChangePeriod(&PWMD1, 2000000/320);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(500);
  pwmChangePeriod(&PWMD1, 2000000/440);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/480);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(330);
  pwmChangePeriod(&PWMD1, 2000000/450);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/430);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/380);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(200);
  pwmChangePeriod(&PWMD1, 2000000/660);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(200);
  pwmChangePeriod(&PWMD1, 2000000/760);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(50);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/860);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/700);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/760);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(50);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(350);
  pwmChangePeriod(&PWMD1, 2000000/660);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/520);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/580);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/480);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(500);

  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/760);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(100);
  pwmChangePeriod(&PWMD1, 2000000/720);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/680);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/620);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(150);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/650);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(150);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/380);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/430);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);

  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/430);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(100);
  pwmChangePeriod(&PWMD1, 2000000/570);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(220);

  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/760);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(100);
  pwmChangePeriod(&PWMD1, 2000000/720);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/680);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/620);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(150);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/650);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(200);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/1020);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/1020);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/1020);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/380);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/760);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(100);
  pwmChangePeriod(&PWMD1, 2000000/720);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/680);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/620);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(150);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/650);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(150);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/380);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/430);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);

  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/430);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(100);
  pwmChangePeriod(&PWMD1, 2000000/570);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(420);

  pwmChangePeriod(&PWMD1, 2000000/585);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(450);

  pwmChangePeriod(&PWMD1, 2000000/550);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(420);

  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(360);

  pwmChangePeriod(&PWMD1, 2000000/380);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/760);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(100);
  pwmChangePeriod(&PWMD1, 2000000/720);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/680);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/620);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(150);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/650);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(150);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/380);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/430);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);

  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/430);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(100);
  pwmChangePeriod(&PWMD1, 2000000/570);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(220);

  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/760);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(100);
  pwmChangePeriod(&PWMD1, 2000000/720);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/680);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/620);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(150);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/650);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(200);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/1020);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/1020);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/1020);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/380);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/760);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(100);
  pwmChangePeriod(&PWMD1, 2000000/720);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/680);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/620);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(150);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/650);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(150);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/380);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/430);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);

  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/430);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(100);
  pwmChangePeriod(&PWMD1, 2000000/570);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(420);

  pwmChangePeriod(&PWMD1, 2000000/585);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(450);

  pwmChangePeriod(&PWMD1, 2000000/550);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(420);

  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(360);

  pwmChangePeriod(&PWMD1, 2000000/380);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);

  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(60);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(60);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(350);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/580);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(350);
  pwmChangePeriod(&PWMD1, 2000000/660);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/430);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/380);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(600);

  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(60);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(60);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(350);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/580);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/660);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(550);

  pwmChangePeriod(&PWMD1, 2000000/870);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(325);
  pwmChangePeriod(&PWMD1, 2000000/760);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(600);

  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(60);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(60);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(350);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/580);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(350);
  pwmChangePeriod(&PWMD1, 2000000/660);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/500);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/430);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/380);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(80);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(600);

  pwmChangePeriod(&PWMD1, 2000000/660);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(150);
  pwmChangePeriod(&PWMD1, 2000000/660);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/660);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/510);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(100);
  pwmChangePeriod(&PWMD1, 2000000/660);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(300);
  pwmChangePeriod(&PWMD1, 2000000/770);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(550);
  pwmChangePeriod(&PWMD1, 2000000/380);
  pwmEnableChannel(&PWMD1, 0, PWM_PERCENTAGE_TO_WIDTH(&PWMD1, 5000));
  chThdSleepMilliseconds(100);
  pwmDisableChannel(&PWMD1, 0);
  chThdSleepMilliseconds(575);
  
  pwmStop(&PWMD1);
}
