#include "ch.h"
#include "hal.h"
#include "buttons.h"
#include "lcd.h"

uint8_t input_button = 0;

/* Triggered when the button 1 is pressed */
static void extcb1(EXTDriver *extp, expchannel_t channel) {

  (void)extp;
  (void)channel;

  uint32_t counter = 0;
  
  while(!palReadPad(GPIOC, 13) && counter < 250000) {
    counter++;
  }
  
  if (counter > 225000)
    input_button = 1;

  chSysLockFromIsr();

  chSysUnlockFromIsr();
}

/* Triggered when the button 2 is pressed */
static void extcb2(EXTDriver *extp, expchannel_t channel) {

  (void)extp;
  (void)channel;

  uint32_t counter = 0;
  
  while(!palReadPad(GPIOC, 14) && counter < 250000) {
    counter++;
  }
  
  if (counter > 225000)
    input_button = 2;

  chSysLockFromIsr();

  chSysUnlockFromIsr();
}

/* Triggered when the button 3 is pressed */
static void extcb3(EXTDriver *extp, expchannel_t channel) {

  (void)extp;
  (void)channel;

  uint32_t counter = 0;
  
  while(!palReadPad(GPIOC, 15) && counter < 250000) {
    counter++;
  }
  
  if (counter > 225000)
    input_button = 3;

  chSysLockFromIsr();
  
  chSysUnlockFromIsr();
}

/* Triggered when the button 4 is pressed */
static void extcb4(EXTDriver *extp, expchannel_t channel) {

  (void)extp;
  (void)channel;

  uint32_t counter = 0;
  
  while(!palReadPad(GPIOB, 5) && counter < 250000) {
    counter++;
  }
  
  if (counter > 225000)
    input_button = 4;

  chSysLockFromIsr();
  
  chSysUnlockFromIsr();
}

/* Triggered when the joystick button 1 is pressed */
static void extcbjoy1(EXTDriver *extp, expchannel_t channel) {

  (void)extp;
  (void)channel;

  uint32_t counter = 0;
  
  while(!palReadPad(GPIOB, 8) && counter < 250000) {
    counter++;
  }
  
  if (counter > 225000)
    input_button = 5;

  chSysLockFromIsr();

  chSysUnlockFromIsr();
}

/* Triggered when the joystick button 2 is pressed */
static void extcbjoy2(EXTDriver *extp, expchannel_t channel) {

  (void)extp;
  (void)channel;

  uint32_t counter = 0;
  
  while(!palReadPad(GPIOB, 9) && counter < 250000) {
    counter++;
  }
  
  if (counter > 225000)
    input_button = 6;

  chSysLockFromIsr();
  chSysUnlockFromIsr();
}

static const EXTConfig extcfg = {
  {
   {EXT_CH_MODE_DISABLED, NULL},
   {EXT_CH_MODE_DISABLED, NULL},
   {EXT_CH_MODE_DISABLED, NULL},
   {EXT_CH_MODE_DISABLED, NULL},
   {EXT_CH_MODE_DISABLED, NULL},
   {EXT_CH_MODE_FALLING_EDGE | EXT_CH_MODE_AUTOSTART, extcb4},
   {EXT_CH_MODE_DISABLED, NULL},
   {EXT_CH_MODE_DISABLED, NULL},
   {EXT_CH_MODE_FALLING_EDGE | EXT_CH_MODE_AUTOSTART, extcbjoy1},
   {EXT_CH_MODE_FALLING_EDGE | EXT_CH_MODE_AUTOSTART, extcbjoy2},
   {EXT_CH_MODE_DISABLED, NULL},
   {EXT_CH_MODE_DISABLED, NULL},
   {EXT_CH_MODE_DISABLED, NULL},
   {EXT_CH_MODE_FALLING_EDGE | EXT_CH_MODE_AUTOSTART, extcb1},
   {EXT_CH_MODE_FALLING_EDGE | EXT_CH_MODE_AUTOSTART, extcb2},
   {EXT_CH_MODE_FALLING_EDGE | EXT_CH_MODE_AUTOSTART, extcb3},
  },
  EXT_MODE_EXTI(0,
                0,
                0,
                0,
                0,
                EXT_MODE_GPIOB,   /* Button 4 */
                0,
                0,
                EXT_MODE_GPIOB,   /* Button Joystick 1 */
                EXT_MODE_GPIOB,   /* Button Joystick 2 */
                0,
                0,
                0,
                EXT_MODE_GPIOC,   /* Button 1 */
                EXT_MODE_GPIOC,   /* Button 2 */
                EXT_MODE_GPIOC)   /* Button 3 */
};

void buttons_init(void)
{
  /*
   * Activates the EXT driver 1.
   */
  extStart(&EXTD1, &extcfg);
}
