function out = get_maple_DS(scenario) 

% This function calculates 3LP equations in the double support phase
% Author:         Salman Faraji
% Date:           March 2018
% Available from: https://biorob.epfl.ch/research/humanoid/walkman
%  All rights reserved. ECOLE POLYTECHNIQUE FEDERALE DE LAUSANNE, Switzerland
% BIOROB Laboratory, 2018
% Walking3LP must be referenced when used in a published work 
% See the LICENSE.pdf file for more details.

out = struct(); 
maple_model; 


A0 = zeros(4,25); 
t4 = h1 ^ 2;
t6 = m1 * t4 * cos_slope;
t7 = m2 * cos_slope;
t8 = t7 * t4;
t16 = h2 ^ 2;
t22 = 0.1e1 / (cos_theta * m1 * h3 * h1 - 0.4e1 * t7 * h2 * h1 + cos_slope * I2 + cos_slope * I3 + 0.2e1 * t7 * t16 + t6 + 0.2e1 * t8);
t24 = t22 / Tds;
t25 = Tds * g;
t26 = t25 * h1;
t28 = m1 * rg * cos_slope;
t29 = t26 * t28;
t31 = m2 * rg * cos_slope;
t33 = 0.2e1 * t26 * t31;
t36 = t25 * h1 * m1 * cos_slope;
t40 = 0.2e1 * t25 * h1 * m2 * cos_slope;
t42 = h2 * m2 * cos_slope;
t43 = t25 * t42;
A0(1,1) = t24 * (t29 + t33 - t36 - t40 + t43);
A0(2,2) = A0(1,1);
A0(1,3) = t24 * (-t29 - t33 + t36 + t40 - 0.2e1 * t43);
A0(2,4) = A0(1,3);
t47 = t22 * g;
A0(1,9) = t47 * t42;
A0(2,10) = A0(1,9);
A0(1,13) = t22 * h1;
A0(2,14) = A0(1,13);
A0(1,17) = A0(2,14);
A0(2,18) = A0(1,17);
A0(1,19) = t24 * (Tds * h1 * h4 * cos_theta + Tds * t4 * cos_slope);
A0(2,20) = A0(1,19);
A0(1,21) = A0(2,18);
A0(2,22) = -A0(1,21);
t55 = h3 * m1;
A0(1,23) = t47 * h1 * t55 * cos_slope;
t57 = t25 * t4;
A0(1,24) = t24 * (-t26 * t55 * cos_theta - t25 * t6 - 0.2e1 * t25 * t8 + 0.2e1 * t26 * t42 + t57 * t28 + 0.2e1 * t57 * t31);
out.A0 = A0; 
At = zeros(4,25); 
t4 = h1 ^ 2;
t7 = m2 * cos_slope;
t16 = h2 ^ 2;
t24 = 0.1e1 / (cos_theta * m1 * h3 * h1 - 0.4e1 * t7 * h2 * h1 + m1 * t4 * cos_slope + cos_slope * I2 + cos_slope * I3 + 0.2e1 * t7 * t16 + 0.2e1 * t7 * t4) / Tds;
t25 = g * h1;
t37 = -t25 * m1 * rg * cos_slope - 0.2e1 * t25 * m2 * rg * cos_slope + t25 * m1 * cos_slope + 0.2e1 * t25 * t7;
At(1,1) = t24 * t37;
At(2,2) = At(1,1);
At(1,9) = -t24 * t37;
At(2,10) = At(1,9);
t39 = t24 * h1;
At(2,14) = -0.2e1 * t39;
At(1,17) = -t39;
At(2,18) = At(1,17);
out.At = At; 
W1 = sqrt(A0(1,3));
W2 = sqrt(A0(2,4));
out.w(1) = W1;
out.w(2) = -W1;
out.w(3) = W2;
out.w(4) = -W2;

 
 
out.Ur1 = zeros(25,25); 
out.Ur1(1,1) = 0.1e1;
t5 = 0.1e1 / A0(1,3);
out.Ur1(3,1) = -t5 * A0(1,1);
out.Ur1(7,1) = -t5 * At(1,1);
out.Ur1(2,2) = 0.1e1;
t11 = 0.1e1 / A0(2,4);
out.Ur1(4,2) = -t11 * A0(2,2);
out.Ur1(8,2) = -t11 * At(2,2);
out.Ur1(3,9) = -t5 * A0(1,9);
out.Ur1(7,9) = -t5 * At(1,9);
out.Ur1(9,9) = 0.1e1;
out.Ur1(4,10) = -t11 * A0(2,10);
out.Ur1(8,10) = -t11 * At(2,10);
out.Ur1(10,10) = 0.1e1;
out.Ur1(11,11) = 0.1e1;
out.Ur1(12,12) = 0.1e1;
out.Ur1(3,13) = -t5 * A0(1,13);
out.Ur1(13,13) = 0.1e1;
out.Ur1(4,14) = -t11 * A0(2,14);
out.Ur1(8,14) = -t11 * At(2,14);
out.Ur1(14,14) = 0.1e1;
out.Ur1(15,15) = 0.1e1;
out.Ur1(16,16) = 0.1e1;
out.Ur1(3,17) = -A0(1,17) * t5;
out.Ur1(7,17) = -t5 * At(1,17);
out.Ur1(17,17) = 0.1e1;
out.Ur1(4,18) = -t11 * A0(2,18);
out.Ur1(8,18) = -t11 * At(2,18);
out.Ur1(18,18) = 0.1e1;
out.Ur1(3,19) = -t5 * A0(1,19);
out.Ur1(19,19) = 0.1e1;
out.Ur1(4,20) = -t11 * A0(2,20);
out.Ur1(20,20) = 0.1e1;
out.Ur1(3,21) = -t5 * A0(1,21);
out.Ur1(21,21) = 0.1e1;
out.Ur1(4,22) = -t11 * A0(2,22);
out.Ur1(22,22) = 0.1e1;
out.Ur1(3,23) = -A0(1,23) * t5;
out.Ur1(23,23) = 0.1e1;
out.Ur1(3,24) = -A0(1,24) * t5;
out.Ur1(24,24) = 0.1e1;
out.Ur1(25,25) = 0.1e1;
out.Vr1 = zeros(25,25); 
t5 = 0.1e1 / A0(1,3);
out.Vr1(3,1) = -t5 * At(1,1);
t9 = 0.1e1 / A0(2,4);
out.Vr1(4,2) = -t9 * At(2,2);
out.Vr1(3,9) = -t5 * At(1,9);
out.Vr1(4,10) = -t9 * At(2,10);
out.Vr1(4,14) = -t9 * At(2,14);
out.Vr1(3,17) = -t5 * At(1,17);
out.Vr1(4,18) = -t9 * At(2,18);
out.Ur2 = zeros(25,25); 
t4 = A0(1,3);
t5 = sqrt(t4);
t7 = 0.1e1 / t5 / t4;
t8 = A0(1,1);
t10 = At(1,1);
out.Ur2(3,1) = t7 * (t5 * t8 + t10) / 0.2e1;
t13 = W1 * t5;
out.Ur2(7,1) = t7 * (W1 * t10 + t13 * t8) / 0.2e1;
out.Ur2(3,3) = 0.1e1 / 0.2e1;
out.Ur2(7,3) = W1 / 0.2e1;
t18 = 0.1e1 / t5;
out.Ur2(3,7) = t18 / 0.2e1;
out.Ur2(7,7) = W1 * t18 / 0.2e1;
t20 = A0(1,9);
t22 = At(1,9);
out.Ur2(3,9) = t7 * (t5 * t20 + t22) / 0.2e1;
out.Ur2(7,9) = t7 * (W1 * t22 + t13 * t20) / 0.2e1;
t29 = 0.1e1 / t4;
t30 = A0(1,13);
out.Ur2(3,13) = t29 * t30 / 0.2e1;
t32 = t29 * W1;
out.Ur2(7,13) = t32 * t30 / 0.2e1;
t34 = A0(1,17);
t36 = At(1,17);
out.Ur2(3,17) = t7 * (t5 * t34 + t36) / 0.2e1;
out.Ur2(7,17) = t7 * (W1 * t36 + t13 * t34) / 0.2e1;
t43 = A0(1,19);
out.Ur2(3,19) = t29 * t43 / 0.2e1;
out.Ur2(7,19) = t32 * t43 / 0.2e1;
t46 = A0(1,21);
out.Ur2(3,21) = t29 * t46 / 0.2e1;
out.Ur2(7,21) = t32 * t46 / 0.2e1;
t49 = A0(1,23);
out.Ur2(3,23) = t49 * t29 / 0.2e1;
out.Ur2(7,23) = t32 * t49 / 0.2e1;
t52 = A0(1,24);
out.Ur2(3,24) = t52 * t29 / 0.2e1;
out.Ur2(7,24) = t32 * t52 / 0.2e1;
out.Vr2 = zeros(25,25); 
t5 = 0.1e1 / A0(1,3);
t6 = At(1,1);
out.Vr2(3,1) = t5 * t6 / 0.2e1;
t8 = W1 * t5;
out.Vr2(7,1) = t8 * t6 / 0.2e1;
t10 = At(1,9);
out.Vr2(3,9) = t5 * t10 / 0.2e1;
out.Vr2(7,9) = t8 * t10 / 0.2e1;
t13 = At(1,17);
out.Vr2(3,17) = t5 * t13 / 0.2e1;
out.Vr2(7,17) = t13 * t8 / 0.2e1;
out.Ur3 = zeros(25,25); 
t4 = A0(1,3);
t5 = sqrt(t4);
t7 = 0.1e1 / t5 / t4;
t8 = A0(1,1);
t10 = At(1,1);
out.Ur3(3,1) = t7 * (t5 * t8 - t10) / 0.2e1;
t13 = W1 * t5;
out.Ur3(7,1) = t7 * (W1 * t10 - t13 * t8) / 0.2e1;
out.Ur3(3,3) = 0.1e1 / 0.2e1;
out.Ur3(7,3) = -W1 / 0.2e1;
t19 = 0.1e1 / t5;
out.Ur3(3,7) = -t19 / 0.2e1;
out.Ur3(7,7) = W1 * t19 / 0.2e1;
t22 = A0(1,9);
t24 = At(1,9);
out.Ur3(3,9) = t7 * (t5 * t22 - t24) / 0.2e1;
out.Ur3(7,9) = t7 * (W1 * t24 - t13 * t22) / 0.2e1;
t31 = 0.1e1 / t4;
t32 = A0(1,13);
out.Ur3(3,13) = t31 * t32 / 0.2e1;
t34 = t31 * W1;
out.Ur3(7,13) = -t34 * t32 / 0.2e1;
t37 = A0(1,17);
t39 = At(1,17);
out.Ur3(3,17) = t7 * (t5 * t37 - t39) / 0.2e1;
out.Ur3(7,17) = t7 * (W1 * t39 - t13 * t37) / 0.2e1;
t46 = A0(1,19);
out.Ur3(3,19) = t31 * t46 / 0.2e1;
out.Ur3(7,19) = -t34 * t46 / 0.2e1;
t50 = A0(1,21);
out.Ur3(3,21) = t31 * t50 / 0.2e1;
out.Ur3(7,21) = -t34 * t50 / 0.2e1;
t54 = A0(1,23);
out.Ur3(3,23) = t54 * t31 / 0.2e1;
out.Ur3(7,23) = -t34 * t54 / 0.2e1;
t58 = A0(1,24);
out.Ur3(3,24) = t58 * t31 / 0.2e1;
out.Ur3(7,24) = -t34 * t58 / 0.2e1;
out.Vr3 = zeros(25,25); 
t5 = 0.1e1 / A0(1,3);
t6 = At(1,1);
out.Vr3(3,1) = t5 * t6 / 0.2e1;
t8 = W1 * t5;
out.Vr3(7,1) = -t8 * t6 / 0.2e1;
t11 = At(1,9);
out.Vr3(3,9) = t5 * t11 / 0.2e1;
out.Vr3(7,9) = -t8 * t11 / 0.2e1;
t15 = At(1,17);
out.Vr3(3,17) = t5 * t15 / 0.2e1;
out.Vr3(7,17) = -t8 * t15 / 0.2e1;
out.Ur4 = zeros(25,25); 
t4 = A0(2,4);
t5 = sqrt(t4);
t7 = 0.1e1 / t5 / t4;
t8 = A0(2,2);
t10 = At(2,2);
out.Ur4(4,2) = t7 * (t5 * t8 + t10) / 0.2e1;
t13 = W2 * t5;
out.Ur4(8,2) = (W2 * t10 + t13 * t8) * t7 / 0.2e1;
out.Ur4(4,4) = 0.1e1 / 0.2e1;
out.Ur4(8,4) = W2 / 0.2e1;
t18 = 0.1e1 / t5;
out.Ur4(4,8) = t18 / 0.2e1;
out.Ur4(8,8) = W2 * t18 / 0.2e1;
t20 = A0(2,10);
t22 = At(2,10);
out.Ur4(4,10) = t7 * (t5 * t20 + t22) / 0.2e1;
out.Ur4(8,10) = t7 * (W2 * t22 + t13 * t20) / 0.2e1;
t29 = A0(2,14);
t31 = At(2,14);
out.Ur4(4,14) = t7 * (t5 * t29 + t31) / 0.2e1;
out.Ur4(8,14) = (W2 * t31 + t13 * t29) * t7 / 0.2e1;
t38 = A0(2,18);
t40 = At(2,18);
out.Ur4(4,18) = t7 * (t5 * t38 + t40) / 0.2e1;
out.Ur4(8,18) = (W2 * t40 + t13 * t38) * t7 / 0.2e1;
t47 = 0.1e1 / t4;
t48 = A0(2,20);
out.Ur4(4,20) = t47 * t48 / 0.2e1;
t50 = t47 * W2;
out.Ur4(8,20) = t50 * t48 / 0.2e1;
t52 = A0(2,22);
out.Ur4(4,22) = t47 * t52 / 0.2e1;
out.Ur4(8,22) = t50 * t52 / 0.2e1;
out.Vr4 = zeros(25,25); 
t5 = 0.1e1 / A0(2,4);
t6 = At(2,2);
out.Vr4(4,2) = t5 * t6 / 0.2e1;
t8 = W2 * t5;
out.Vr4(8,2) = t8 * t6 / 0.2e1;
t10 = At(2,10);
out.Vr4(4,10) = t5 * t10 / 0.2e1;
out.Vr4(8,10) = t8 * t10 / 0.2e1;
t13 = At(2,14);
out.Vr4(4,14) = t5 * t13 / 0.2e1;
out.Vr4(8,14) = t13 * t8 / 0.2e1;
t16 = At(2,18);
out.Vr4(4,18) = t5 * t16 / 0.2e1;
out.Vr4(8,18) = t8 * t16 / 0.2e1;
out.Ur5 = zeros(25,25); 
t4 = A0(2,4);
t5 = sqrt(t4);
t7 = 0.1e1 / t5 / t4;
t8 = A0(2,2);
t10 = At(2,2);
out.Ur5(4,2) = t7 * (t5 * t8 - t10) / 0.2e1;
t13 = W2 * t5;
out.Ur5(8,2) = (W2 * t10 - t13 * t8) * t7 / 0.2e1;
out.Ur5(4,4) = 0.1e1 / 0.2e1;
out.Ur5(8,4) = -W2 / 0.2e1;
t19 = 0.1e1 / t5;
out.Ur5(4,8) = -t19 / 0.2e1;
out.Ur5(8,8) = W2 * t19 / 0.2e1;
t22 = A0(2,10);
t24 = At(2,10);
out.Ur5(4,10) = t7 * (t5 * t22 - t24) / 0.2e1;
out.Ur5(8,10) = t7 * (W2 * t24 - t13 * t22) / 0.2e1;
t31 = A0(2,14);
t33 = At(2,14);
out.Ur5(4,14) = t7 * (t5 * t31 - t33) / 0.2e1;
out.Ur5(8,14) = (W2 * t33 - t13 * t31) * t7 / 0.2e1;
t40 = A0(2,18);
t42 = At(2,18);
out.Ur5(4,18) = t7 * (t5 * t40 - t42) / 0.2e1;
out.Ur5(8,18) = (W2 * t42 - t13 * t40) * t7 / 0.2e1;
t49 = 0.1e1 / t4;
t50 = A0(2,20);
out.Ur5(4,20) = t49 * t50 / 0.2e1;
t52 = t49 * W2;
out.Ur5(8,20) = -t50 * t52 / 0.2e1;
t55 = A0(2,22);
out.Ur5(4,22) = t49 * t55 / 0.2e1;
out.Ur5(8,22) = -t52 * t55 / 0.2e1;
out.Vr5 = zeros(25,25); 
t5 = 0.1e1 / A0(2,4);
t6 = At(2,2);
out.Vr5(4,2) = t5 * t6 / 0.2e1;
t8 = W2 * t5;
out.Vr5(8,2) = -t8 * t6 / 0.2e1;
t11 = At(2,10);
out.Vr5(4,10) = t5 * t11 / 0.2e1;
out.Vr5(8,10) = -t8 * t11 / 0.2e1;
t15 = At(2,14);
out.Vr5(4,14) = t5 * t15 / 0.2e1;
out.Vr5(8,14) = -t8 * t15 / 0.2e1;
t19 = At(2,18);
out.Vr5(4,18) = t5 * t19 / 0.2e1;
out.Vr5(8,18) = -t8 * t19 / 0.2e1;
out.Ur6 = zeros(25,25); 
t5 = 0.1e1 / A0(1,3);
out.Ur6(3,1) = -t5 * At(1,1);
t9 = 0.1e1 / A0(2,4);
out.Ur6(4,2) = -t9 * At(2,2);
out.Ur6(3,9) = -t5 * At(1,9);
out.Ur6(4,10) = -t9 * At(2,10);
out.Ur6(4,14) = -t9 * At(2,14);
out.Ur6(3,17) = -t5 * At(1,17);
out.Ur6(4,18) = -t9 * At(2,18);
out.Vr6 = zeros(25,25); 
