function out = vis_maple_SS(state_vector,scenario,t) 

% This function calculates extra 3LP variables based on the state vector in
% the single support phase
% Author:         Salman Faraji
% Date:           March 2018
% Available from: https://biorob.epfl.ch/research/humanoid/walkman
%  All rights reserved. ECOLE POLYTECHNIQUE FEDERALE DE LAUSANNE, Switzerland
% BIOROB Laboratory, 2018
% Walking3LP must be referenced when used in a published work 
% See the LICENSE.txt file for more details.

out = struct(); 
maple_model; 


X2_(1) = state_vector(1);
X2_(2) = state_vector(2);
X_(1) = state_vector(3);
X_(2) = state_vector(4);
dX2_(1) = state_vector(5);
dX2_(2) = state_vector(6);
dX_(1) = state_vector(7);
dX_(2) = state_vector(8);
X3_(1) = state_vector(9);
X3_(2) = state_vector(10);
H2y = state_vector(11);
H2x = state_vector(12);
M3y = state_vector(13);
M3x = state_vector(14);
rH2y = state_vector(15);
rH2x = state_vector(16);
rM3y = state_vector(17);
rM3x = state_vector(18);
F1_(1) = state_vector(19);
F1_(2) = state_vector(20);
T1_(2) = state_vector(21);
T1_(1) = state_vector(22);
sin_theta = state_vector(23);
sin_slope = state_vector(24);
d = state_vector(25);

 
 
X_(1) = X_(1);
X_(2) = X_(2);
X_(3) = h1 * cos_slope;

x2_(1) = X_(1);
x2_(2) = d * pw + X_(2);
x2_(3) = h1 * cos_slope;

x3_(1) = X_(1);
x3_(2) = -d * pw + X_(2);
x3_(3) = h1 * cos_slope;

y1_(1) = h3 * sin_theta + X_(1);
y1_(2) = X_(2);
y1_(3) = h1 * cos_slope + h3 * cos_theta;

t5 = 0.1e1 / h1 * h2;
t9 = d * pw;
y2_(1) = X_(1) + (X2_(1) - X_(1)) * t5;
y2_(2) = X_(2) + t9 + (-t9 + X2_(2) - X_(2)) * t5;
y2_(3) = h1 * cos_slope - h2 * cos_slope;

t5 = 0.1e1 / h1 * h2;
t9 = d * pw;
y3_(1) = X_(1) + (X3_(1) - X_(1)) * t5;
y3_(2) = X_(2) - t9 + (t9 + X3_(2) - X_(2)) * t5;
y3_(3) = h1 * cos_slope - h2 * cos_slope;

X3_(1) = X3_(1);
X3_(2) = X3_(2);
X3_(3) = 0.0e0;

X2_(1) = X2_(1);
X2_(2) = X2_(2);
X2_(3) = 0.0e0;

X1_(1) = h4 * sin_theta + X_(1);
X1_(2) = X_(2);
X1_(3) = h1 * cos_slope + h4 * cos_theta;

t7 = m1 * h1;
t9 = m2 * h1;
t12 = m2 * h2;
t20 = 0.1e1 / (m1 + 0.2e1 * m2);
t22 = 0.1e1 / h1;
com_(1) = t22 * t20 * (h1 * h3 * m1 * sin_theta + X2_(1) * t12 + X3_(1) * t12 - 0.2e1 * X_(1) * t12 + X_(1) * t7 + 0.2e1 * X_(1) * t9);
com_(2) = t22 * t20 * (X2_(2) * t12 + X3_(2) * t12 - 0.2e1 * X_(2) * t12 + X_(2) * t7 + 0.2e1 * X_(2) * t9);
com_(3) = t20 * (h3 * cos_theta * m1 - 0.2e1 * cos_slope * t12 + cos_slope * t7 + 0.2e1 * cos_slope * t9);

t4 = m1 * h1;
t6 = m2 * h1;
t9 = m2 * h2;
t16 = 0.1e1 / (m1 + 0.2e1 * m2);
t18 = 0.1e1 / h1;
dcom_(1) = t18 * t16 * (dX_(1) * t4 + 0.2e1 * dX_(1) * t6 + dX2_(1) * t9 - 0.2e1 * dX_(1) * t9);
dcom_(2) = t18 * t16 * (dX_(2) * t4 + 0.2e1 * dX_(2) * t6 + dX2_(2) * t9 - 0.2e1 * dX_(2) * t9);
dcom_(3) = 0.0e0;

dX_(1) = dX_(1);
dX_(2) = dX_(2);
dX_(3) = 0.0e0;

dX2_(1) = dX2_(1);
dX2_(2) = dX2_(2);
dX2_(3) = 0.0e0;

X0_(1) = h5 * sin_theta + X_(1);
X0_(2) = X_(2);
X0_(3) = h1 * cos_slope + h5 * cos_theta;

t4 = h1 ^ 2;
t5 = h2 ^ 2;
t6 = t5 * t4;
t7 = m2 * m1;
t10 = m2 ^ 2;
t11 = cos_slope * t10;
t13 = t5 * h2;
t17 = t5 * h1;
t21 = t5 ^ 2;
t24 = t4 * I2;
t27 = m2 * cos_slope;
t30 = I2 * h1;
t31 = m2 * h2;
t35 = m1 * h3;
t44 = cos_theta * t7 * h3 * t17 + I2 * I3 * cos_slope + t27 * t5 * I2 + t27 * t5 * I3 - 0.2e1 * t11 * t13 * h1 + m1 * cos_slope * t24 + cos_slope * t10 * t21 - 0.2e1 * cos_slope * t31 * t30 + cos_theta * t35 * t30 + cos_slope * t7 * t6 + t11 * t6 + 0.2e1 * t27 * t24;
t45 = 0.1e1 / t44;
t46 = Tss * g;
t47 = t6 * t46;
t48 = cos_slope * rg;
t52 = rg * t10;
t53 = cos_slope * sin_slope;
t60 = t10 * t5;
t63 = h1 * t46;
t64 = t10 * t13;
t67 = t17 * t46;
t82 = X3_(1) * cos_slope;
t86 = cos_slope * X_(1);
t90 = I2 * Tss;
t92 = t4 * g * t90;
t93 = m1 * rg;
t96 = m2 * cos_theta * sin_slope * t35 * t67 - rg * X3_(1) * cos_slope * t7 * t67 - sin_theta * t27 * t35 * t67 + t53 * t60 * t4 * t46 - sin_slope * t48 * t7 * t47 + X_(1) * t48 * t7 * t67 - 0.2e1 * t53 * t52 * t47 + t53 * t7 * t47 - 0.2e1 * t82 * t52 * t67 + 0.2e1 * t86 * t52 * t67 - t53 * t64 * t63 - t53 * t93 * t92;
t97 = m2 * rg;
t113 = t13 * t46;
t119 = g * t90;
t127 = g * h1;
t128 = t127 * t90;
t137 = t53 * m1 * t4 * t119 + 0.2e1 * t53 * m2 * t4 * t119 - cos_slope * X3_(1) * t10 * t113 - cos_slope * sin_theta * t35 * t128 + cos_theta * sin_slope * t35 * t128 - cos_slope * X2_(1) * t60 * t63 + X_(1) * t11 * t113 - t53 * t31 * t128 - 0.2e1 * t53 * t97 * t92 + 0.2e1 * t82 * t60 * t63 - t86 * t60 * t63 + t82 * t7 * t67 - t86 * t7 * t67;
t150 = t5 * t4 * Tss;
t154 = h1 * Tss;
t155 = t5 * t154;
t156 = h4 * m2;
t160 = m1 * h1;
t165 = m2 * h1;
t176 = H2y * Tss;
t177 = h2 * t4;
t178 = m2 * t177;
t180 = -m2 * F1_(1) * cos_slope * t150 - F1_(1) * cos_theta * t156 * t155 + t82 * t160 * t119 - t86 * t160 * t119 + 0.2e1 * t82 * t165 * t119 - 0.2e1 * t86 * t165 * t119 - t82 * t31 * t119 + t86 * t31 * t119 - t82 * t93 * t128 - 0.2e1 * t82 * t97 * t128 + t86 * t93 * t128 + 0.2e1 * t86 * t97 * t128 - t178 * t176;
t181 = m2 * t17;
t186 = h1 * t90;
t192 = m2 * t5;
t196 = m2 * rH2y * t;
t212 = -h4 * F1_(1) * cos_theta * t186 - m2 * rM3y * t * t17 - cos_slope * F1_(1) * t4 * t90 + t154 * H2y * I2 - t154 * I2 * M3y - t181 * M3y * Tss - h1 * T1_(2) * t90 + rH2y * t * t30 - rM3y * t * t30 - T1_(2) * t192 * t154 + t196 * t17 + t181 * t176 - t196 * t177;
t216 = 0.1e1 / Tss;
t218 = Tss * d;
t220 = pw * cos_slope;
t233 = X3_(2) * cos_slope;
t237 = cos_slope * X_(2);
t278 = -t220 * t60 * t127 * t218 + t220 * t64 * g * t218 + rg * X3_(2) * cos_slope * t7 * t67 - X_(2) * t48 * t7 * t67 + 0.2e1 * t233 * t52 * t67 - 0.2e1 * t237 * t52 * t67 - t233 * t7 * t67 + t237 * t7 * t67 + cos_slope * X2_(2) * t60 * t63 - 0.2e1 * t233 * t60 * t63 + t237 * t60 * t63 + cos_slope * X3_(2) * t10 * t113 - X_(2) * t11 * t113 + t220 * t31 * d * g * t90 + t233 * t93 * t128 - t237 * t93 * t128 + 0.2e1 * t233 * t97 * t128 - 0.2e1 * t237 * t97 * t128 + m2 * F1_(2) * cos_slope * t150 + F1_(2) * cos_theta * t156 * t155;
t293 = H2x * Tss;
t307 = m2 * rH2x * t;
t323 = -t233 * t160 * t119 + t237 * t160 * t119 - 0.2e1 * t233 * t165 * t119 + 0.2e1 * t237 * t165 * t119 + t233 * t31 * t119 - t237 * t31 * t119 - t178 * t293 + t181 * t293 + cos_slope * F1_(2) * t4 * t90 + h4 * F1_(2) * cos_theta * t186 - t181 * M3x * Tss - T1_(1) * t192 * t154 - t307 * t177 + t307 * t17 - m2 * rM3x * t * t17 + t154 * H2x * I2 - t154 * I2 * M3x - h1 * T1_(1) * t90 + rH2x * t * t30 - rM3x * t * t30;
ddX_(1) = -t216 * (t96 + t137 + t180 + t212) * t45;
ddX_(2) = t45 * t216 * (t278 + t323);
ddX_(3) = 0.0e0;

t4 = Tss * g;
t5 = h1 ^ 2;
t6 = t5 * h1;
t8 = h2 * t6 * t4;
t9 = m2 * m1;
t10 = cos_slope ^ 2;
t11 = rg * t10;
t13 = sin_slope * t11 * t9;
t15 = m2 ^ 2;
t16 = rg * t15;
t17 = sin_slope * t10;
t18 = t17 * t16;
t21 = h2 ^ 2;
t22 = t21 * t5;
t23 = t22 * t4;
t29 = t5 * h2;
t30 = t29 * t4;
t31 = m1 * h3;
t34 = sin_theta * t10 * m2 * t31;
t38 = t10 * X3_(1) * rg * t9;
t41 = X_(1) * t11 * t9;
t43 = t10 * X3_(1);
t44 = t43 * t16;
t47 = X_(1) * t10;
t48 = t47 * t16;
t51 = t21 * h1;
t52 = t51 * t4;
t54 = h3 * t51;
t56 = cos_theta * cos_slope;
t57 = sin_slope * t56;
t66 = I2 * Tss;
t67 = t5 * g;
t68 = t67 * t66;
t69 = m1 * rg;
t72 = m2 * rg;
t76 = X2_(1) * t10;
t79 = t57 * t9 * t54 * t4 + t17 * t9 * t23 - t17 * t69 * t68 - 0.2e1 * t17 * t72 * t68 + t76 * t9 * t30 - t13 * t23 + t13 * t8 - 0.2e1 * t18 * t23 + 0.2e1 * t18 * t8 + t34 * t30 + t38 * t30 - t41 * t30 + 0.2e1 * t44 * t30 - 0.2e1 * t48 * t30 - t34 * t52 - t38 * t52 + t41 * t52 - 0.2e1 * t44 * t52 + 0.2e1 * t48 * t52;
t80 = t43 * t9;
t82 = t5 * t4;
t83 = t15 * h2;
t93 = h1 * t4;
t94 = t15 * t21;
t103 = h1 * h2 * h3 * t4;
t110 = t21 * h2;
t111 = t110 * t4;
t112 = t10 * t15;
t118 = g * t66;
t126 = g * h1;
t127 = t126 * t66;
t128 = m2 * h2;
t129 = t17 * t128;
t143 = -t80 * t30 + 0.2e1 * t76 * t83 * t82 - 0.2e1 * t43 * t83 * t82 + t80 * t52 - t47 * t9 * t52 - 0.3e1 * t76 * t94 * t93 + 0.3e1 * t43 * t94 * t93 + X2_(1) * t56 * t9 * t103 - X_(1) * t56 * t9 * t103 + X2_(1) * t112 * t111 - t10 * X3_(1) * t15 * t111 + t17 * m1 * t5 * t118 + 0.2e1 * t17 * m2 * t5 * t118 - t129 * t127 - sin_theta * t10 * t31 * t127 + t57 * t31 * t127 - t43 * t69 * t127 + t47 * t69 * t127 - 0.2e1 * t43 * t72 * t127;
t148 = I3 * Tss;
t152 = h2 * t6 * Tss;
t153 = F1_(1) * m2;
t154 = t10 * t153;
t156 = t5 * Tss;
t157 = t21 * t156;
t160 = h2 * h4 * t156;
t161 = t56 * t153;
t163 = h1 * Tss;
t165 = h4 * t21 * t163;
t167 = m1 * h1;
t172 = m2 * h1;
t181 = t47 * t128;
t183 = g * t148;
t187 = H2y * Tss;
t188 = m1 * t6;
t189 = cos_slope * t188;
t191 = m2 * t6;
t192 = cos_slope * t191;
t195 = t5 * t187;
t196 = cos_slope * t128;
t199 = cos_theta * t31;
t203 = cos_slope * m2 * t21;
t206 = 0.2e1 * t203 * h1 * t187 - t43 * t128 * t118 + t43 * t167 * t118 - t47 * t167 * t118 + 0.2e1 * t43 * t172 * t118 - 0.2e1 * t47 * t172 * t118 + t129 * t126 * t148 + 0.2e1 * t47 * t72 * t127 + t76 * t128 * t183 + t181 * t118 + t154 * t152 - t154 * t157 + t161 * t160 - t161 * t165 - t181 * t183 + t189 * t187 + 0.2e1 * t192 * t187 - 0.4e1 * t196 * t195 + t199 * t195;
t210 = h1 * t66;
t214 = Tss * M3y;
t219 = h2 * t156;
t221 = m2 * T1_(2) * cos_slope;
t223 = t21 * t163;
t225 = t * rH2y;
t226 = cos_slope * t225;
t230 = m2 * t29;
t234 = rM3y * t * cos_slope;
t237 = m1 * h3 * t5;
t240 = m2 * t51;
t245 = cos_slope * t163;
t254 = I2 * h1;
t257 = I3 * h1;
t259 = -t10 * F1_(1) * t5 * t66 - t56 * h4 * F1_(1) * t210 + t196 * t5 * t214 - t203 * h1 * t214 + t221 * t219 - t221 * t223 + t226 * t188 + 0.2e1 * t226 * t191 - 0.4e1 * t226 * t230 + t234 * t230 + cos_theta * t225 * t237 + 0.2e1 * t226 * t240 - t234 * t240 + t245 * H2y * I2 + t245 * H2y * I3 - t245 * I2 * M3y - h1 * T1_(2) * cos_slope * t66 + t226 * t254 - t234 * t254 + t226 * t257;
t262 = 0.1e1 / cos_slope;
t264 = 0.1e1 / Tss;
t267 = cos_slope * t15;
t274 = t21 ^ 2;
t277 = t5 * I2;
t280 = m2 * cos_slope;
t292 = I2 * I3 * cos_slope + t280 * t21 * I2 + t280 * t21 * I3 - 0.2e1 * t267 * t110 * h1 + m1 * cos_slope * t277 + cos_slope * t15 * t274 + cos_slope * t9 * t22 + cos_theta * t9 * t54 - 0.2e1 * t196 * t254 + t199 * t254 + t267 * t22 + 0.2e1 * t280 * t277;
t293 = 0.1e1 / t292;
t296 = Tss * d;
t297 = t67 * t296;
t303 = t10 * pw;
t325 = t10 * X3_(2) * rg * t9;
t328 = X_(2) * t11 * t9;
t330 = t10 * X3_(2);
t331 = t330 * t16;
t334 = X_(2) * t10;
t335 = t334 * t16;
t344 = X2_(2) * t10;
t347 = t330 * t9;
t355 = pw * cos_slope * cos_theta * m2 * t31 * h2 * t126 * t296 + t10 * pw * m2 * h2 * m1 * t297 + 0.2e1 * t303 * t15 * t110 * g * t296 - 0.4e1 * t303 * t94 * t126 * t296 + 0.2e1 * t303 * t83 * t297 - t344 * t9 * t30 + 0.2e1 * t330 * t83 * t82 - 0.2e1 * t344 * t83 * t82 - t325 * t30 + t328 * t30 - 0.2e1 * t331 * t30 + 0.2e1 * t335 * t30 + t347 * t30 + t325 * t52 - t328 * t52 + 0.2e1 * t331 * t52 - 0.2e1 * t335 * t52;
t376 = d * g;
t378 = t303 * t128;
t392 = F1_(2) * m2;
t393 = t10 * t392;
t396 = t56 * t392;
t398 = t10 * X3_(2) * t15 * t111 - X2_(2) * t56 * t9 * t103 + X_(2) * t56 * t9 * t103 - X2_(2) * t112 * t111 + t330 * t69 * t127 + 0.2e1 * t330 * t72 * t127 - t334 * t69 * t127 - 0.2e1 * t334 * t72 * t127 + t378 * t376 * t148 - 0.3e1 * t330 * t94 * t93 + t334 * t9 * t52 + 0.3e1 * t344 * t94 * t93 + t378 * t376 * t66 - t393 * t152 + t393 * t157 - t396 * t160 - t347 * t52;
t413 = t334 * t128;
t418 = H2x * Tss;
t422 = t5 * t418;
t435 = Tss * M3x;
t438 = t56 * h4 * F1_(2) * t210 + t10 * F1_(2) * t5 * t66 + 0.2e1 * t203 * h1 * t418 + t330 * t128 * t118 - t330 * t167 * t118 + t334 * t167 * t118 - 0.2e1 * t330 * t172 * t118 + 0.2e1 * t334 * t172 * t118 - t344 * t128 * t183 + t196 * t5 * t435 - t413 * t118 + t396 * t165 + t413 * t183 + t189 * t418 + 0.2e1 * t192 * t418 - 0.4e1 * t196 * t422 + t199 * t422;
t442 = m2 * T1_(1) * cos_slope;
t445 = t * rH2x;
t446 = cos_slope * t445;
t453 = rM3x * t * cos_slope;
t472 = -h1 * T1_(1) * cos_slope * t66 + t245 * H2x * I2 + t245 * H2x * I3 - t245 * I2 * M3x - t203 * h1 * t435 + cos_theta * t445 * t237 + t446 * t188 + 0.2e1 * t446 * t191 + t442 * t219 - t442 * t223 - 0.4e1 * t446 * t230 + t453 * t230 + 0.2e1 * t446 * t240 - t453 * t240 + t446 * t254 - t453 * t254 + t446 * t257;
ddX2_(1) = -t293 * t264 * t262 * (t79 + t143 + t206 + t259);
ddX2_(2) = t262 * t264 * (t355 + t398 + t438 + t472) * t293;
ddX2_(3) = 0.0e0;

t4 = Tss * g;
t5 = h2 ^ 2;
t6 = t5 ^ 2;
t9 = m2 ^ 2;
t10 = rg * t9;
t11 = cos_slope * sin_slope;
t12 = t11 * t10;
t14 = I2 * Tss;
t15 = h1 ^ 2;
t17 = t15 * g * t14;
t20 = t5 * g;
t21 = t20 * t14;
t24 = I3 * Tss;
t25 = t20 * t24;
t28 = t5 * h1;
t29 = t28 * t4;
t30 = m1 ^ 2;
t31 = m2 * t30;
t32 = X3_(1) * cos_slope;
t36 = g * h1;
t38 = m1 * t5;
t39 = cos_slope * t9;
t40 = t39 * t38;
t42 = t9 * m1;
t43 = t32 * t42;
t46 = t36 * t14;
t47 = t30 * h3;
t51 = rg * t30;
t54 = m2 * m1;
t55 = t11 * t54;
t58 = h1 * Tss;
t60 = h3 * t5 * t58;
t61 = F1_(1) * cos_theta;
t62 = t61 * t54;
t65 = h4 * t5 * t58;
t67 = I2 * I3;
t68 = t4 * t67;
t72 = m2 * rg;
t76 = t32 * t54;
t80 = g * h2 * t14;
t82 = I2 * X_(1);
t83 = t4 * t82;
t84 = h2 * m1;
t85 = m2 * cos_slope;
t86 = t85 * t84;
t88 = t12 * m1 * t6 * t4 + 0.4e1 * t12 * t17 + 0.2e1 * t12 * t21 + 0.2e1 * t12 * t25 + t32 * t31 * t29 - t40 * t36 * X2_(1) * Tss + 0.2e1 * t43 * t29 - cos_slope * sin_theta * t47 * t46 - t32 * t51 * t46 - t55 * t21 - t55 * t25 + t62 * t60 - t62 * t65 + t11 * m1 * rg * t68 + 0.2e1 * t11 * t72 * t68 + 0.2e1 * t76 * t46 - t76 * t80 + t86 * t83;
t89 = X_(1) * Tss;
t90 = t36 * t89;
t91 = t30 * t5;
t92 = t85 * t91;
t95 = t30 * h1;
t96 = cos_slope * rg;
t97 = t96 * t95;
t100 = g * m1;
t103 = h1 * t14;
t104 = h4 * m1;
t107 = g * t14;
t110 = m2 * h2;
t115 = t5 * h2;
t116 = t115 * t4;
t118 = t6 * t4;
t121 = t11 * rg * t9 * m2;
t124 = t11 * t42;
t126 = m1 * h3;
t131 = cos_slope * t30 * t36;
t135 = t39 * m1 * t115;
t138 = m1 * t58;
t142 = I2 * h1;
t149 = m1 * h1;
t152 = -t92 * t90 - t40 * t90 + t97 * t83 - t11 * t100 * Tss * t67 - t61 * t104 * t103 + t32 * t95 * t107 - 0.2e1 * F1_(1) * cos_slope * t110 * t103 - t43 * t116 + 0.2e1 * t121 * t118 - t124 * t118 + t61 * t126 * t103 - t131 * Tss * t82 + t135 * g * t89 + t138 * H2y * I2 - t138 * I2 * M3y + m1 * rH2y * t * t142 - m1 * rM3y * t * t142 - T1_(2) * t149 * t14;
t154 = t5 * t15;
t155 = t154 * t4;
t156 = sin_slope * t96;
t157 = t156 * t42;
t159 = t115 * h1;
t160 = t159 * t4;
t163 = h3 * t28;
t164 = t163 * t4;
t166 = rg * cos_theta * sin_slope;
t172 = cos_slope * t72;
t173 = t172 * t91;
t176 = cos_slope * t10 * t38;
t179 = t156 * t54;
t199 = t172 * t149;
t202 = t6 * Tss;
t204 = cos_slope * F1_(1) * t9;
t206 = H2y * Tss;
t208 = m2 * t84;
t211 = m1 * h2 * t15;
t213 = m2 * rH2y * t;
t218 = t157 * t155 - 0.2e1 * t157 * t160 + t166 * t31 * t164 + 0.2e1 * t166 * t42 * t164 + t173 * t90 + 0.2e1 * t176 * t90 + 0.2e1 * t179 * t17 - 0.2e1 * t179 * h2 * t36 * t14 - 0.4e1 * t156 * t9 * h2 * t46 + t166 * t47 * t46 + 0.2e1 * t166 * t54 * h3 * t36 * t14 + t179 * t21 + t179 * t25 + 0.2e1 * t199 * t83 + t204 * t202 - t208 * t15 * t206 - t213 * t211 + Tss * F1_(1) * cos_slope * t67;
t228 = rg * X3_(1) * cos_slope;
t241 = t5 * t15 * Tss;
t243 = t115 * t58;
t246 = t85 * t149;
t250 = m2 * t38;
t252 = t15 * t14;
t254 = m2 * F1_(1) * cos_slope;
t257 = t5 * t14;
t259 = t5 * t24;
t264 = t5 * t58;
t267 = m1 * t28;
t272 = 0.2e1 * t121 * t155 - 0.4e1 * t121 * t160 + t124 * t160 - sin_theta * t85 * t47 * t29 - t228 * t31 * t29 - 0.2e1 * t228 * t42 * t29 + sin_slope * t85 * t84 * t46 - 0.2e1 * t228 * t54 * t46 + t204 * t241 - 0.2e1 * t204 * t243 - 0.2e1 * t246 * t83 + t250 * h1 * t206 + 0.2e1 * t254 * t252 + t254 * t257 + t254 * t259 - t250 * M3y * Tss * h1 - T1_(2) * t54 * t264 + t213 * t267 - m2 * rM3y * t * t267;
t275 = 0.1e1 / Tss;
t286 = t15 * I2;
t301 = t85 * t5 * I2 + t85 * t5 * I3 + m1 * cos_slope * t286 - 0.2e1 * cos_slope * t110 * t142 + cos_theta * t126 * t142 + cos_slope * t54 * t154 + cos_theta * t54 * t163 + cos_slope * t9 * t6 + t39 * t154 - 0.2e1 * t39 * t159 + 0.2e1 * t85 * t286 + cos_slope * t67;
t302 = 0.1e1 / t301;
t304 = X3_(2) * cos_slope;
t305 = t304 * t42;
t307 = Tss * X_(2);
t311 = cos_slope * F1_(2) * t9;
t315 = X_(2) * I2;
t322 = F1_(2) * cos_theta;
t336 = -Tss * F1_(2) * cos_slope * t67 + 0.2e1 * F1_(2) * cos_slope * t110 * t103 + t138 * H2x * I2 - t138 * I2 * M3x + t131 * Tss * t315 - t135 * g * t307 + t322 * t104 * t103 - t322 * t126 * t103 - t304 * t95 * t107 - T1_(1) * t149 * t14 + t305 * t116 - t311 * t202;
t337 = t36 * t307;
t343 = t4 * t315;
t349 = m2 * F1_(2) * cos_slope;
t355 = m2 * rH2x * t;
t366 = -t250 * M3x * Tss * h1 + t40 * t36 * X2_(2) * Tss + m1 * rH2x * t * t142 - m1 * rM3x * t * t142 - m2 * rM3x * t * t267 + 0.2e1 * t246 * t343 - t349 * t257 + t355 * t267 + t40 * t337 + t92 * t337 - t86 * t343 - t97 * t343;
t368 = Tss * d;
t380 = rg * X3_(2) * cos_slope;
t406 = m2 * pw * cos_slope * t84 * d * g * t14 + pw * cos_slope * t42 * t115 * g * t368 - cos_slope * pw * t9 * t38 * t36 * t368 - t304 * t31 * t29 + t380 * t31 * t29 + 0.2e1 * t380 * t42 * t29 + t304 * t51 * t46 + 0.2e1 * t380 * t54 * t46 - t173 * t337 - 0.2e1 * t176 * t337 - 0.2e1 * t199 * t343 - 0.2e1 * t305 * t29;
t410 = t322 * t54;
t413 = t304 * t54;
t417 = H2x * Tss;
t428 = t250 * h1 * t417 - t208 * t15 * t417 - T1_(1) * t54 * t264 - t355 * t211 - t311 * t241 + 0.2e1 * t311 * t243 - 0.2e1 * t349 * t252 - t349 * t259 - t410 * t60 + t410 * t65 - 0.2e1 * t413 * t46 + t413 * t80;
f1_(1) = -t302 * t275 * (t88 + t152 + t218 + t272);
f1_(2) = t302 * t275 * (t336 + t366 + t406 + t428);
f1_(3) = -0.2e1 * t96 * g * m2 - t96 * t100 + cos_slope * t100;

t4 = Tss * X2_(1);
t5 = g * t4;
t6 = h1 ^ 2;
t7 = h2 ^ 2;
t8 = t7 * t6;
t9 = m2 ^ 2;
t10 = cos_slope ^ 2;
t11 = t10 * t9;
t12 = t11 * t8;
t14 = X_(1) * Tss;
t15 = g * t14;
t17 = t7 * h2;
t18 = t17 * h1;
t19 = t11 * t18;
t28 = t7 ^ 2;
t29 = t9 * t28;
t30 = t10 * t29;
t32 = I2 * Tss;
t33 = g * t32;
t34 = m1 * t6;
t35 = t10 * X3_(1);
t38 = I2 * X_(1);
t39 = Tss * t38;
t40 = t6 * g;
t42 = t10 * m1 * t40;
t44 = t10 * m2;
t45 = t44 * t40;
t51 = t44 * t7 * g;
t56 = H2y * h2;
t57 = Tss * t56;
t58 = t6 * h1;
t62 = 0.2e1 * t11 * t17 * g * h1 * X_(1) * Tss + t51 * I3 * X2_(1) * Tss - t51 * I3 * X_(1) * Tss + cos_slope * m1 * t58 * t57 + t35 * t34 * t33 - t12 * t15 + t12 * t5 - 0.2e1 * t19 * t5 + t30 * t5 - t42 * t39 - 0.2e1 * t45 * t39;
t63 = H2y * cos_slope;
t64 = Tss * t63;
t65 = h2 * t58;
t66 = m2 * t65;
t68 = m2 * t8;
t72 = m1 * cos_theta;
t75 = m2 * t18;
t77 = I2 * I3;
t79 = g * h1;
t80 = sin_slope * t10;
t83 = m1 * t65;
t85 = rH2y * t * cos_slope;
t88 = h2 * t58 * cos_slope;
t90 = m2 * rH2y * t;
t97 = h3 * t6 * h2;
t99 = t * cos_theta;
t107 = Tss * h1 * cos_slope;
t110 = h2 * I3 * h1;
t112 = -t80 * t79 * Tss * t77 + t90 * t17 * h1 * cos_slope + t72 * h3 * t6 * t57 + t99 * m1 * rH2y * t97 - 0.2e1 * t90 * t7 * t6 * cos_slope + t107 * I3 * t56 + t85 * t110 + t66 * t64 - 0.2e1 * t68 * t64 + t75 * t64 + t85 * t83 + t90 * t88;
t115 = t40 * t32;
t116 = m1 * rg;
t119 = m2 * rg;
t123 = Tss * g;
t124 = t123 * t38;
t125 = m2 * t6;
t126 = rg * t10;
t127 = t126 * t125;
t130 = I2 * h1;
t131 = t123 * t130;
t132 = m2 * h2;
t142 = t6 * t32;
t144 = cos_slope * I2;
t148 = t6 * Tss;
t157 = t44 * g * h2 * t14 * t130 - t6 * Tss * M3y * t144 + t * rH2y * t6 * t144 - t * rM3y * t6 * t144 - t10 * F1_(1) * t58 * t32 - t35 * t116 * t115 - 0.2e1 * t35 * t119 * t115 - t35 * t132 * t131 - T1_(2) * t148 * t144 + 0.2e1 * t127 * t124 + t142 * t63 - t30 * t15;
t159 = t58 * g * t32;
t166 = m1 * t7;
t167 = t44 * t166;
t171 = t79 * t7;
t173 = m1 * h3;
t174 = m2 * cos_slope;
t176 = cos_theta * t174 * t173;
t185 = t126 * t34;
t187 = m2 * t7;
t198 = -F1_(1) * cos_theta * h4 * t6 * Tss * t144 - sin_theta * t10 * t173 * t115 + t80 * t132 * t115 - t80 * t116 * t159 - 0.2e1 * t80 * t119 * t159 + 0.2e1 * t35 * t125 * t33 - t80 * t187 * t131 - t167 * t40 * t14 - t171 * t14 * t176 + t167 * t40 * t4 + t176 * t171 * t4 + t185 * t124;
t202 = 0.1e1 / Tss;
t207 = m2 * m1;
t210 = cos_slope * t9;
t219 = t6 * I2;
t234 = cos_theta * t207 * h3 * t7 * h1 + t174 * t7 * I2 + t174 * t7 * I3 + m1 * cos_slope * t219 - 0.2e1 * cos_slope * t132 * t130 + cos_theta * t173 * t130 + cos_slope * t207 * t8 + 0.2e1 * t174 * t219 - 0.2e1 * t210 * t18 + t210 * t8 + cos_slope * t29 + cos_slope * t77;
t236 = 0.1e1 / t234 / cos_slope / h1;
t238 = Tss * d;
t239 = t40 * t238;
t241 = t10 * pw;
t249 = t10 * X3_(2);
t256 = d * g;
t260 = X_(2) * I2;
t261 = t123 * t260;
t262 = h1 * h2;
t269 = cos_slope * t148;
t277 = rH2x * t * cos_slope;
t282 = t241 * t9 * t7 * t239 - 0.2e1 * t241 * t17 * t9 * t79 * t238 + t249 * t116 * t115 + 0.2e1 * t249 * t119 * t115 + t241 * t187 * t256 * I3 * Tss - t44 * t262 * t261 + t10 * F1_(2) * t58 * t32 + t269 * H2x * I2 - t269 * I2 * M3x - cos_slope * T1_(1) * t6 * t32 + t277 * t219 - rM3x * t * cos_slope * t219;
t289 = X2_(2) * Tss;
t292 = Tss * X_(2);
t302 = g * t292;
t310 = cos_slope * H2x * Tss;
t315 = pw * cos_slope * cos_theta * m2 * t173 * t171 * t238 + m2 * rH2x * t * t88 - t10 * t123 * X2_(2) * t29 + t249 * t132 * t131 - t167 * t40 * t289 + t167 * t40 * t292 - t176 * t171 * t289 + t176 * t171 * t292 - 0.2e1 * t127 * t261 - t185 * t261 + t30 * t302 + t66 * t310;
t318 = t10 * pw * m2;
t324 = Tss * t260;
t326 = I3 * t187;
t327 = t10 * g;
t331 = H2x * Tss;
t332 = t6 * t331;
t340 = rH2x * m1;
t350 = t318 * t166 * t239 + t318 * t262 * t256 * t32 + t42 * t324 - t327 * t289 * t326 + t83 * t310 - 0.2e1 * cos_slope * t187 * t332 + cos_slope * m2 * t17 * h1 * t331 + t * t340 * t88 - 0.2e1 * t277 * t68 + t277 * t75 + t107 * h2 * H2x * I3 + t277 * t110;
t353 = g * t289;
t379 = h4 * F1_(2) * cos_slope * cos_theta * t142 + t241 * t29 * g * t238 + t72 * h2 * h3 * t332 - 0.2e1 * t249 * t125 * t33 - t249 * t34 * t33 + t327 * t292 * t326 + t99 * t340 * t97 + t12 * t302 - t12 * t353 - 0.2e1 * t19 * t302 + 0.2e1 * t19 * t353 + 0.2e1 * t45 * t324;
f2_(1) = -t236 * t202 * (t62 + t112 + t157 + t198) * m2;
f2_(2) = t236 * t202 * (t282 + t315 + t350 + t379) * m2;
f2_(3) = m2 * g * cos_slope;

t4 = I2 * Tss;
t5 = h1 ^ 2;
t6 = t5 * g;
t8 = h3 * t6 * t4;
t9 = m1 ^ 2;
t10 = rg * t9;
t11 = cos_theta * cos_slope;
t12 = sin_slope * t11;
t15 = X_(1) * Tss;
t16 = t6 * t15;
t17 = h2 ^ 2;
t18 = t17 * t9;
t19 = cos_slope ^ 2;
t20 = t19 * m2;
t21 = t20 * t18;
t23 = m1 * t17;
t24 = m2 ^ 2;
t25 = t19 * t24;
t26 = t25 * t23;
t29 = Tss * X2_(1);
t30 = g * t29;
t31 = t17 * t5;
t32 = t24 * m2;
t33 = t19 * t32;
t34 = t33 * t31;
t36 = g * t15;
t38 = g * h1;
t40 = t17 * h2;
t41 = m1 * t40;
t42 = t25 * t41;
t44 = t40 * h1;
t45 = t33 * t44;
t50 = t6 * t4;
t51 = t9 * h3;
t55 = I2 * X_(1);
t56 = Tss * g;
t57 = t56 * t55;
t58 = t9 * t5;
t59 = t19 * rg;
t60 = t59 * t58;
t62 = t5 * t24;
t63 = t59 * t62;
t66 = g * t4;
t67 = t19 * X3_(1);
t70 = Tss * t55;
t72 = t19 * t9 * t6;
t74 = -sin_theta * t19 * t51 * t50 + t12 * t10 * t8 + t42 * t38 * t15 + t67 * t58 * t66 - t21 * t16 - 0.2e1 * t16 * t26 + t34 * t30 - 0.2e1 * t45 * t30 - t34 * t36 + 0.2e1 * t45 * t36 + t60 * t57 + 0.2e1 * t63 * t57 - t72 * t70;
t78 = t25 * t6;
t81 = t24 * t17;
t82 = I3 * t81;
t83 = t19 * g;
t88 = H2y * Tss;
t89 = t5 * t88;
t90 = m2 * cos_slope;
t91 = t90 * t23;
t93 = t5 * h2;
t95 = m1 * h3;
t97 = m2 * cos_theta * t95;
t99 = t5 * t4;
t100 = m2 * h2;
t101 = t19 * F1_(1);
t105 = h1 * t4;
t106 = m2 * t17;
t107 = t101 * t106;
t109 = I3 * Tss;
t110 = h1 * t109;
t112 = t5 * Tss;
t113 = t17 * t112;
t114 = m2 * m1;
t118 = t95 * t93;
t119 = m2 * rH2y;
t120 = t * cos_theta;
t125 = h1 * cos_slope * t109;
t127 = I3 * t100;
t129 = t * cos_slope;
t132 = 0.2e1 * t67 * t62 * t66 - 0.2e1 * t78 * t70 + t83 * t29 * t82 - t83 * t15 * t82 + t91 * t89 + t97 * t93 * t88 - 0.2e1 * t101 * t100 * t99 + t107 * t105 + t107 * t110 - T1_(2) * cos_slope * t114 * t113 + t120 * t119 * t118 + t125 * H2y * t100 + t129 * h1 * rH2y * t127;
t135 = h3 * t31 * t56;
t136 = m2 * t9;
t140 = t24 * m1;
t149 = t5 * h1;
t151 = t17 * t149 * Tss;
t153 = t19 * F1_(1) * t24;
t155 = t40 * t112;
t159 = t17 ^ 2;
t160 = t159 * h1 * Tss;
t162 = m1 * t5;
t163 = t20 * t162;
t166 = h1 * h2;
t167 = t25 * t166;
t172 = t24 * h2 * t149;
t174 = cos_slope * t81;
t179 = cos_slope * t24 * t40;
t181 = t149 * t4;
t182 = F1_(1) * m2;
t188 = t172 * cos_slope * H2y * Tss - t91 * t5 * Tss * M3y + 0.2e1 * t12 * rg * t114 * t8 + t12 * rg * t136 * t135 + 0.2e1 * t12 * rg * t140 * t135 + t179 * h1 * t88 + t181 * t19 * t182 + t153 * t151 - 0.2e1 * t153 * t155 + t153 * t160 - 0.3e1 * t163 * t57 + t167 * t57 - 0.2e1 * t174 * t89;
t190 = h2 * t149 * cos_slope;
t194 = m1 * t31;
t200 = t24 * t31;
t202 = rH2y * t * cos_slope;
t205 = t24 * t44;
t208 = H2y * I2 * Tss;
t209 = cos_slope * t162;
t212 = cos_slope * m2 * t5;
t214 = I2 * I3;
t215 = Tss * t214;
t220 = I2 * M3y * Tss;
t223 = t5 * I2;
t224 = m1 * t223;
t227 = rM3y * t * cos_slope;
t229 = m2 * t223;
t232 = t19 * F1_(1) * h1 * t215 - t129 * m2 * rM3y * t194 + t * rH2y * t24 * t190 + t129 * t119 * t194 - 0.2e1 * t202 * t200 + t202 * t205 + t202 * t224 + t202 * t229 + t209 * t208 + t212 * t208 - t209 * t220 - t212 * t220 - t227 * t224 - t227 * t229;
t236 = t17 * t149 * t56;
t237 = sin_slope * t59;
t238 = t237 * t140;
t241 = sin_slope * t19;
t242 = t241 * rg * t32;
t246 = t40 * t5 * t56;
t252 = t159 * h1 * t56;
t256 = t241 * t140;
t258 = t31 * t56;
t259 = sin_theta * t20;
t263 = t19 * X3_(1) * rg;
t267 = t19 * rg * m2;
t268 = t267 * t18;
t273 = rg * t24;
t275 = t19 * t273 * t23;
t279 = -t263 * t136 * t258 - 0.2e1 * t263 * t140 * t258 - t259 * t51 * t258 + t268 * t16 + 0.2e1 * t275 * t16 + t238 * t236 + 0.2e1 * t242 * t236 - 0.2e1 * t238 * t246 + t238 * t252 - 0.4e1 * t242 * t246 + 0.2e1 * t242 * t252 + t256 * t246 - t256 * t252;
t281 = t149 * g * t4;
t282 = t237 * t114;
t291 = t24 * h2;
t295 = t17 * t38;
t298 = t38 * t4;
t299 = t237 * t81;
t304 = t38 * t109;
t309 = t67 * t140;
t312 = t44 * t56;
t315 = cos_slope * t24;
t317 = cos_theta * t315 * t95;
t321 = -0.2e1 * t282 * h2 * t6 * t4 + t282 * t295 * t109 + t67 * t136 * t258 - t317 * t295 * t15 - 0.4e1 * t237 * t291 * t50 + 0.2e1 * t241 * t273 * t281 + t282 * t295 * t4 + t317 * t295 * t29 + 0.2e1 * t309 * t258 + t282 * t281 + 0.2e1 * t299 * t298 + 0.2e1 * t299 * t304 - t309 * t312;
t323 = t32 * t159;
t325 = t19 * t56;
t327 = t19 * t323;
t329 = h2 * m1;
t330 = sin_slope * t20;
t342 = t267 * t162;
t348 = t330 * t23;
t354 = h3 * t17 * t112;
t357 = F1_(1) * cos_slope * cos_theta * t114;
t359 = -t67 * t10 * t50 - 0.3e1 * t263 * t114 * t50 + t241 * t291 * t50 - t241 * t81 * t298 - t259 * t95 * t50 - 0.2e1 * t67 * t273 * t50 + t325 * X2_(1) * t323 + t330 * t329 * t50 - t348 * t298 - t348 * t304 - t327 * t36 + 0.3e1 * t342 * t57 + t357 * t354;
t361 = h4 * t17 * t112;
t363 = t56 * t214;
t364 = m1 * h1;
t367 = m2 * h1;
t379 = t19 * t114 * t166;
t388 = h3 * t5 * t4;
t390 = t11 * m1 * F1_(1);
t393 = h4 * t5 * t4;
t403 = -t19 * X3_(1) * m2 * t329 * t298 - m1 * T1_(2) * cos_slope * t99 - m2 * T1_(2) * cos_slope * t99 - t11 * t182 * t393 + 0.3e1 * t67 * t114 * t50 + t237 * t364 * t363 + 0.2e1 * t237 * t367 * t363 - t241 * t364 * t363 - t241 * t367 * t363 - t67 * t291 * t298 - t357 * t361 + t379 * t57 + t390 * t388 - t390 * t393;
t407 = 0.1e1 / Tss;
t427 = I2 * h1;
t438 = cos_theta * t114 * h3 * t17 * h1 + t90 * t17 * I2 + t90 * t17 * I3 + m1 * cos_slope * t223 - 0.2e1 * cos_slope * t100 * t427 + cos_slope * t114 * t31 + cos_slope * t24 * t159 + cos_theta * t95 * t427 + cos_slope * t214 + 0.2e1 * t90 * t223 + t315 * t31 - 0.2e1 * t315 * t44;
t440 = 0.1e1 / t438 / cos_slope / h1;
t442 = t19 * F1_(2);
t443 = t442 * t106;
t446 = t19 * X3_(2);
t452 = X2_(2) * Tss;
t455 = Tss * X_(2);
t458 = d * g;
t465 = X_(2) * I2;
t466 = t56 * t465;
t473 = Tss * d;
t475 = t19 * pw;
t478 = H2x * Tss;
t479 = t5 * t478;
t484 = m2 * rH2x;
t497 = g * t452;
t499 = -t443 * t105 - t443 * t110 - t446 * t58 * t66 - 0.2e1 * t446 * t62 * t66 - t317 * t295 * t452 + t317 * t295 * t455 + t19 * pw * m2 * t329 * h1 * t458 * t4 - t60 * t466 - 0.2e1 * t63 * t466 + 0.3e1 * t163 * t466 - t167 * t466 + t475 * t323 * g * t473 + t91 * t479 - t91 * t5 * Tss * M3x + t129 * t484 * t194 - t129 * m2 * rM3x * t194 + t125 * H2x * t100 + t129 * h1 * rH2x * t127 + t83 * t455 * t82 - t34 * t497;
t500 = t38 * t473;
t502 = t19 * pw * t24;
t512 = t19 * X3_(2) * rg;
t518 = t6 * t455;
t522 = g * t455;
t539 = F1_(2) * cos_slope * cos_theta * t114;
t541 = Tss * t465;
t562 = t19 * X3_(2) * m2 * t329 * t298 - T1_(1) * cos_slope * t114 * t113 + t502 * t166 * t458 * t4 + 0.2e1 * t442 * t100 * t99 - 0.3e1 * t446 * t114 * t50 + 0.3e1 * t512 * t114 * t50 + t446 * t291 * t298 - t83 * t452 * t82 - t539 * t354 + t72 * t541 + 0.2e1 * t78 * t541;
t586 = rH2x * t * cos_slope;
t591 = H2x * I2 * Tss;
t595 = I2 * M3x * Tss;
t600 = rM3x * t * cos_slope;
t603 = -t268 * t518 - 0.2e1 * t275 * t518 - t325 * X2_(2) * t323 + t327 * t522 - 0.3e1 * t342 * t466 + t539 * t361 - t379 * t466 + t172 * cos_slope * H2x * Tss - 0.2e1 * t174 * t479 + t179 * h1 * t478 + t * rH2x * t24 * t190 - 0.2e1 * t586 * t200 + t586 * t205 + t209 * t591 + t212 * t591 - t209 * t595 - t212 * t595 + t586 * t224 - t600 * t224 + t586 * t229;
t608 = t19 * F1_(2) * t24;
t615 = F1_(2) * m2;
t639 = t446 * t140;
t649 = t11 * m1 * F1_(2);
t656 = t475 * t32 * t17 * t6 * t473 - 0.2e1 * t475 * t40 * t32 * t500 + t446 * t10 * t50 + t11 * t615 * t393 + t120 * t484 * t118 - t446 * t136 * t258 + 0.2e1 * t446 * t273 * t50 - 0.2e1 * t639 * t258 + t639 * t312 - t649 * t388 + t649 * t393;
t662 = g * m1;
t663 = cos_slope * rg;
t665 = g * m2;
f3_(1) = t440 * t407 * (t74 + t132 + t188 + t232 + t279 + t321 + t359 + t403);
f3_(2) = -t440 * t407 * (pw * cos_slope * cos_theta * t24 * t95 * t295 * t473 + t512 * t136 * t258 + 0.2e1 * t512 * t140 * t258 - t42 * t38 * t455 + t502 * t41 * t500 + t21 * t518 + 0.2e1 * t26 * t518 + t34 * t522 + 0.2e1 * t45 * t497 - 0.2e1 * t45 * t522 + t499 + t562 - t19 * F1_(2) * h1 * t215 - m1 * T1_(1) * cos_slope * t99 - m2 * T1_(1) * cos_slope * t99 + t475 * t81 * t458 * t109 - t19 * t615 * t181 + t97 * t93 * t478 - t608 * t151 + 0.2e1 * t608 * t155 - t608 * t160 - t600 * t229 + t603 + t656);
f3_(3) = t663 * t662 - cos_slope * t662 + 0.2e1 * t663 * t665 - cos_slope * t665;

F1_(1) = F1_(1);
F1_(2) = F1_(2);
F1_(3) = 0.0e0;

F2_(1) = 0.0e0;
F2_(2) = 0.0e0;
F2_(3) = 0.0e0;

t4 = Tss * g;
t5 = h1 ^ 2;
t6 = h2 ^ 2;
t7 = t6 * h2;
t9 = t7 * t5 * t4;
t10 = m2 ^ 2;
t11 = t10 * m2;
t12 = rg * t11;
t13 = cos_slope ^ 2;
t14 = sin_slope * t13;
t15 = t14 * t12;
t18 = t6 ^ 2;
t20 = t18 * h1 * t4;
t23 = t10 * m1;
t26 = t6 * t5;
t27 = t26 * t4;
t28 = m1 ^ 2;
t29 = m2 * t28;
t30 = t13 * X3_(1);
t33 = t30 * t23;
t36 = t7 * h1;
t37 = t36 * t4;
t40 = I2 * Tss;
t41 = t5 * g;
t42 = t41 * t40;
t43 = rg * t28;
t46 = rg * t10;
t50 = g * h1;
t51 = t50 * t40;
t52 = t10 * t6;
t55 = I3 * Tss;
t59 = I2 * I3;
t60 = t4 * t59;
t61 = m1 * h1;
t64 = m2 * h1;
t69 = h3 * t5 * t40;
t71 = cos_theta * cos_slope;
t72 = t71 * m1 * F1_(1);
t75 = h4 * t5 * t40;
t81 = -0.2e1 * t71 * m2 * F1_(1) * t75 - t14 * t50 * t55 * t52 - t14 * t23 * t20 - t14 * t52 * t51 - t14 * t61 * t60 - 0.2e1 * t14 * t64 * t60 + t30 * t29 * t27 - t30 * t43 * t42 - 0.4e1 * t30 * t46 * t42 + 0.2e1 * t15 * t20 - 0.2e1 * t15 * t9 + 0.3e1 * t33 * t27 - 0.2e1 * t33 * t37 + t72 * t69 - t72 * t75;
t82 = t30 * t12;
t87 = X_(1) * Tss;
t88 = g * t87;
t89 = t13 * t11;
t90 = t89 * t26;
t93 = Tss * X2_(1);
t95 = t89 * t36;
t99 = t5 * Tss;
t101 = h4 * t6 * t99;
t102 = F1_(1) * t10;
t103 = t71 * t102;
t105 = Tss * h1;
t107 = h4 * t7 * t105;
t109 = I2 * X_(1);
t110 = Tss * t109;
t112 = t13 * t28 * t41;
t114 = m2 * m1;
t118 = t13 * t10;
t119 = t118 * t41;
t122 = t10 * h2;
t127 = t118 * t6 * g;
t129 = I3 * t52;
t130 = t13 * g;
t135 = m2 * h2;
t138 = h1 * cos_slope * t55;
t140 = I3 * t135;
t142 = t * cos_slope;
t145 = t142 * h1 * rH2y * t140 + t138 * H2y * t135 - t95 * g * t93 + 0.4e1 * t30 * t114 * t42 - 0.4e1 * t30 * t122 * t51 - t130 * t87 * t129 + t130 * t93 * t129 - t103 * t101 + t103 * t107 - t112 * t110 - 0.4e1 * t119 * t110 - t127 * t110 - 0.2e1 * t82 * t27 + 0.2e1 * t82 * t37 - 0.2e1 * t90 * t88 + 0.4e1 * t95 * t88;
t147 = t5 * t4;
t148 = t11 * t6;
t152 = h1 * t4;
t153 = t11 * t7;
t157 = t11 * t18;
t159 = t13 * t4;
t161 = t13 * t157;
t164 = g * t40;
t165 = t28 * t5;
t168 = t10 * t5;
t174 = t5 * t40;
t175 = t13 * F1_(1);
t178 = t40 * h1;
t179 = m2 * t6;
t180 = t175 * t179;
t182 = h1 * t55;
t184 = Tss * M3y;
t187 = cos_slope * t10 * t7;
t189 = t6 * t99;
t190 = T1_(2) * cos_slope;
t193 = t10 * t36;
t195 = rM3y * t * cos_slope;
t198 = H2y * I2 * Tss;
t199 = h1 * h2;
t200 = m2 * cos_slope;
t201 = t200 * t199;
t205 = t187 * h1 * t184 - t190 * t114 * t189 - t175 * t135 * t174 + t190 * t135 * t178 + 0.2e1 * t30 * t148 * t147 - 0.3e1 * t30 * t153 * t152 + t159 * X2_(1) * t157 + t30 * t165 * t164 + 0.4e1 * t30 * t168 * t164 + t30 * t52 * t164 - 0.2e1 * t161 * t88 + t180 * t178 + t180 * t182 + t195 * t193 - t201 * t198;
t206 = t41 * t87;
t207 = t13 * rg;
t208 = t207 * t148;
t211 = t50 * t87;
t212 = t207 * t153;
t217 = sin_slope * t207;
t218 = t217 * t114;
t220 = t6 * t50;
t223 = t28 * t6;
t224 = t13 * m2;
t225 = t224 * t223;
t227 = m1 * t6;
t228 = t118 * t227;
t231 = m1 * t7;
t232 = t118 * t231;
t235 = t28 * h3;
t239 = t4 * t109;
t240 = t207 * t165;
t242 = t207 * t168;
t246 = h2 * t50 * t40;
t248 = t13 * X3_(1) * rg;
t249 = t248 * t114;
t251 = m1 * t5;
t252 = t224 * t251;
t255 = t118 * t199;
t258 = H2y * Tss;
t259 = t5 * h2;
t261 = m1 * h3;
t263 = m2 * cos_theta * t261;
t265 = t261 * t259;
t266 = m2 * rH2y;
t267 = t * cos_theta;
t273 = 0.2e1 * t208 * t206 - 0.2e1 * t212 * t211 - t218 * h2 * t41 * t40 + t218 * t220 * t40 - t225 * t206 - 0.3e1 * t228 * t206 + 0.2e1 * t232 * t211 - sin_theta * t13 * t235 * t42 + t240 * t239 + 0.4e1 * t242 * t239 + t249 * t246 - 0.4e1 * t252 * t239 + 0.4e1 * t255 * t239 + t263 * t259 * t258 + t267 * t266 * t265 - m1 * T1_(2) * cos_slope * t174;
t278 = t18 * t4;
t282 = t7 * t99;
t283 = t13 * t102;
t285 = t18 * t105;
t288 = t200 * t227;
t290 = t5 * t184;
t293 = cos_slope * T1_(2) * t10;
t295 = t7 * t105;
t297 = m1 * t26;
t298 = t142 * t266;
t301 = t142 * m2 * rM3y;
t303 = Tss * t59;
t308 = I2 * M3y * Tss;
t314 = I2 * h1;
t315 = h2 * t314;
t318 = t13 * F1_(1) * h1 * t303 - 0.2e1 * m2 * T1_(2) * cos_slope * t174 + t13 * X3_(1) * t11 * t278 + t218 * t220 * t55 + t288 * t5 * t258 - t293 * t189 + t201 * t308 - t283 * t282 + t283 * t285 - t288 * t290 + t293 * t295 + t298 * t297 - t301 * t297 - t298 * t315 + t301 * t315;
t321 = sin_slope * t71;
t325 = h3 * t41 * t40;
t329 = cos_slope * t10;
t331 = cos_theta * t329 * t261;
t335 = sin_theta * t224;
t336 = t335 * t261;
t339 = h2 * m1;
t341 = t13 * rg * m2;
t342 = t341 * t339;
t344 = cos_slope * t52;
t346 = t10 * t26;
t348 = cos_slope * t251;
t351 = cos_slope * m2 * t5;
t357 = t5 * I2;
t358 = m1 * t357;
t360 = rH2y * t * cos_slope;
t363 = m2 * t357;
t368 = -t321 * t23 * h3 * t36 * t4 - t342 * t152 * t109 - t331 * t220 * t87 + t331 * t220 * t93 + t321 * t43 * t325 - t195 * t346 - t195 * t358 - 0.2e1 * t195 * t363 + t348 * t198 + 0.2e1 * t351 * t198 + t336 * t246 - t344 * t290 - t348 * t308 - 0.2e1 * t351 * t308 + t360 * t358 + 0.2e1 * t360 * t363;
t370 = t217 * t23;
t373 = h3 * t26 * t4;
t385 = sin_theta * t118 * t261;
t389 = t341 * t223;
t391 = t248 * t23;
t394 = t13 * t46;
t395 = t394 * t227;
t400 = t394 * t231;
t409 = t217 * t52;
t412 = 0.2e1 * t321 * rg * t114 * t325 + 0.2e1 * t321 * rg * t23 * t373 + t321 * rg * t29 * t373 - 0.2e1 * t217 * t122 * t42 - t335 * t235 * t27 - t248 * t29 * t27 + t370 * t20 + t389 * t206 + 0.3e1 * t395 * t206 - t400 * t211 - t385 * t27 - 0.3e1 * t391 * t27 + t385 * t37 + t391 * t37 - t370 * t9 + 0.2e1 * t409 * t51;
t413 = t50 * t55;
t420 = t341 * t251;
t424 = sin_slope * t224 * t227;
t432 = t394 * t199;
t437 = h3 * t6 * t99;
t439 = F1_(1) * cos_slope * cos_theta;
t440 = t439 * t114;
t454 = t13 * t114 * t199;
t457 = t199 * t40;
t458 = h4 * m2;
t461 = -0.2e1 * t13 * X3_(1) * m2 * t339 * t51 - t321 * m2 * t261 * t246 + 0.2e1 * t248 * t122 * t51 + t217 * t61 * t60 + 0.2e1 * t217 * t64 * t60 + t439 * t458 * t457 - t440 * t101 + 0.4e1 * t420 * t239 - 0.2e1 * t432 * t239 + 0.2e1 * t454 * t239 - 0.4e1 * t249 * t42 - 0.2e1 * t336 * t42 + 0.2e1 * t409 * t413 - t424 * t413 - t424 * t51 + t440 * t437;
t465 = 0.1e1 / Tss;
t495 = cos_theta * t114 * h3 * t6 * h1 + t200 * t6 * I2 + t200 * t6 * I3 + m1 * cos_slope * t357 + cos_slope * t10 * t18 + cos_slope * t114 * t26 - 0.2e1 * cos_slope * t135 * t314 + cos_theta * t261 * t314 + 0.2e1 * t200 * t357 + t329 * t26 - 0.2e1 * t329 * t36 + cos_slope * t59;
t497 = 0.1e1 / t495 / cos_slope / h1;
t499 = t13 * X3_(2);
t503 = Tss * X_(2);
t504 = g * t503;
t507 = X2_(2) * Tss;
t517 = X_(2) * I2;
t518 = Tss * t517;
t528 = H2x * Tss;
t531 = t95 * g * t507 + t130 * t503 * t129 - 0.2e1 * t499 * t148 * t147 + 0.3e1 * t499 * t153 * t152 - t499 * t165 * t164 - 0.4e1 * t499 * t168 * t164 + t288 * t5 * t528 + t112 * t518 + 0.4e1 * t119 * t518 + t127 * t518 + 0.2e1 * t90 * t504 - 0.4e1 * t95 * t504;
t532 = t13 * F1_(2);
t535 = t532 * t179;
t538 = Tss * M3x;
t539 = t5 * t538;
t541 = T1_(1) * cos_slope;
t544 = m2 * rH2x;
t545 = t142 * t544;
t548 = t142 * m2 * rM3x;
t551 = H2x * I2 * Tss;
t556 = I2 * M3x * Tss;
t563 = t142 * h1 * rH2x * t140 + t138 * H2x * t135 - t541 * t114 * t189 + t532 * t135 * t174 - t535 * t178 - t535 * t182 - t201 * t551 + t201 * t556 - t288 * t539 + t545 * t297 - t548 * t297 - t545 * t315 + t548 * t315;
t577 = rM3x * t * cos_slope;
t581 = t13 * X3_(2) * rg;
t582 = t581 * t114;
t584 = t581 * t23;
t590 = F1_(2) * cos_slope * cos_theta;
t593 = -0.2e1 * t581 * t122 * t51 - t130 * t507 * t129 + t541 * t135 * t178 - t159 * X2_(2) * t157 - t499 * t52 * t164 - t590 * t458 * t457 + 0.2e1 * t161 * t504 - t582 * t246 - t344 * t539 - t577 * t346 + t348 * t551 - t584 * t37;
t598 = d * g;
t599 = t598 * t40;
t601 = t13 * pw * t52;
t607 = t590 * t114;
t618 = t71 * m1 * F1_(2);
t627 = 0.2e1 * t13 * X3_(2) * m2 * t339 * t51 + 0.2e1 * t71 * m2 * F1_(2) * t75 + t263 * t259 * t528 + t267 * t544 * t265 + t581 * t29 * t27 + t601 * t598 * t55 + t607 * t101 + 0.3e1 * t584 * t27 + 0.4e1 * t582 * t42 - t607 * t437 - t601 * t599 - t618 * t69 + t618 * t75;
t630 = Tss * d;
t633 = t13 * pw * t10;
t642 = t41 * t503;
t646 = t50 * t503;
t650 = t499 * t23;
t660 = t4 * t517;
t666 = pw * cos_slope * cos_theta * t10 * t261 * t220 * t630 + t633 * t231 * t50 * t630 + 0.2e1 * t633 * t199 * t599 - t499 * t29 * t27 + t499 * t43 * t42 + 0.4e1 * t499 * t46 * t42 - 0.3e1 * t650 * t27 + 0.2e1 * t650 * t37 - t389 * t642 - 0.3e1 * t395 * t642 + t400 * t646 - 0.4e1 * t420 * t660;
t669 = F1_(2) * t10;
t670 = t71 * t669;
t687 = rH2x * t * cos_slope;
t694 = -0.4e1 * t499 * t114 * t42 + 0.4e1 * t499 * t122 * t51 - t670 * t107 + t577 * t193 - t348 * t556 + 0.2e1 * t351 * t551 - 0.2e1 * t351 * t556 - t577 * t358 + t687 * t358 - 0.2e1 * t577 * t363 + 0.2e1 * t687 * t363 + 0.2e1 * t432 * t660 - 0.2e1 * t454 * t660;
t696 = t499 * t12;
t704 = t13 * t669;
t711 = cos_slope * T1_(1) * t10;
t724 = -t13 * F1_(2) * h1 * t303 - m1 * T1_(1) * cos_slope * t174 - 0.2e1 * m2 * T1_(1) * cos_slope * t174 - t13 * X3_(2) * t11 * t278 + t187 * h1 * t538 + t670 * t101 - t711 * t189 + 0.2e1 * t696 * t27 + t704 * t282 - t704 * t285 + t711 * t295 - 0.2e1 * t696 * t37;
t753 = t13 * pw * m2 * t339 * h1 * t598 * t40 + t342 * t152 * t517 + t331 * t220 * t503 - t331 * t220 * t507 - 0.2e1 * t208 * t642 + 0.2e1 * t212 * t646 + t225 * t642 + 0.3e1 * t228 * t642 - 0.2e1 * t232 * t646 - t240 * t660 - 0.4e1 * t242 * t660 + 0.4e1 * t252 * t660 - 0.4e1 * t255 * t660;
t759 = g * m1;
t760 = cos_slope * rg;
t762 = g * m2;
F3_(1) = -t497 * t465 * (t81 + t145 + t205 + t273 + t318 + t368 + t412 + t461);
F3_(2) = t497 * t465 * (t531 + t563 + t593 + t627 + t666 + t694 + t724 + t753);
F3_(3) = -t760 * t759 + cos_slope * t759 - 0.2e1 * t760 * t762 + 0.2e1 * cos_slope * t762;

t4 = cos_theta * h3;
t7 = cos_theta * h4;
t10 = h3 * g;
t11 = t10 * m1;
t13 = rg * cos_slope * sin_theta;
t16 = rg * cos_theta * sin_slope;
t18 = t10 * m2;
t1_(1) = -F1_(2) * t4 - f1_(2) * t4 + F1_(2) * t7 - T1_(1);
t1_(2) = -h3 * sin_theta * f1_(3) - t13 * t11 + t16 * t11 - 0.2e1 * t13 * t18 + 0.2e1 * t16 * t18 + F1_(1) * t4 + f1_(1) * t4 - F1_(1) * t7 - T1_(2);
t1_(3) = sin_theta * (h3 * F1_(2) + h3 * f1_(2) - h4 * F1_(2));

t4 = d * h1;
t5 = pw * F2_(3);
t7 = d * h2;
t11 = F2_(2) * cos_slope;
t12 = h1 ^ 2;
t14 = h1 * h2;
t16 = h2 * cos_slope;
t19 = cos_slope * I2;
t22 = F2_(3) * h1;
t25 = F2_(3) * h2;
t32 = f2_(2) * h1 * t16 + h2 * X2_(2) * f2_(3) - h2 * X_(2) * f2_(3) - pw * f2_(3) * t7 - t12 * t11 + t14 * t11 + ddX2_(2) * t19 - ddX_(2) * t19 - X2_(2) * t22 + X_(2) * t22 + X2_(2) * t25 - X_(2) * t25 + t5 * t4 - t7 * t5;
t33 = 0.1e1 / h1;
t35 = F2_(1) * cos_slope;
t50 = f2_(3) * h2;
t53 = f2_(1) * h1 * t16 - X2_(1) * h1 * F2_(3) + X_(1) * h1 * F2_(3) + X2_(1) * h2 * F2_(3) - X_(1) * h2 * F2_(3) - t12 * t35 + t14 * t35 + ddX2_(1) * t19 - ddX_(1) * t19 + X2_(1) * t50 - X_(1) * t50;
t58 = pw * h2;
t63 = I2 * d;
t68 = F2_(1) * t12;
t71 = F2_(2) * t12;
t80 = -pw * F2_(1) * t12 * d + pw * ddX2_(1) * t63 - pw * ddX_(1) * t63 - F2_(1) * X2_(2) * t14 + F2_(1) * X_(2) * t14 + F2_(2) * X2_(1) * t14 + t4 * F2_(1) * t58 + f2_(1) * t58 * t4 + X2_(2) * t68 - X_(2) * t68 - X2_(1) * t71 + X_(1) * t71;
t91 = X2_(1) * I2;
t94 = X2_(2) * I2;
t97 = I2 * X_(1);
t100 = X_(2) * I2;
t103 = -F2_(2) * X_(1) * t14 + X2_(1) * f2_(2) * t14 - X2_(2) * f2_(1) * t14 - X_(1) * f2_(2) * t14 + X_(2) * f2_(1) * t14 + ddX2_(1) * t100 - ddX_(1) * t100 + ddX2_(2) * t91 - ddX_(2) * t91 - ddX2_(1) * t94 + ddX_(1) * t94 - ddX2_(2) * t97 + ddX_(2) * t97;
t2_(1) = t33 * t32;
t2_(2) = -t33 * t53;
t2_(3) = 0.1e1 / t12 * (t80 + t103);

t4 = d * h1;
t5 = pw * F2_(3);
t7 = pw * f2_(3);
t11 = d * h2;
t14 = F2_(2) * cos_slope;
t15 = h1 ^ 2;
t17 = h1 * h2;
t19 = h2 * cos_slope;
t22 = h1 * h3;
t23 = F1_(2) * cos_theta;
t27 = h1 * h4;
t29 = cos_slope * I2;
t32 = F2_(3) * h1;
t35 = F2_(3) * h2;
t43 = f2_(2) * h1 * t19 + h2 * X2_(2) * f2_(3) - h2 * X_(2) * f2_(3) - pw * f3_(3) * t4 - f1_(2) * cos_theta * t22 - h1 * T1_(1) - t5 * t11 - t11 * t7 - t15 * t14 + t17 * t14 - t23 * t22 + t23 * t27 + ddX2_(2) * t29 - ddX_(2) * t29 - X2_(2) * t32 + X_(2) * t32 + X2_(2) * t35 - X_(2) * t35 + t5 * t4 + t7 * t4;
t44 = 0.1e1 / h1;
t47 = g * h1 * h3;
t48 = m1 * rg;
t49 = cos_slope * sin_theta;
t52 = cos_theta * sin_slope;
t55 = m2 * rg;
t62 = F2_(1) * cos_slope;
t67 = F1_(1) * cos_theta;
t84 = f2_(3) * h2;
t88 = f2_(1) * h1 * t19 - X2_(1) * h1 * F2_(3) + X_(1) * h1 * F2_(3) + X2_(1) * h2 * F2_(3) - X_(1) * h2 * F2_(3) - f1_(1) * cos_theta * t22 + f1_(3) * sin_theta * t22 + t49 * t48 * t47 - t52 * t48 * t47 + 0.2e1 * t49 * t55 * t47 - 0.2e1 * t55 * t52 * t47 + h1 * T1_(2) - t15 * t62 + t17 * t62 - t67 * t22 + t67 * t27 + ddX2_(1) * t29 - ddX_(1) * t29 + X2_(1) * t84 - X_(1) * t84;
t90 = t15 * d;
t97 = pw * h2;
t102 = h3 * t15;
t103 = F1_(2) * sin_theta;
t109 = I2 * d;
t114 = F2_(1) * t15;
t117 = F2_(2) * t15;
t122 = -t103 * h4 * t15 + pw * ddX2_(1) * t109 - pw * ddX_(1) * t109 - pw * F2_(1) * t90 - pw * f2_(1) * t90 + pw * f3_(1) * t90 + f1_(2) * sin_theta * t102 - F2_(1) * X2_(2) * t17 + F2_(1) * t97 * t4 + f2_(1) * t97 * t4 + t103 * t102 + X2_(2) * t114 - X_(2) * t114 - X2_(1) * t117 + X_(1) * t117;
t137 = X2_(1) * I2;
t140 = X2_(2) * I2;
t143 = I2 * X_(1);
t146 = X_(2) * I2;
t149 = F2_(1) * X_(2) * t17 + F2_(2) * X2_(1) * t17 - F2_(2) * X_(1) * t17 + X2_(1) * f2_(2) * t17 - X2_(2) * f2_(1) * t17 - X_(1) * f2_(2) * t17 + X_(2) * f2_(1) * t17 + ddX2_(2) * t137 - ddX_(2) * t137 - ddX2_(1) * t140 + ddX_(1) * t140 - ddX2_(2) * t143 + ddX_(2) * t143 + ddX2_(1) * t146 - ddX_(1) * t146;
t3_(1) = -t44 * t43;
t3_(2) = t44 * t88;
t3_(3) = -0.1e1 / t15 * (t122 + t149);

T1_(1) = T1_(1);
T1_(2) = T1_(2);
T1_(3) = 0.0e0;

T2_(1) = 0.0e0;
T2_(2) = 0.0e0;
T2_(3) = 0.0e0;

t4 = d * h1;
t5 = pw * F2_(3);
t7 = pw * F3_(3);
t9 = pw * f2_(3);
t11 = pw * f3_(3);
t13 = d * h2;
t18 = F2_(2) * cos_slope;
t19 = h1 ^ 2;
t21 = F3_(2) * cos_slope;
t23 = h1 * h2;
t26 = h2 * cos_slope;
t31 = h1 * h3;
t32 = F1_(2) * cos_theta;
t36 = f2_(2) * h1 * t26 + f3_(2) * h1 * t26 - f1_(2) * cos_theta * t31 + t13 * t11 - t11 * t4 - t5 * t13 + t7 * t13 - t9 * t13 - t19 * t18 + t23 * t18 - t19 * t21 + t23 * t21 - t32 * t31 + t5 * t4 - t7 * t4 + t9 * t4;
t37 = h1 * h4;
t39 = cos_slope * I2;
t42 = cos_slope * I3;
t44 = F2_(3) * h1;
t51 = F2_(3) * h2;
t60 = f3_(3) * h2;
t62 = X_(2) * h2;
t66 = -h1 * X3_(2) * F3_(3) + h1 * F3_(3) * X_(2) + h2 * X3_(2) * F3_(3) - h2 * F3_(3) * X_(2) + h2 * X2_(2) * f2_(3) - h1 * T1_(1) + t32 * t37 + ddX2_(2) * t39 - ddX_(2) * t39 - ddX_(2) * t42 - X2_(2) * t44 + X_(2) * t44 + X2_(2) * t51 - X_(2) * t51 + X3_(2) * t60 - f2_(3) * t62 - f3_(3) * t62;
t68 = 0.1e1 / h1;
t70 = F2_(1) * cos_slope;
t72 = cos_slope * F3_(1);
t83 = h1 * X_(1);
t88 = h2 * X_(1);
t91 = f2_(3) * h2;
t95 = f2_(1) * h1 * t26 + f3_(1) * h1 * t26 - X2_(1) * h1 * F2_(3) + X2_(1) * h2 * F2_(3) + f1_(3) * sin_theta * t31 + t23 * t70 + t23 * t72 - ddX_(1) * t42 - X_(1) * t60 + F2_(3) * t83 + F3_(3) * t83 - F2_(3) * t88 - F3_(3) * t88 + X2_(1) * t91 - X_(1) * t91;
t97 = g * h1 * h3;
t98 = m1 * rg;
t99 = cos_slope * sin_theta;
t102 = cos_theta * sin_slope;
t105 = m2 * rg;
t114 = F1_(1) * cos_theta;
t121 = X3_(1) * h1;
t127 = h2 * X3_(1) * F3_(3) - 0.2e1 * t105 * t102 * t97 - t102 * t98 * t97 + 0.2e1 * t99 * t105 * t97 - f1_(1) * cos_theta * t31 + t99 * t98 * t97 + h1 * T1_(2) - t114 * t31 + t114 * t37 - F3_(3) * t121 - t19 * t70 - t19 * t72 + ddX2_(1) * t39 - ddX_(1) * t39 + X3_(1) * t60;
t130 = t19 * d;
t139 = pw * h2;
t148 = h3 * t19;
t149 = F1_(2) * sin_theta;
t155 = I2 * d;
t158 = -t149 * h4 * t19 - pw * F2_(1) * t130 + pw * F3_(1) * t130 - pw * f2_(1) * t130 + pw * f3_(1) * t130 + pw * ddX2_(1) * t155 + F2_(1) * t139 * t4 - F3_(1) * t139 * t4 + f2_(1) * t139 * t4 - f3_(1) * t139 * t4 + f1_(2) * sin_theta * t148 + t149 * t148;
t159 = pw * ddX_(1);
t163 = F2_(1) * t19;
t166 = F2_(2) * t19;
t183 = t159 * I3 * d + F3_(1) * X3_(2) * t19 - X_(2) * F3_(1) * t19 - F3_(2) * X3_(1) * t19 + X_(1) * F3_(2) * t19 - F2_(1) * X2_(2) * t23 + F2_(1) * X_(2) * t23 + F2_(2) * X2_(1) * t23 - t159 * t155 + X2_(2) * t163 - X_(2) * t163 - X2_(1) * t166 + X_(1) * t166;
t209 = t121 * h2 * f3_(2) - F2_(2) * X_(1) * t23 - X3_(2) * F3_(1) * t23 + F3_(1) * X_(2) * t23 + X3_(1) * F3_(2) * t23 - F3_(2) * X_(1) * t23 + X2_(1) * f2_(2) * t23 - X2_(2) * f2_(1) * t23 - f3_(1) * X3_(2) * t23 - X_(1) * f2_(2) * t23 - X_(1) * f3_(2) * t23 + X_(2) * f2_(1) * t23;
t212 = X2_(1) * I2;
t215 = X2_(2) * I2;
t218 = I2 * X_(1);
t221 = X_(2) * I2;
t232 = -I3 * X3_(1) * ddX_(2) + I3 * X3_(2) * ddX_(1) + I3 * X_(1) * ddX_(2) - I3 * X_(2) * ddX_(1) + X_(2) * f3_(1) * t23 + ddX2_(2) * t212 - ddX_(2) * t212 - ddX2_(1) * t215 + ddX_(1) * t215 - ddX2_(2) * t218 + ddX_(2) * t218 + ddX2_(1) * t221 - ddX_(1) * t221;
T3_(1) = t68 * (t36 + t66);
T3_(2) = -(t95 + t127) * t68;
T3_(3) = 0.1e1 / t19 * (t158 + t183 + t209 + t232);

t4 = dX_(1) ^ 2;
t6 = h1 ^ 2;
t9 = m2 * t6;
t11 = h1 * h2;
t18 = h2 ^ 2;
t19 = m2 * t18;
t20 = dX2_(1) ^ 2;
t23 = dX2_(1) * dX_(1);
t26 = cos_slope ^ 2;
t27 = t26 * I2;
t33 = t26 * I3;
t36 = 0.5000000000e0 * t6 * t4 * m1 + t9 * t4 + m2 * dX2_(1) * dX_(1) * t11 - 0.2e1 * t4 * m2 * t11 + 0.5000000000e0 * t20 * t19 - t23 * t19 + t19 * t4 + 0.5000000000e0 * t20 * t27 - t23 * t27 + 0.5000000000e0 * t4 * t27 + 0.5000000000e0 * t4 * t33;
t37 = 0.1e1 / t6;
t39 = dX_(2) ^ 2;
t50 = dX2_(2) ^ 2;
t53 = dX2_(2) * dX_(2);
t63 = 0.5000000000e0 * t6 * t39 * m1 + t39 * t9 + m2 * dX2_(2) * dX_(2) * t11 - 0.2e1 * t39 * m2 * t11 + 0.5000000000e0 * t50 * t19 - t53 * t19 + t39 * t19 + 0.5000000000e0 * t50 * t27 - t53 * t27 + 0.5000000000e0 * t39 * t27 + 0.5000000000e0 * t39 * t33;
K_(1) = t37 * t36;
K_(2) = t37 * t63;
K_(3) = 0.0e0;

out.X = X_; 
out.x2 = x2_; 
out.x3 = x3_; 
out.y1 = y1_; 
out.y2 = y2_; 
out.y3 = y3_; 
out.X3 = X3_; 
out.X2 = X2_; 
out.X1 = X1_; 
out.com = com_; 
out.dcom = dcom_; 
out.dX = dX_; 
out.dX2 = dX2_; 
out.X0 = X0_; 
out.ddX = ddX_; 
out.ddX2 = ddX2_; 
out.f1 = f1_; 
out.f2 = f2_; 
out.f3 = f3_; 
out.F1 = F1_; 
out.F2 = F2_; 
out.F3 = F3_; 
out.t1 = t1_; 
out.t2 = t2_; 
out.t3 = t3_; 
out.T1 = T1_; 
out.T2 = T2_; 
out.T3 = T3_; 
out.K = K_; 
