function out = vis_maple_DS(state_vector,scenario,t) 

% This function calculates extra 3LP variables based on the state vector in
% the double support phase
% Author:         Salman Faraji
% Date:           March 2018
% Available from: https://biorob.epfl.ch/research/humanoid/walkman
%  All rights reserved. ECOLE POLYTECHNIQUE FEDERALE DE LAUSANNE, Switzerland
% BIOROB Laboratory, 2018
% Walking3LP must be referenced when used in a published work 
% See the LICENSE.txt file for more details.

out = struct(); 
maple_model; 


X2_(1) = state_vector(1);
X2_(2) = state_vector(2);
X_(1) = state_vector(3);
X_(2) = state_vector(4);
dX2_(1) = state_vector(5);
dX2_(2) = state_vector(6);
dX_(1) = state_vector(7);
dX_(2) = state_vector(8);
X3_(1) = state_vector(9);
X3_(2) = state_vector(10);
H2y = state_vector(11);
H2x = state_vector(12);
M3y = state_vector(13);
M3x = state_vector(14);
rH2y = state_vector(15);
rH2x = state_vector(16);
rM3y = state_vector(17);
rM3x = state_vector(18);
F1_(1) = state_vector(19);
F1_(2) = state_vector(20);
T1_(2) = state_vector(21);
T1_(1) = state_vector(22);
sin_theta = state_vector(23);
sin_slope = state_vector(24);
d = state_vector(25);

 
 
X_(1) = X_(1);
X_(2) = X_(2);
X_(3) = h1 * cos_slope;

x2_(1) = X_(1);
x2_(2) = d * pw + X_(2);
x2_(3) = h1 * cos_slope;

x3_(1) = X_(1);
x3_(2) = -d * pw + X_(2);
x3_(3) = h1 * cos_slope;

y1_(1) = h3 * sin_theta + X_(1);
y1_(2) = X_(2);
y1_(3) = h1 * cos_slope + h3 * cos_theta;

t5 = 0.1e1 / h1 * h2;
t9 = d * pw;
y2_(1) = X_(1) + t5 * (X2_(1) - X_(1));
y2_(2) = X_(2) + t9 + t5 * (-t9 + X2_(2) - X_(2));
y2_(3) = h1 * cos_slope - h2 * cos_slope;

t5 = 0.1e1 / h1 * h2;
t9 = d * pw;
y3_(1) = X_(1) + (X3_(1) - X_(1)) * t5;
y3_(2) = X_(2) - t9 + (t9 + X3_(2) - X_(2)) * t5;
y3_(3) = h1 * cos_slope - h2 * cos_slope;

X3_(1) = X3_(1);
X3_(2) = X3_(2);
X3_(3) = 0.0e0;

X2_(1) = X2_(1);
X2_(2) = X2_(2);
X2_(3) = 0.0e0;

X1_(1) = h4 * sin_theta + X_(1);
X1_(2) = X_(2);
X1_(3) = h1 * cos_slope + h4 * cos_theta;

t7 = m1 * h1;
t9 = m2 * h1;
t12 = m2 * h2;
t20 = 0.1e1 / (m1 + 0.2e1 * m2);
t22 = 0.1e1 / h1;
com_(1) = t22 * t20 * (h1 * h3 * m1 * sin_theta + X2_(1) * t12 + X3_(1) * t12 - 0.2e1 * X_(1) * t12 + X_(1) * t7 + 0.2e1 * X_(1) * t9);
com_(2) = t22 * t20 * (X2_(2) * t12 + X3_(2) * t12 - 0.2e1 * X_(2) * t12 + X_(2) * t7 + 0.2e1 * X_(2) * t9);
com_(3) = t20 * (h3 * cos_theta * m1 - 0.2e1 * cos_slope * t12 + cos_slope * t7 + 0.2e1 * cos_slope * t9);

t4 = m1 * h1;
t6 = m2 * h1;
t9 = m2 * h2;
t16 = 0.1e1 / (m1 + 0.2e1 * m2);
t18 = 0.1e1 / h1;
dcom_(1) = t18 * t16 * (dX_(1) * t4 + 0.2e1 * dX_(1) * t6 + dX2_(1) * t9 - 0.2e1 * dX_(1) * t9);
dcom_(2) = t18 * t16 * (dX_(2) * t4 + 0.2e1 * dX_(2) * t6 + dX2_(2) * t9 - 0.2e1 * dX_(2) * t9);
dcom_(3) = 0.0e0;

dX_(1) = dX_(1);
dX_(2) = dX_(2);
dX_(3) = 0.0e0;

dX2_(1) = dX2_(1);
dX2_(2) = dX2_(2);
dX2_(3) = 0.0e0;

X0_(1) = h5 * sin_theta + X_(1);
X0_(2) = X_(2);
X0_(3) = h1 * cos_slope + h5 * cos_theta;

t4 = h1 ^ 2;
t11 = m2 * cos_slope;
t17 = h2 ^ 2;
t24 = 0.1e1 / (h1 * h3 * m1 * cos_theta - 0.4e1 * t11 * h1 * h2 + cos_slope * m1 * t4 + 0.2e1 * cos_slope * m2 * t17 + 0.2e1 * cos_slope * m2 * t4 + I2 * cos_slope + I3 * cos_slope);
t25 = 0.1e1 / Tds;
t27 = g * Tds;
t28 = t4 * t27;
t29 = m1 * rg;
t30 = cos_slope * sin_slope;
t33 = m2 * rg;
t37 = cos_slope * m1;
t46 = h1 * Tds;
t50 = h1 * t27;
t51 = h3 * m1;
t58 = cos_slope * X2_(1);
t61 = cos_slope * X_(1);
t70 = h1 * g;
t71 = m1 * t70;
t72 = rg * t;
t73 = t58 * t72;
t75 = X3_(1) * cos_slope;
t76 = t75 * t72;
t78 = m2 * t70;
t85 = 0.2e1 * t46 * g * sin_slope * h2 * cos_slope * m2 + cos_slope * sin_theta * t51 * t50 - cos_theta * sin_slope * t51 * t50 - 0.2e1 * sin_slope * t11 * t28 + t30 * t29 * t28 + 0.2e1 * t30 * t33 * t28 - sin_slope * t37 * t28 + t58 * t29 * t50 - t61 * t29 * t50 + 0.2e1 * t58 * t33 * t50 - 0.2e1 * t61 * t33 * t50 - X2_(1) * t37 * t50 - t73 * t71 + t76 * t71 - 0.2e1 * t73 * t78 + 0.2e1 * t76 * t78;
t88 = X2_(1) * t11;
t91 = X_(1) * t11;
t94 = h2 * t27;
t102 = cos_slope * t;
t103 = X2_(1) * t102;
t106 = t * X3_(1) * cos_slope;
t112 = t4 * Tds;
t124 = Tds * t75 * h2 * m2 * g + h4 * F1_(1) * cos_theta * t46 + M3y * Tds * h1 - h1 * rM3y * t + F1_(1) * cos_slope * t112 + X_(1) * t37 * t50 + rM3y * t46 + t103 * t71 + 0.2e1 * t103 * t78 - t106 * t71 - 0.2e1 * t106 * t78 + T1_(2) * t46 - 0.2e1 * t88 * t50 + 0.2e1 * t91 * t50 + t88 * t94 - 0.2e1 * t91 * t94;
t127 = cos_slope * X2_(2);
t130 = cos_slope * X_(2);
t139 = t127 * t72;
t142 = X3_(2) * cos_slope * t72;
t152 = X2_(2) * t11;
t155 = X_(2) * t11;
t159 = t127 * t29 * t50 + 0.2e1 * t127 * t33 * t50 - t130 * t29 * t50 - 0.2e1 * t130 * t33 * t50 - X2_(2) * t37 * t50 + X_(2) * t37 * t50 - t139 * t71 - 0.2e1 * t139 * t78 + t142 * t71 + 0.2e1 * t142 * t78 - 0.2e1 * t152 * t50 + t152 * t94 + 0.2e1 * t155 * t50;
t165 = X2_(2) * t102;
t168 = t * X3_(2) * cos_slope;
t188 = h4 * F1_(2) * cos_theta * t46 + m2 * X3_(2) * cos_slope * t94 + M3x * Tds * h1 - 0.2e1 * t * M3x * h1 - h1 * rM3x * t + F1_(2) * cos_slope * t112 + rM3x * t46 - 0.2e1 * t155 * t94 + t165 * t71 + 0.2e1 * t165 * t78 - t168 * t71 - 0.2e1 * t168 * t78 - T1_(1) * t46;
ddX_(1) = (t85 + t124) * t25 * t24;
ddX_(2) = t24 * t25 * (t159 + t188);
ddX_(3) = 0.0e0;

ddX2_(1) = 0.0e0;
ddX2_(2) = 0.0e0;
ddX2_(3) = 0.0e0;

t4 = 0.1e1 / Tds;
t5 = m2 * Tds;
t6 = h1 ^ 2;
t7 = t6 * cos_slope;
t10 = rg * sin_slope;
t14 = m2 ^ 2;
t21 = g * Tds;
t22 = h1 * h2;
t23 = t22 * t21;
t24 = m1 * m2;
t31 = cos_slope * sin_slope;
t32 = t31 * rg * t14;
t35 = h1 * h3;
t36 = t35 * t21;
t37 = m1 ^ 2;
t38 = rg * t37;
t47 = h2 ^ 2;
t50 = m2 * rg;
t51 = t31 * t50;
t54 = t47 * t21;
t70 = h1 * t21;
t71 = cos_slope * X2_(1);
t74 = -sin_theta * t37 * g * h3 * Tds * cos_slope * h1 + 0.2e1 * g * h2 * m1 * sin_slope * cos_slope * h1 * t5 + 0.4e1 * t10 * g * t6 * cos_slope * Tds * t14 + 0.2e1 * t10 * g * m1 * t7 * t5 - 0.4e1 * rg * cos_slope * sin_slope * t24 * t23 + 0.2e1 * rg * cos_theta * sin_slope * t24 * t36 + 0.2e1 * t51 * m1 * t47 * t21 + cos_theta * sin_slope * t38 * t36 - t71 * t38 * t70 - 0.8e1 * t32 * t23 + 0.4e1 * t32 * t54;
t75 = cos_slope * X_(1);
t78 = m1 * h1;
t79 = t78 * t21;
t89 = h1 * g;
t90 = t37 * t89;
t91 = rg * t;
t92 = t71 * t91;
t94 = X3_(1) * cos_slope;
t95 = t91 * t94;
t97 = t24 * t89;
t102 = Tds * I2;
t103 = g * t102;
t104 = m1 * rg;
t105 = t31 * t104;
t109 = Tds * I3;
t110 = g * t109;
t114 = -0.2e1 * t31 * t24 * t54 + t75 * t38 * t70 - 0.2e1 * t71 * t50 * t79 + 0.2e1 * t75 * t50 * t79 + t105 * t103 + 0.2e1 * t51 * t103 + t105 * t110 + 0.2e1 * t51 * t110 + t92 * t90 - t95 * t90 + 0.2e1 * t92 * t97 - 0.2e1 * t95 * t97;
t116 = cos_slope * t37;
t121 = t71 * t24;
t124 = t75 * t24;
t127 = h2 * t21;
t133 = cos_slope * t;
t139 = m1 * t89;
t140 = m2 * t;
t148 = m1 * cos_slope * sin_slope;
t150 = t * X3_(1) * cos_slope * t90 + X2_(1) * t116 * t70 - X_(1) * t116 * t70 - t94 * t24 * t127 - X2_(1) * t133 * t90 - 0.2e1 * t71 * t140 * t139 + 0.2e1 * t94 * t140 * t139 - t148 * t103 - t121 * t127 + 0.2e1 * t121 * t70 + 0.2e1 * t124 * t127 - 0.2e1 * t124 * t70;
t155 = h1 * Tds;
t156 = h2 * t155;
t158 = m2 * F1_(1) * cos_slope;
t161 = h3 * t155;
t163 = m1 * F1_(1) * cos_theta;
t165 = h4 * t155;
t167 = t47 * Tds;
t170 = F1_(1) * cos_slope;
t181 = -M3y * m1 * t155 - m1 * rM3y * t155 - m1 * T1_(2) * t155 + rM3y * t * t78 + 0.2e1 * F1_(1) * t7 * t5 + t170 * t102 + t170 * t109 - t148 * t110 - 0.4e1 * t158 * t156 + 0.2e1 * t158 * t167 + t163 * t161 - t163 * t165;
t201 = 0.1e1 / (m1 * cos_theta * t35 + cos_slope * m1 * t6 - 0.4e1 * m2 * cos_slope * t22 + 0.2e1 * cos_slope * m2 * t47 + 0.2e1 * cos_slope * m2 * t6 + I2 * cos_slope + I3 * cos_slope);
t203 = cos_slope * X2_(2);
t206 = cos_slope * X_(2);
t215 = t203 * t91;
t217 = X3_(2) * cos_slope;
t218 = t217 * t91;
t228 = t203 * t24;
t231 = t206 * t24;
t239 = X2_(2) * t116 * t70 - X_(2) * t116 * t70 - t217 * t24 * t127 - t203 * t38 * t70 - 0.2e1 * t203 * t50 * t79 + t206 * t38 * t70 + 0.2e1 * t206 * t50 * t79 - t228 * t127 + 0.2e1 * t231 * t127 + t215 * t90 + 0.2e1 * t215 * t97 - t218 * t90 - 0.2e1 * t218 * t97 + 0.2e1 * t228 * t70 - 0.2e1 * t231 * t70;
t253 = m2 * F1_(2) * cos_slope;
t259 = m1 * F1_(2) * cos_theta;
t264 = F1_(2) * cos_slope;
t279 = 0.2e1 * M3x * h1 * m1 * t + t * X3_(2) * cos_slope * t90 - t78 * M3x * Tds + 0.2e1 * t253 * t6 * Tds - m1 * rM3x * t155 + m1 * T1_(1) * t155 + rM3x * t * t78 - X2_(2) * t133 * t90 - 0.2e1 * t203 * t140 * t139 + 0.2e1 * t217 * t140 * t139 + t264 * t102 + t264 * t109 - 0.4e1 * t253 * t156 + t259 * t161 - t259 * t165 + 0.2e1 * t253 * t167;
f1_(1) = -t201 * (t74 + t114 + t150 + t181) * t4;
f1_(2) = -t201 * t4 * (t239 + t279);
f1_(3) = -(t104 + 0.2e1 * t50 - m1) * cos_slope * g;

t4 = Tds ^ 2;
t5 = cos_slope ^ 2;
t6 = t5 * t4;
t7 = h1 ^ 2;
t8 = t7 * h1;
t9 = t8 * t6;
t10 = g * X2_(1);
t11 = m1 ^ 2;
t14 = g * X_(1);
t17 = m2 ^ 2;
t21 = t4 * X2_(1);
t22 = g * t21;
t23 = h2 ^ 2;
t24 = t23 * h2;
t25 = t17 * t24;
t26 = t5 * t25;
t28 = t4 * m2;
t29 = t7 ^ 2;
t30 = t29 * t5;
t33 = t4 * H2y;
t34 = m1 * t8;
t35 = cos_slope * t34;
t37 = m2 * t8;
t38 = cos_slope * t37;
t41 = t4 * I2;
t45 = cos_slope * t4;
t46 = M3y * t8;
t51 = t8 * t4;
t52 = rH2y * m1;
t59 = rH2y * m2;
t60 = cos_slope * t59;
t65 = t5 * F1_(1) * t7 * t41 - m1 * t46 * t45 - m2 * t46 * t45 - rM3y * t34 * t45 - rM3y * t37 * t45 + t11 * t10 * t9 + 0.2e1 * t10 * t17 * t9 - t11 * t14 * t9 + F1_(1) * t30 * t28 - T1_(2) * t34 * t45 + cos_slope * t52 * t51 - t26 * t22 + t35 * t33 + 0.2e1 * t38 * t33 + 0.2e1 * t60 * t51;
t68 = t7 * t4;
t69 = h2 * t68;
t73 = t8 * cos_slope * Tds;
t74 = rM3y * m1;
t77 = rM3y * m2;
t80 = t ^ 2;
t81 = t80 * rH2y;
t82 = cos_slope * t81;
t86 = H2y * I2;
t87 = h1 * t4;
t88 = cos_slope * t87;
t90 = H2y * I3;
t93 = h1 * rH2y * cos_slope;
t95 = I2 * h1;
t97 = I3 * M3y;
t99 = t4 * I3;
t107 = I3 * h1;
t109 = -h1 * rM3y * cos_slope * t99 - h1 * T1_(2) * cos_slope * t99 + t * t74 * t73 + t73 * t * t77 - T1_(2) * t37 * t45 + t82 * t107 + t82 * t34 + 0.2e1 * t82 * t37 + t93 * t41 - 0.4e1 * t60 * t69 + t82 * t95 + t88 * t86 + t88 * t90 - t88 * t97 + t93 * t99;
t112 = g * m1;
t113 = rg * sin_slope;
t118 = g * h2;
t129 = g * t4;
t130 = t24 * t129;
t134 = g * t41;
t135 = m1 * t7;
t136 = sin_slope * t5;
t139 = m2 * t7;
t140 = t136 * t139;
t142 = h2 * t51;
t143 = F1_(1) * m2;
t144 = t5 * t143;
t147 = t23 * t68;
t150 = m2 * T1_(2) * cos_slope;
t153 = t23 * t87;
t155 = t8 * Tds;
t156 = m1 * t155;
t158 = t * T1_(2) * cos_slope;
t160 = m2 * t155;
t163 = Tds * I2;
t164 = h1 * t163;
t166 = Tds * I3;
t167 = h1 * t166;
t169 = t113 * t112 * t30 * t28 + m1 * sin_slope * t118 * t8 * t5 * t28 - sin_theta * t11 * g * h3 * t9 - 0.2e1 * t17 * t14 * t9 + t5 * X3_(1) * t17 * t130 - t136 * t135 * t134 - t140 * t134 - 0.2e1 * t144 * t142 + t144 * t147 + 0.2e1 * t150 * t69 - t150 * t153 + t158 * t156 + 0.2e1 * t158 * t160 + t158 * t164 + t158 * t167;
t170 = t4 * M3y;
t172 = m2 * h2;
t173 = cos_slope * t172;
t177 = m2 * t23;
t178 = cos_slope * t177;
t180 = cos_slope * t77;
t183 = h3 * t68;
t189 = rH2y * t * cos_slope;
t194 = h2 * t7;
t195 = m2 * t194;
t198 = h3 * t7;
t199 = m1 * t198;
t202 = t23 * h1;
t203 = m2 * t202;
t208 = h1 * t * cos_slope;
t223 = t208 * I2 * M3y * Tds - 0.2e1 * t208 * Tds * t86 - 0.2e1 * t208 * Tds * t90 + t208 * Tds * t97 - t178 * h1 * t170 + 0.2e1 * t173 * t7 * t170 + cos_theta * t52 * t183 + cos_theta * t81 * t199 + 0.2e1 * t60 * t153 - 0.2e1 * t189 * t156 - 0.4e1 * t189 * t160 - 0.2e1 * t189 * t164 - 0.2e1 * t189 * t167 + 0.2e1 * t180 * t69 - 0.4e1 * t82 * t195 + 0.2e1 * t82 * t203;
t226 = g * t8;
t228 = h3 * m1;
t232 = t7 * g;
t233 = t232 * t21;
t234 = t17 * h2;
t235 = t5 * rg;
t236 = t235 * t234;
t239 = X_(1) * Tds;
t240 = t226 * t239;
t241 = rg * t11;
t242 = t5 * t;
t243 = t242 * t241;
t245 = g * Tds;
t246 = t17 * t8;
t247 = t246 * t245;
t248 = rg * t;
t249 = t5 * X3_(1);
t253 = rg * t17;
t254 = t242 * t253;
t257 = t232 * t41;
t258 = m1 * rg;
t261 = m2 * rg;
t265 = h2 * m1;
t266 = t5 * m2;
t267 = t266 * t265;
t270 = t5 * t17;
t271 = t270 * t194;
t274 = h1 * g;
t275 = t274 * t21;
t276 = m1 * t23;
t277 = t266 * t276;
t279 = t4 * X_(1);
t280 = t274 * t279;
t282 = t270 * t202;
t285 = g * t239;
t286 = t11 * t8;
t287 = t242 * t286;
t289 = t5 * Tds;
t290 = X2_(1) * t8;
t291 = t290 * t289;
t292 = m2 * t;
t296 = t34 * t245;
t297 = t249 * t292;
t299 = -m2 * sin_theta * t228 * t226 * t6 + 0.4e1 * t236 * t233 - t243 * t240 + 0.2e1 * t249 * t248 * t247 - 0.4e1 * t254 * t240 + t136 * t258 * t257 + 0.2e1 * t136 * t261 * t257 - 0.3e1 * t267 * t233 - 0.5e1 * t271 * t22 + t277 * t275 - t277 * t280 + 0.4e1 * t282 * t22 + t287 * t285 - 0.3e1 * t292 * t112 * t291 - t297 * t296;
t300 = m1 * m2;
t301 = t242 * t300;
t304 = t242 * t246;
t307 = X2_(1) * Tds;
t308 = t232 * t307;
t309 = t242 * t234;
t312 = t194 * t245;
t313 = t * t17;
t314 = t249 * t313;
t317 = t232 * t239;
t320 = t274 * t307;
t321 = t17 * t23;
t322 = t242 * t321;
t325 = t202 * t245;
t328 = t274 * t239;
t331 = t198 * t10;
t332 = t80 * t11;
t333 = cos_slope * cos_theta;
t334 = t333 * t332;
t336 = t11 * h3;
t337 = t336 * t232;
t341 = I3 * X2_(1);
t342 = t129 * t341;
t343 = m1 * h1;
t344 = t235 * t343;
t346 = I3 * X_(1);
t347 = t129 * t346;
t349 = m2 * h1;
t350 = t235 * t349;
t355 = h2 * h4;
t356 = t355 * t68;
t357 = t333 * t143;
t360 = t333 * X3_(1) * t80 * t337 + 0.4e1 * t301 * t240 + 0.4e1 * t304 * t285 + 0.4e1 * t309 * t308 - 0.8e1 * t309 * t317 + 0.4e1 * t314 * t312 - 0.2e1 * t314 * t325 - 0.2e1 * t322 * t320 + 0.4e1 * t322 * t328 - t334 * t331 - t344 * t342 - 0.2e1 * t350 * t342 + t344 * t347 + 0.2e1 * t350 * t347 + 0.2e1 * t357 * t356;
t362 = h4 * t23;
t363 = t362 * t87;
t365 = t228 * t155;
t367 = t333 * t * F1_(1);
t369 = h4 * m1;
t370 = t369 * t155;
t372 = h4 * m2;
t376 = X_(1) * I2;
t378 = t266 * t118;
t380 = t274 * t163;
t381 = m1 * t;
t384 = t245 * t376;
t385 = t242 * t343;
t389 = t242 * t349;
t392 = t4 * t341;
t394 = t5 * m1 * t274;
t396 = t4 * t346;
t398 = t266 * t274;
t405 = 0.2e1 * t367 * t372 * t155 - t249 * t381 * t380 - t378 * t4 * t376 - 0.2e1 * t297 * t380 - t357 * t363 - t367 * t365 + t367 * t370 - t378 * t392 + t378 * t396 + t385 * t384 + 0.2e1 * t389 * t384 + t394 * t392 + 0.2e1 * t398 * t392 - t394 * t396 - 0.2e1 * t398 * t396;
t406 = t245 * t341;
t408 = t245 * t346;
t414 = t7 * t33;
t417 = cos_theta * t228;
t422 = Tds * H2y;
t423 = t8 * t422;
t424 = cos_slope * t381;
t427 = cos_slope * t292;
t430 = h1 * h4;
t431 = t430 * t163;
t433 = t430 * t166;
t435 = Tds * M3y;
t436 = t8 * t435;
t447 = rM3y * t * cos_slope * t167 + cos_theta * t80 * rM3y * t199 + 0.2e1 * t178 * h1 * t33 - t180 * t153 - 0.4e1 * t173 * t414 + t367 * t431 + t367 * t433 - t385 * t406 + t385 * t408 - 0.2e1 * t389 * t406 + 0.2e1 * t389 * t408 + t417 * t414 - 0.2e1 * t424 * t423 - 0.4e1 * t427 * t423 + t424 * t436 + 0.2e1 * t427 * t436;
t452 = h2 * t8 * t129;
t453 = t136 * t253;
t456 = h3 * t8;
t457 = m1 * t456;
t459 = sin_slope * t333;
t464 = t23 * t7 * t129;
t472 = t261 * t112;
t481 = h3 * t194;
t483 = t459 * t300;
t485 = t232 * t279;
t488 = h3 * t202;
t491 = t235 * t321;
t496 = t456 * t245;
t497 = t * t11;
t498 = sin_theta * t5;
t505 = t5 * X3_(1) * t;
t506 = t505 * t261;
t508 = -0.4e1 * t453 * t452 + 0.2e1 * t459 * t261 * t457 * t129 + 0.2e1 * t453 * t464 - t459 * t248 * t11 * t456 * t245 - 0.3e1 * t472 * t290 * t6 + 0.3e1 * t472 * X_(1) * t8 * t6 - t136 * t300 * t464 - t483 * t481 * t129 - 0.4e1 * t236 * t485 + t483 * t488 * t129 - 0.2e1 * t491 * t275 + 0.2e1 * t491 * t280 + t498 * t497 * t496 + t248 * t11 * g * t291 + t506 * t296;
t513 = t481 * t245;
t514 = sin_theta * t242;
t515 = t514 * t300;
t518 = h2 * t232;
t520 = t5 * t248;
t521 = t520 * t300;
t525 = m1 * t194 * t245;
t531 = t505 * t253;
t534 = h3 * t232;
t535 = t534 * t307;
t536 = cos_slope * t;
t537 = cos_theta * t536;
t538 = t537 * t241;
t541 = t11 * t198 * t245;
t543 = X3_(1) * cos_slope * cos_theta;
t546 = t488 * t245;
t549 = t23 * t274;
t553 = m1 * t202 * t245;
t560 = t80 * rg;
t561 = t543 * t560;
t565 = cos_theta * cos_slope * t80;
t566 = t565 * t261;
t569 = 0.2e1 * t248 * t17 * g * t291 + 0.2e1 * t566 * t199 * t10 + 0.4e1 * t521 * t518 * t239 - 0.2e1 * t521 * t549 * t239 + t543 * t248 * t541 - 0.2e1 * t521 * t518 * t307 + t521 * t549 * t307 - 0.4e1 * t531 * t312 + 0.2e1 * t531 * t325 - t561 * t337 - 0.2e1 * t506 * t525 + t506 * t553 - 0.4e1 * t515 * t513 + 0.2e1 * t515 * t546 - t538 * t535;
t571 = m2 * t228;
t572 = t571 * t232;
t577 = h1 * h2;
t578 = h3 * t577;
t579 = t578 * t129;
t582 = h2 * t274;
t584 = m2 * cos_slope;
t586 = cos_theta * t584 * t228;
t588 = t505 * t300;
t591 = t198 * t245;
t594 = t537 * t300;
t597 = t199 * t245;
t602 = t228 * t232;
t603 = t80 * m2;
t608 = t136 * t172;
t610 = h3 * t274;
t612 = t459 * t381;
t620 = -0.2e1 * t561 * t572 + 0.3e1 * t267 * t485 + t543 * t300 * t579 - t586 * t582 * t279 + 0.2e1 * t588 * t312 - t543 * t497 * t591 + 0.2e1 * t594 * t535 - 0.2e1 * t543 * t292 * t597 - t588 * t325 + 0.2e1 * t543 * t603 * t602 + t608 * t274 * t41 - t612 * t610 * t163 + t505 * t258 * t380 + 0.2e1 * t506 * t380 + t140 * g * t99;
t621 = t274 * t99;
t627 = t7 * Tds;
t631 = F1_(1) * cos_slope * cos_theta * t292;
t634 = h1 * Tds;
t638 = t7 * t422;
t639 = t536 * t172;
t642 = t * cos_theta;
t643 = t642 * t228;
t647 = t536 * t177;
t656 = h2 * t627;
t657 = t536 * t59;
t660 = t536 * t77;
t663 = h3 * t627;
t669 = t23 * t634;
t673 = -0.4e1 * t647 * h1 * t422 + 0.2e1 * t647 * h1 * t435 - t612 * t610 * t166 - t498 * t228 * t621 - 0.4e1 * t631 * t355 * t627 + 0.2e1 * t631 * t362 * t634 - 0.4e1 * t639 * t7 * t435 - 0.2e1 * t642 * t52 * t663 - t642 * t74 * t663 - t608 * t621 + 0.8e1 * t639 * t638 - 0.2e1 * t643 * t638 + 0.8e1 * t657 * t656 - 0.2e1 * t660 * t656 - 0.4e1 * t657 * t669 + t660 * t669;
t677 = sin_slope * t235 * t300;
t686 = sin_theta * t266 * t228;
t689 = t5 * t261;
t690 = t689 * t265;
t697 = t689 * t276;
t704 = t520 * t234;
t709 = t520 * t321;
t714 = t459 * t241 * t456 * t129 + 0.2e1 * t686 * t194 * t129 - t686 * t202 * t129 + 0.2e1 * t690 * t233 - 0.4e1 * t521 * t240 - t697 * t275 + t697 * t280 - 0.4e1 * t704 * t308 + 0.8e1 * t704 * t317 + 0.2e1 * t709 * t320 - 0.4e1 * t709 * t328 - 0.2e1 * t677 * t452 + t677 * t464 - 0.2e1 * t690 * t485 + 0.2e1 * t515 * t496;
t715 = t565 * t241;
t717 = t5 * t292;
t718 = t717 * t265;
t723 = t537 * t336;
t725 = t717 * t276;
t727 = t565 * t300;
t730 = t514 * t228;
t732 = t520 * t343;
t734 = t520 * t349;
t747 = t730 * t274 * t166 + t459 * t228 * t621 + 0.2e1 * t718 * t308 + t723 * t308 - 0.4e1 * t718 * t317 - t725 * t320 + t715 * t331 - 0.2e1 * t727 * t331 + t730 * t380 - t732 * t384 - 0.2e1 * t734 * t384 + t732 * t406 + 0.2e1 * t734 * t406 - t732 * t408 - 0.2e1 * t734 * t408;
t756 = t * t261;
t773 = t * t300;
t774 = t459 * t773;
t778 = t537 * rg * t300;
t792 = t7 * t129;
t795 = g * t279;
t798 = 0.2e1 * t113 * g * t29 * t5 * t4 * t17 - 0.2e1 * t459 * t756 * t457 * t245 - t241 * t10 * t9 - 0.2e1 * t253 * t10 * t9 + 0.3e1 * t300 * t10 * t9 + 0.3e1 * t756 * t112 * t291 + t241 * t14 * t9 + 0.2e1 * t253 * t14 * t9 - 0.3e1 * t300 * t14 * t9 + t249 * t234 * t792 + 0.2e1 * t543 * t756 * t597 + 0.4e1 * t271 * t795 + 0.2e1 * t774 * t513 - 0.2e1 * t778 * t535 - 0.2e1 * t774 * t546;
t799 = h1 * t129;
t805 = t8 * t289;
t811 = t8 * t245;
t817 = t537 * t571;
t819 = t578 * t245;
t825 = h3 * t51;
t829 = t8 * t45;
t830 = F1_(1) * cos_theta;
t837 = h1 * t99;
t842 = T1_(2) * cos_slope * t292;
t847 = -0.2e1 * t249 * t321 * t799 - 0.2e1 * t282 * t795 - t497 * t10 * t805 - 0.2e1 * t313 * t10 * t805 - 0.2e1 * t314 * t811 + 0.2e1 * t725 * t328 - t817 * t582 * t307 - t543 * t773 * t819 + 0.2e1 * t817 * t582 * t239 + t333 * m1 * F1_(1) * t825 - t830 * t369 * t829 - t830 * t372 * t829 + t249 * t172 * t134 - t333 * h4 * F1_(1) * t837 - 0.4e1 * t842 * t656 + 0.2e1 * t842 * t669;
t856 = 0.1e1 / t7 / cos_slope;
t862 = h1 * h3;
t872 = t4 * H2x;
t877 = t80 * m1;
t881 = rH2x * m1;
t884 = rH2x * m2;
t885 = cos_slope * t884;
t888 = t80 * rH2x;
t889 = cos_slope * t888;
t893 = H2x * I2;
t895 = H2x * I3;
t897 = I2 * M3x;
t899 = cos_slope * t80 * h1;
t903 = h1 * rH2x * cos_slope;
t906 = I3 * M3x;
t915 = t80 * rM3x;
t916 = cos_slope * t915;
t919 = -0.2e1 * cos_slope * t877 * t8 * M3x - h1 * rM3x * cos_slope * t99 + cos_slope * t881 * t51 + t889 * t107 - 0.2e1 * t916 * t107 + t889 * t34 + t35 * t872 + 0.2e1 * t889 * t37 + 0.2e1 * t38 * t872 + t903 * t41 + 0.2e1 * t885 * t51 + t88 * t893 + t88 * t895 - t88 * t906 + t889 * t95 + 0.2e1 * t899 * t897 - 0.2e1 * t899 * t906 + t903 * t99;
t920 = X2_(2) * g;
t921 = t194 * t920;
t922 = t5 * t80;
t923 = t922 * t300;
t926 = t276 * t274;
t927 = t5 * X3_(2);
t928 = t927 * t603;
t931 = I2 * g;
t933 = t927 * t560;
t940 = F1_(2) * m2;
t941 = t5 * t940;
t943 = t333 * t940;
t946 = I2 * X_(2);
t947 = t245 * t946;
t948 = t242 * t172;
t951 = I3 * X2_(2);
t952 = t245 * t951;
t958 = t * F1_(2);
t959 = t333 * t958;
t961 = t4 * M3x;
t964 = rM3x * m1;
t970 = rM3x * m2;
t971 = cos_slope * t970;
t974 = m2 * T1_(1) * cos_slope;
t983 = -0.4e1 * t923 * t921 + 0.2e1 * t928 * t926 - 0.2e1 * t933 * t343 * t931 - 0.4e1 * t933 * t349 * t931 + t941 * t29 * t4 + 0.2e1 * t943 * t356 + 0.2e1 * t948 * t947 - 0.3e1 * t385 * t952 + t5 * F1_(2) * t7 * t41 + t959 * t433 - t35 * t961 - t38 * t961 - cos_slope * t964 * t51 + m1 * T1_(1) * cos_slope * t51 - t971 * t51 + t974 * t51 - 0.2e1 * t916 * t34 - 0.2e1 * t916 * t37 + h1 * T1_(1) * cos_slope * t99;
t985 = t4 * X2_(2);
t987 = t235 * t300;
t990 = t4 * X_(2);
t994 = t232 * t985;
t997 = X2_(2) * Tds;
t998 = t226 * t997;
t1001 = t232 * t990;
t1004 = t274 * t990;
t1008 = X_(2) * Tds;
t1009 = t226 * t1008;
t1012 = t232 * t997;
t1015 = t232 * t1008;
t1018 = t274 * t997;
t1021 = t274 * t1008;
t1024 = X_(2) * g;
t1025 = t194 * t1024;
t1028 = t198 * t920;
t1030 = t198 * t1024;
t1033 = t202 * t920;
t1036 = t202 * t1024;
t1039 = t274 * t946;
t1040 = t922 * t258;
t1043 = -0.3e1 * t987 * t226 * t985 + 0.3e1 * t987 * t226 * t990 + 0.3e1 * t267 * t1001 - t277 * t1004 + 0.10e2 * t301 * t1009 + 0.14e2 * t309 * t1012 - 0.16e2 * t309 * t1015 - 0.10e2 * t322 * t1018 + 0.8e1 * t322 * t1021 + 0.8e1 * t923 * t1025 + t334 * t1028 - 0.2e1 * t334 * t1030 + 0.2e1 * t923 * t1033 - 0.4e1 * t923 * t1036 + 0.2e1 * t1040 * t1039 + 0.4e1 * t236 * t994 + 0.3e1 * t243 * t998 - 0.9e1 * t301 * t998;
t1044 = t922 * t261;
t1047 = t129 * t951;
t1049 = I3 * X_(2);
t1050 = t129 * t1049;
t1056 = t274 * t951;
t1059 = t274 * t1049;
t1069 = t245 * t1049;
t1086 = cos_theta * t881 * t183 + 0.4e1 * t1044 * t1039 - 0.2e1 * t1040 * t1056 + 0.2e1 * t1040 * t1059 - 0.4e1 * t1044 * t1056 + 0.4e1 * t1044 * t1059 - t344 * t1047 - 0.2e1 * t350 * t1047 + t344 * t1050 + 0.2e1 * t350 * t1050 + 0.3e1 * t385 * t1069 + 0.6e1 * t389 * t1069 - 0.2e1 * t948 * t1069 + 0.2e1 * t885 * t153 + t385 * t947 + 0.2e1 * t389 * t947 - 0.6e1 * t389 * t952 + 0.2e1 * t971 * t69 + 0.2e1 * t948 * t952;
t1089 = g * t985;
t1090 = t235 * t286;
t1092 = g * t990;
t1094 = t235 * t246;
t1101 = t274 * t985;
t1106 = Tds * d;
t1109 = t5 * t * pw;
t1126 = t8 * t920;
t1127 = t922 * t241;
t1139 = t922 * t253;
t1142 = -t1090 * t1089 + t1090 * t1092 - 0.2e1 * t1094 * t1089 + 0.2e1 * t1094 * t1092 - 0.4e1 * t236 * t1001 - 0.2e1 * t491 * t1101 + 0.2e1 * t491 * t1004 - 0.4e1 * t1109 * t234 * t232 * t1106 + 0.8e1 * t1109 * t321 * t274 * t1106 - 0.3e1 * t243 * t1009 + 0.6e1 * t254 * t998 + 0.2e1 * t927 * t248 * t247 - 0.8e1 * t254 * t1009 - 0.2e1 * t1127 * t1126 - 0.6e1 * t1044 * t34 * t920 - 0.2e1 * t933 * t300 * t226 + 0.8e1 * t1044 * t34 * t1024 - 0.4e1 * t1139 * t1126;
t1157 = t266 * t34;
t1164 = g * t997;
t1167 = t927 * t292;
t1169 = t927 * t313;
t1174 = t265 * t232;
t1177 = X3_(2) * t80;
t1183 = 0.8e1 * t1139 * t921 + 0.8e1 * t933 * t234 * t232 - 0.16e2 * t1139 * t1025 - 0.4e1 * t1139 * t1033 - 0.4e1 * t933 * t321 * t274 + 0.8e1 * t1139 * t1036 + 0.3e1 * t1157 * t1089 - 0.3e1 * t267 * t994 + t277 * t1101 - t26 * t1089 - 0.3e1 * t287 * t1164 - t1167 * t296 + 0.2e1 * t1169 * t312 + 0.2e1 * t1169 * t325 - 0.4e1 * t928 * t1174 + t333 * t1177 * t337 - t943 * t363 - t959 * t365 + t959 * t370;
t1192 = t4 * t1049;
t1196 = g * t1049;
t1197 = t922 * t343;
t1200 = t922 * t349;
t1203 = t7 * t872;
t1210 = Tds * H2x;
t1211 = t8 * t1210;
t1222 = Tds * M3x;
t1223 = t8 * t1222;
t1231 = 0.2e1 * t178 * h1 * t872 - t178 * h1 * t961 - 0.2e1 * t1167 * t118 * t163 - 0.4e1 * t639 * t7 * t1222 + 0.2e1 * t173 * t7 * t961 - t927 * t381 * t380 - 0.2e1 * t1167 * t380 + t378 * t1192 - 0.2e1 * t398 * t1192 - 0.2e1 * t1197 * t1196 - 0.4e1 * t1200 * t1196 - 0.4e1 * t173 * t1203 + t417 * t1203 - 0.2e1 * t424 * t1211 - 0.4e1 * t427 * t1211 + 0.3e1 * t424 * t1223 + 0.2e1 * t427 * t1223 - t959 * t431;
t1236 = rH2x * t * cos_slope;
t1240 = rM3x * t * cos_slope;
t1276 = -0.2e1 * t208 * Tds * t893 - 0.2e1 * t208 * Tds * t895 - t208 * Tds * t897 + 0.3e1 * t208 * Tds * t906 + cos_theta * t888 * t199 - cos_theta * t915 * t199 - 0.2e1 * t1236 * t156 - 0.4e1 * t1236 * t160 - 0.2e1 * t1236 * t164 - 0.2e1 * t1236 * t167 + 0.3e1 * t1240 * t156 + 0.3e1 * t1240 * t160 + 0.3e1 * t1240 * t167 - t971 * t153 - 0.4e1 * t889 * t195 + 0.4e1 * t916 * t195 + 0.2e1 * t889 * t203 - 0.2e1 * t916 * t203 - 0.4e1 * t885 * t69;
t1280 = d * t4;
t1281 = t232 * t1280;
t1286 = t5 * pw;
t1308 = t5 * X3_(2) * t;
t1309 = t1308 * t261;
t1315 = t1308 * t253;
t1326 = t8 * t1024;
t1329 = t17 * t226;
t1334 = t5 * pw * m2 * t265 * t1281 + 0.2e1 * t1286 * t234 * t1281 - 0.4e1 * t1286 * t321 * t274 * t1280 + 0.2e1 * t1286 * t25 * g * t1280 - 0.2e1 * t690 * t1001 + t697 * t1004 - 0.4e1 * t242 * pw * t17 * t24 * g * t1106 + t1309 * t296 - 0.10e2 * t521 * t1009 - 0.12e2 * t704 * t1012 - 0.4e1 * t1315 * t312 + 0.16e2 * t704 * t1015 + 0.6e1 * t709 * t1018 + 0.2e1 * t1315 * t325 - 0.8e1 * t709 * t1021 + 0.2e1 * t1127 * t1326 - 0.4e1 * t933 * t1329 + 0.8e1 * t1139 * t1326;
t1336 = t5 * t560 * t300;
t1339 = t5 * t1177;
t1340 = t1339 * t261;
t1347 = X3_(2) * cos_slope * cos_theta;
t1348 = t1347 * t560;
t1362 = g * t1008;
t1371 = t1308 * t300;
t1379 = -t1347 * t497 * t591 + 0.8e1 * t718 * t1012 - t723 * t1012 - 0.10e2 * t718 * t1015 - 0.8e1 * t1336 * t1025 - t715 * t1028 + 0.2e1 * t715 * t1030 - 0.2e1 * t1336 * t1033 + 0.4e1 * t1336 * t1036 - 0.5e1 * t271 * t1089 + 0.4e1 * t282 * t1089 - 0.3e1 * t1157 * t1092 - 0.6e1 * t304 * t1164 + 0.4e1 * t1340 * t1174 + 0.4e1 * t1336 * t921 - t1348 * t337 + 0.3e1 * t287 * t1362 + 0.8e1 * t304 * t1362 + 0.2e1 * t1371 * t312;
t1394 = t922 * t234;
t1406 = t922 * t321;
t1412 = d * g;
t1414 = t1286 * t172;
t1417 = t1109 * t172;
t1429 = 0.2e1 * t723 * t1015 - 0.3e1 * t725 * t1018 - t1371 * t325 + 0.2e1 * t242 * t25 * t1164 + 0.6e1 * t923 * t1126 - 0.8e1 * t923 * t1326 - 0.8e1 * t1394 * t7 * t920 + 0.16e2 * t1394 * t7 * t1024 + 0.2e1 * t727 * t1028 + 0.2e1 * t1347 * t603 * t602 + 0.4e1 * t1406 * h1 * t920 - 0.8e1 * t1406 * h1 * t1024 + t1414 * t1412 * t41 - 0.2e1 * t1417 * t1412 * t163 + t1308 * t258 * t380 + 0.2e1 * t1309 * t380 + t1414 * t1412 * t99 - 0.2e1 * t1417 * t1412 * t166;
t1434 = h1 * t931;
t1438 = g * t946;
t1445 = t4 * t951;
t1451 = g * t951;
t1456 = t7 * t1210;
t1470 = t536 * t884;
t1473 = t536 * t970;
t1476 = t927 * t172 * t134 - t378 * t4 * t946 + 0.2e1 * t927 * t877 * t1434 - 0.2e1 * t1197 * t1438 + 0.4e1 * t928 * t1434 - 0.4e1 * t1200 * t1438 + t394 * t1445 - t394 * t1192 + 0.2e1 * t398 * t1445 - t378 * t1445 + 0.2e1 * t1197 * t1451 + 0.4e1 * t1200 * t1451 + 0.8e1 * t639 * t1456 - 0.2e1 * t643 * t1456 - 0.4e1 * t647 * h1 * t1210 - t333 * h4 * F1_(2) * t837 + 0.2e1 * t647 * h1 * t1222 + 0.8e1 * t1470 * t656 - 0.6e1 * t1473 * t656;
t1493 = t534 * t997;
t1516 = t534 * t1008;
t1524 = 0.2e1 * t690 * t994 - t697 * t1101 - 0.2e1 * t537 * pw * t300 * t578 * g * t1106 + 0.9e1 * t521 * t998 - 0.6e1 * t521 * t518 * t997 + t538 * t1493 + 0.3e1 * t521 * t549 * t997 - 0.2e1 * t566 * t199 * t920 - 0.2e1 * t1340 * t926 + t927 * t234 * t792 + 0.4e1 * t271 * t1092 - 0.2e1 * t927 * t321 * t799 - 0.2e1 * t282 * t1092 - t586 * t582 * t990 - 0.2e1 * t1169 * t811 + 0.4e1 * t594 * t1516 + 0.4e1 * t725 * t1021 - 0.2e1 * t1169 * t24 * t245;
t1528 = t80 * t17;
t1529 = t927 * t1528;
t1548 = t333 * m1 * F1_(2);
t1550 = h4 * t51;
t1555 = t5 * F1_(2) * t292;
t1570 = 0.4e1 * t1555 * h2 * t155 + 0.2e1 * t928 * m1 * t226 - 0.2e1 * t1555 * t23 * t627 - 0.2e1 * t642 * t881 * t663 + t642 * t964 * t663 - 0.4e1 * t727 * t1030 - 0.3e1 * t732 * t1069 - 0.6e1 * t734 * t1069 - 0.4e1 * t1470 * t669 + 0.3e1 * t1473 * t669 - 0.8e1 * t1529 * t518 + 0.4e1 * t1529 * t549 - t1548 * t1550 + t1548 * t825 - t943 * t1550 - t732 * t947 + 0.3e1 * t732 * t952 - 0.2e1 * t734 * t947 + 0.6e1 * t734 * t952;
t1606 = t5 * t286;
t1609 = t5 * t246;
t1616 = pw * cos_slope * cos_theta * t571 * t582 * t1280 - 0.2e1 * t1109 * t300 * t518 * t1106 - 0.2e1 * t1309 * t525 + 0.8e1 * t521 * t518 * t1008 + t1347 * t248 * t541 - 0.2e1 * t538 * t1516 + 0.2e1 * t778 * t1493 + 0.2e1 * t1347 * t756 * t597 - 0.4e1 * t778 * t1516 + t1309 * t553 - 0.4e1 * t521 * t549 * t1008 - 0.2e1 * t1348 * t572 + 0.4e1 * t566 * t199 * t1024 + t1606 * t1089 - t1606 * t1092 + 0.2e1 * t1609 * t1089 - 0.2e1 * t1609 * t1092 + t1347 * t300 * t579;
t1629 = t5 * t332;
t1634 = t5 * t1528;
t1646 = t5 * t958;
t1656 = t * T1_(1) * cos_slope;
t1660 = t5 * X3_(2) * t17 * t130 - 0.2e1 * t594 * t1493 - 0.2e1 * t1347 * t292 * t597 + t817 * t582 * t997 - t1347 * t773 * t819 + 0.2e1 * t1629 * t1126 - 0.2e1 * t1629 * t1326 + 0.4e1 * t1634 * t1126 + 0.4e1 * t1339 * t1329 - 0.8e1 * t1634 * t1326 - 0.2e1 * t941 * t142 + t941 * t147 - 0.2e1 * t1646 * m2 * t29 * Tds - 0.2e1 * t1646 * t7 * t163 - 0.2e1 * t974 * t69 + t974 * t153 - t1656 * t156 + t1656 * t164 - t1656 * t167;
t1693 = -0.2e1 * I2 * t * cos_slope - 0.2e1 * I3 * t * cos_slope + 0.2e1 * t584 * t23 * Tds + m1 * cos_slope * t627 - 0.2e1 * cos_theta * t381 * t862 - 0.2e1 * t536 * t135 - 0.4e1 * t536 * t139 + cos_slope * t163 + cos_slope * t166 - 0.4e1 * t173 * t634 + t417 * t634 + 0.8e1 * t427 * t577 + 0.2e1 * t584 * t627 - 0.4e1 * t647;
t1696 = 0.1e1 / Tds;
t1700 = Tds * m1;
t1702 = m2 * Tds;
f2_(1) = 0.1e1 / (m1 * cos_theta * t862 + I2 * cos_slope + I3 * cos_slope + cos_slope * t135 + 0.2e1 * cos_slope * t139 - 0.4e1 * t584 * t577 + 0.2e1 * t178) * t856 / t4 * (t65 + t109 + t169 + t223 + t299 + t360 + t405 + t447 + t508 + t569 + t620 + t673 + t714 + t747 + t798 + t847);
f2_(2) = t1696 * t856 / t1693 * (t919 + t983 + t1043 + t1086 + t1142 + t1183 + t1231 + t1276 + t1334 + t1379 + t1429 + t1476 + t1524 + t1570 + t1616 + t1660);
f2_(3) = t1696 * (rg * t1700 + 0.2e1 * rg * t1702 - t * t258 - t1700 - t1702 + 0.2e1 * t292 + t381 - 0.2e1 * t756) * g * cos_slope;

t4 = Tds ^ 2;
t5 = t4 * H2y;
t6 = h1 ^ 2;
t7 = t6 * h1;
t8 = m1 * t7;
t9 = cos_slope * t8;
t11 = m2 * t7;
t12 = cos_slope * t11;
t15 = cos_slope * t4;
t19 = t7 * t4;
t20 = rH2y * m1;
t23 = rH2y * m2;
t24 = cos_slope * t23;
t29 = t ^ 2;
t30 = t29 * rH2y;
t31 = cos_slope * t30;
t35 = H2y * I2;
t36 = h1 * t4;
t37 = cos_slope * t36;
t39 = I2 * h1;
t41 = I3 * M3y;
t43 = t4 * I3;
t45 = h1 * rH2y * cos_slope;
t50 = I3 * h1;
t52 = -m2 * M3y * t7 * t15 - h1 * rM3y * cos_slope * t43 - rM3y * t11 * t15 + cos_slope * t20 * t19 + 0.2e1 * t31 * t11 + 0.2e1 * t12 * t5 + 0.2e1 * t24 * t19 + t31 * t39 + t31 * t50 + t31 * t8 + t37 * t35 - t37 * t41 + t45 * t43 + t9 * t5;
t53 = X2_(1) * Tds;
t54 = t6 * g;
t55 = h2 * t54;
t57 = m1 * m2;
t58 = rg * t;
t59 = cos_slope ^ 2;
t60 = t59 * t58;
t61 = t60 * t57;
t64 = X_(1) * Tds;
t68 = h3 * t54;
t69 = t68 * t53;
t70 = m1 ^ 2;
t71 = rg * t70;
t72 = cos_slope * t;
t73 = cos_theta * t72;
t74 = t73 * t71;
t76 = h1 * g;
t77 = h2 ^ 2;
t78 = t77 * t76;
t81 = g * Tds;
t82 = t77 * h1;
t84 = m1 * t82 * t81;
t85 = m2 * rg;
t87 = t59 * X3_(1) * t;
t88 = t87 * t85;
t93 = g * X2_(1);
t94 = h3 * t6;
t95 = m1 * t94;
t98 = cos_theta * cos_slope * t29;
t99 = t98 * t85;
t102 = h3 * m1;
t103 = m2 * t102;
t104 = t103 * t54;
t105 = t29 * rg;
t107 = X3_(1) * cos_slope * cos_theta;
t108 = t107 * t105;
t111 = t73 * t57;
t114 = t4 * m2;
t115 = t6 ^ 2;
t116 = t115 * t59;
t124 = H2y * I3;
t126 = t4 * I2;
t131 = -h1 * T1_(2) * cos_slope * t43 - t59 * F1_(1) * t6 * t43 - T1_(2) * t11 * t15 - F1_(1) * t116 * t114 - 0.2e1 * t61 * t55 * t53 + t61 * t78 * t53 + 0.4e1 * t61 * t55 * t64 - 0.2e1 * t61 * t78 * t64 + 0.2e1 * t99 * t95 * t93 - 0.2e1 * t108 * t104 + 0.2e1 * t111 * t69 + t37 * t124 + t45 * t126 - t74 * t69 + t88 * t84;
t133 = t4 * X_(1);
t134 = t54 * t133;
t135 = h2 * m1;
t136 = t59 * t85;
t137 = t136 * t135;
t140 = t76 * t133;
t141 = m1 * t77;
t142 = t136 * t141;
t144 = t59 * Tds;
t145 = X2_(1) * t7;
t146 = t145 * t144;
t147 = g * m1;
t148 = t * t85;
t151 = t8 * t81;
t154 = t7 * g;
t155 = t154 * t64;
t158 = h2 * t6;
t159 = t158 * t81;
t160 = m2 ^ 2;
t161 = rg * t160;
t162 = t87 * t161;
t165 = t54 * t64;
t166 = t160 * h2;
t167 = t60 * t166;
t170 = t76 * t53;
t171 = t160 * t77;
t172 = t60 * t171;
t175 = t82 * t81;
t178 = t76 * t64;
t181 = t94 * t93;
t182 = t98 * t71;
t184 = t70 * h3;
t185 = t184 * t54;
t187 = h2 * t76;
t189 = m2 * cos_slope;
t191 = cos_theta * t189 * t102;
t193 = t54 * t53;
t194 = m2 * t;
t195 = t59 * t194;
t196 = t195 * t135;
t199 = -t191 * t187 * t133 + t148 * t147 * t146 - t108 * t185 - 0.2e1 * t137 * t134 + t142 * t140 + 0.3e1 * t88 * t151 - 0.4e1 * t61 * t155 - 0.4e1 * t162 * t159 + 0.2e1 * t162 * t175 + 0.8e1 * t167 * t165 + 0.2e1 * t172 * t170 - 0.4e1 * t172 * t178 + t182 * t181 + 0.2e1 * t196 * t193;
t200 = t87 * t57;
t205 = t73 * t184;
t207 = t94 * t81;
t208 = t * t70;
t211 = t195 * t141;
t216 = t98 * t57;
t219 = t102 * t54;
t220 = t29 * m2;
t224 = Tds * I2;
t225 = t76 * t224;
t226 = m1 * rg;
t229 = X_(1) * I2;
t230 = t81 * t229;
t231 = m1 * h1;
t232 = t60 * t231;
t236 = m2 * h1;
t237 = t60 * t236;
t240 = t6 * Tds;
t241 = h2 * h4;
t245 = F1_(1) * cos_slope * cos_theta * t194;
t248 = h1 * Tds;
t249 = h4 * t77;
t253 = -t107 * t208 * t207 + 0.2e1 * t107 * t220 * t219 + t87 * t226 * t225 - 0.4e1 * t245 * t241 * t240 + 0.2e1 * t245 * t249 * t248 + 0.2e1 * t200 * t159 - 0.4e1 * t196 * t165 - t211 * t170 - t200 * t175 + 0.2e1 * t211 * t178 - 0.2e1 * t216 * t181 + t205 * t193 + 0.2e1 * t88 * t225 - t232 * t230 - 0.2e1 * t237 * t230;
t256 = g * t4;
t258 = h2 * t7 * t256;
t259 = t59 * rg;
t261 = sin_slope * t259 * t57;
t265 = t77 * t6 * t256;
t267 = t158 * t256;
t268 = t59 * m2;
t270 = sin_theta * t268 * t102;
t273 = t4 * X2_(1);
t274 = t54 * t273;
t279 = t76 * t273;
t281 = h3 * t7;
t282 = t281 * t81;
t283 = t59 * t;
t284 = sin_theta * t283;
t285 = t284 * t57;
t290 = t59 * t4;
t291 = t7 * t290;
t295 = g * X_(1);
t299 = g * t273;
t300 = t77 * h2;
t301 = t160 * t300;
t302 = t59 * t301;
t304 = t300 * t256;
t308 = t7 * t81;
t309 = t59 * X3_(1);
t312 = g * t126;
t313 = m2 * t6;
t314 = sin_slope * t59;
t315 = t314 * t313;
t317 = t59 * X3_(1) * t160 * t304 - 0.2e1 * t160 * t295 * t291 + 0.2e1 * t160 * t93 * t291 - t309 * t208 * t308 - t270 * t82 * t256 + 0.2e1 * t137 * t274 - t142 * t279 - 0.4e1 * t167 * t193 + 0.2e1 * t261 * t258 - t261 * t265 + 0.2e1 * t270 * t267 + 0.2e1 * t285 * t282 - t302 * t299 - t315 * t312;
t318 = t284 * t102;
t320 = g * t43;
t321 = m1 * t6;
t324 = t76 * t43;
t325 = cos_slope * cos_theta;
t326 = sin_slope * t325;
t329 = Tds * I3;
t332 = I3 * X2_(1);
t333 = t81 * t332;
t335 = I3 * X_(1);
t336 = t81 * t335;
t342 = h2 * t19;
t343 = F1_(1) * m2;
t344 = t59 * t343;
t348 = h4 * m2;
t352 = t6 * t5;
t353 = m2 * h2;
t354 = cos_slope * t353;
t357 = cos_theta * t102;
t360 = m2 * t77;
t361 = cos_slope * t360;
t364 = Tds * H2y;
t365 = t7 * t364;
t366 = m1 * t;
t367 = cos_slope * t366;
t370 = cos_slope * t194;
t373 = -F1_(1) * cos_theta * t348 * t7 * t15 + 0.2e1 * t361 * h1 * t5 + t326 * t102 * t324 + t314 * t321 * t320 + t318 * t76 * t329 + t318 * t225 + t232 * t333 - t336 * t232 + 0.2e1 * t237 * t333 - 0.2e1 * t237 * t336 + 0.2e1 * t344 * t342 - 0.4e1 * t354 * t352 + t357 * t352 - 0.2e1 * t367 * t365 - 0.4e1 * t370 * t365;
t375 = t4 * M3y;
t381 = Tds * M3y;
t382 = t7 * t381;
t386 = t6 * t4;
t387 = h2 * t386;
t390 = rM3y * m2;
t391 = cos_slope * t390;
t394 = h3 * t386;
t397 = t77 * t36;
t401 = t7 * Tds;
t402 = m1 * t401;
t404 = rH2y * t * cos_slope;
t408 = t * T1_(2) * cos_slope;
t410 = m2 * t401;
t419 = t * t390 * t7 * cos_slope * Tds - t361 * h1 * t375 + cos_theta * t20 * t394 + 0.2e1 * t354 * t6 * t375 - 0.4e1 * t24 * t387 + 0.2e1 * t24 * t397 + t367 * t382 + 0.2e1 * t370 * t382 + 0.2e1 * t391 * t387 - t391 * t397 - 0.2e1 * t404 * t402 + t408 * t402 - 0.4e1 * t404 * t410 + 0.2e1 * t408 * t410;
t420 = h2 * t240;
t422 = T1_(2) * cos_slope * t194;
t425 = t77 * t248;
t428 = m2 * t158;
t436 = m2 * t82;
t441 = h1 * t * cos_slope;
t450 = h1 * t224;
t456 = h1 * t329;
t463 = t441 * I2 * M3y * Tds + rM3y * t * cos_slope * t456 + cos_theta * t29 * rM3y * t95 - 0.2e1 * t441 * Tds * t124 - 0.2e1 * t441 * Tds * t35 + t441 * Tds * t41 + cos_theta * t30 * t95 - 0.4e1 * t31 * t428 + 0.2e1 * t31 * t436 - 0.2e1 * t404 * t450 - 0.2e1 * t404 * t456 + t408 * t450 + t408 * t456 - 0.4e1 * t422 * t420 + 0.2e1 * t422 * t425;
t467 = t160 * t7;
t468 = t467 * t81;
t469 = t309 * t58;
t472 = t309 * t194;
t475 = t * t160;
t476 = t309 * t475;
t484 = t77 * t386;
t486 = t241 * t386;
t487 = t325 * t343;
t490 = t249 * t36;
t492 = t102 * t401;
t494 = t325 * t * F1_(1);
t498 = h1 * h4;
t499 = t498 * t224;
t501 = t498 * t329;
t504 = m2 * T1_(2) * cos_slope;
t508 = t325 * X3_(1) * t29 * t185 - 0.3e1 * t472 * t151 + 0.4e1 * t476 * t159 - 0.2e1 * t476 * t175 - 0.2e1 * t472 * t225 - t344 * t484 + 0.2e1 * t504 * t387 - t504 * t397 + 0.2e1 * t469 * t468 + 0.2e1 * t487 * t486 - t487 * t490 - t494 * t492 + t494 * t499 + t494 * t501;
t510 = rg * sin_slope;
t515 = g * h2;
t523 = t268 * t141;
t525 = t283 * t57;
t528 = t283 * t166;
t533 = t283 * t171;
t538 = t29 * t70;
t539 = t325 * t538;
t541 = t256 * t332;
t542 = t259 * t231;
t544 = t259 * t236;
t548 = h4 * m1 * t401;
t555 = -t510 * t147 * t116 * t114 - m1 * sin_slope * t515 * t7 * t59 * t114 - m2 * sin_theta * t102 * t154 * t290 - t523 * t140 + 0.4e1 * t525 * t155 + 0.4e1 * t528 * t193 - 0.8e1 * t528 * t165 - 0.2e1 * t533 * t170 + 0.4e1 * t533 * t178 - t539 * t181 - t542 * t541 - 0.2e1 * t544 * t541 + t494 * t548 + 0.2e1 * t494 * t348 * t401 - t309 * t366 * t225;
t563 = t85 * t147;
t568 = t259 * t166;
t573 = t259 * t171;
t578 = t70 * t7;
t579 = t578 * t81;
t581 = t283 * t71;
t587 = t283 * t161;
t590 = h3 * t158;
t591 = t590 * t81;
t592 = t * t57;
t593 = t326 * t592;
t596 = h3 * t82;
t597 = t596 * t81;
t600 = t268 * t135;
t603 = -0.2e1 * t326 * t148 * m1 * t281 * t81 + 0.2e1 * t58 * t160 * g * t146 + t563 * X_(1) * t7 * t290 - t563 * t145 * t290 - 0.4e1 * t568 * t134 + 0.2e1 * t573 * t140 - t581 * t155 - 0.4e1 * t587 * t155 + 0.4e1 * t568 * t274 - 0.2e1 * t600 * t274 - 0.2e1 * t573 * t279 + t469 * t579 + 0.2e1 * t593 * t591 - 0.2e1 * t593 * t597;
t611 = t73 * t103;
t613 = h1 * h2;
t614 = h3 * t613;
t615 = t614 * t81;
t621 = t256 * t335;
t625 = t283 * t231;
t627 = t283 * t236;
t636 = -t107 * t592 * t615 - t194 * t147 * t146 - t611 * t187 * t53 + 0.2e1 * t611 * t187 * t64 + t309 * t57 * t267 + t600 * t134 + t625 * t230 + 0.2e1 * t627 * t230 + t523 * t279 - t625 * t333 - 0.2e1 * t627 * t333 + t625 * t336 + 0.2e1 * t627 * t336 + t542 * t621 + 0.2e1 * t544 * t621;
t642 = t73 * rg * t57;
t645 = t95 * t81;
t651 = t59 * t160;
t652 = t651 * t158;
t655 = t651 * t82;
t658 = g * t64;
t659 = t283 * t578;
t661 = t283 * t467;
t664 = h3 * t76;
t666 = t326 * t366;
t672 = t268 * t515;
t674 = t4 * t332;
t676 = t59 * m1 * t76;
t678 = t4 * t335;
t680 = 0.2e1 * t107 * t148 * t645 - t666 * t664 * t224 - t672 * t4 * t229 - t666 * t664 * t329 - 0.4e1 * t285 * t591 + 0.2e1 * t285 * t597 - 0.5e1 * t652 * t299 + 0.4e1 * t655 * t299 + t315 * t320 - 0.2e1 * t642 * t69 + t659 * t658 + 0.4e1 * t661 * t658 + t676 * t674 - t676 * t678;
t681 = t268 * t76;
t688 = t6 * t364;
t689 = t72 * t353;
t692 = t * cos_theta;
t693 = t692 * t102;
t697 = t72 * t360;
t706 = t72 * t23;
t709 = t72 * t390;
t712 = h3 * t240;
t722 = -t692 * m1 * rM3y * t712 - 0.4e1 * t697 * h1 * t364 + 0.2e1 * t697 * h1 * t381 - 0.2e1 * t692 * t20 * t712 - 0.4e1 * t689 * t6 * t381 + 0.8e1 * t706 * t420 - 0.2e1 * t709 * t420 - 0.4e1 * t706 * t425 + t709 * t425 - t672 * t674 + t672 * t678 + 0.2e1 * t681 * t674 - 0.2e1 * t681 * t678 + 0.8e1 * t689 * t688 - 0.2e1 * t693 * t688;
t730 = t314 * t161;
t748 = t326 * t57;
t752 = sin_theta * t59;
t756 = m1 * t158 * t81;
t760 = t70 * t94 * t81;
t763 = t54 * t43;
t769 = -0.2e1 * t510 * g * t115 * t59 * t4 * t160 + 0.4e1 * t730 * t258 - 0.2e1 * t730 * t265 - t326 * t58 * t70 * t281 * t81 - 0.2e1 * t161 * t93 * t291 + 0.2e1 * t161 * t295 * t291 + t314 * t57 * t265 - t748 * t590 * t256 + t748 * t596 * t256 + t752 * t208 * t282 - 0.2e1 * t88 * t756 + t107 * t58 * t760 - t314 * t226 * t763 - 0.2e1 * t314 * t85 * t763;
t774 = t6 * t256;
t777 = g * t133;
t780 = h1 * t256;
t786 = t614 * t256;
t799 = t314 * t353;
t806 = h1 * t43;
t810 = t57 * t93 * t291 - t57 * t295 * t291 + t309 * t166 * t774 + 0.4e1 * t652 * t777 - 0.2e1 * t309 * t171 * t780 - 0.2e1 * t655 * t777 + t107 * t57 * t786 - 0.2e1 * t475 * t93 * t7 * t144 - 0.2e1 * t476 * t308 - 0.2e1 * t107 * t194 * t645 + t799 * t76 * t126 - t799 * t324 - t752 * t102 * t324 + t309 * t353 * t312 - t325 * h4 * F1_(1) * t806;
t819 = 0.1e1 / t6 / cos_slope;
t825 = h1 * h3;
t835 = t4 * H2x;
t843 = t29 * m1;
t847 = rH2x * m1;
t850 = rH2x * m2;
t851 = cos_slope * t850;
t854 = t29 * rH2x;
t855 = cos_slope * t854;
t859 = H2x * I2;
t861 = H2x * I3;
t863 = I2 * M3x;
t865 = cos_slope * t29 * h1;
t869 = h1 * rH2x * cos_slope;
t872 = I3 * M3x;
t880 = 0.2e1 * cos_slope * t843 * t7 * M3x - h1 * rM3x * cos_slope * t43 - t59 * F1_(2) * t6 * t43 + cos_slope * t847 * t19 + 0.2e1 * t855 * t11 + 0.2e1 * t12 * t835 + t869 * t126 + 0.2e1 * t851 * t19 + t37 * t859 + t37 * t861 - t37 * t872 + t855 * t39 + t869 * t43 + t855 * t8 + t9 * t835 + 0.2e1 * t865 * t863 - 0.2e1 * t865 * t872;
t882 = t29 * rM3x;
t883 = cos_slope * t882;
t890 = F1_(2) * m2;
t891 = t59 * t890;
t894 = m2 * T1_(1) * cos_slope;
t896 = t4 * M3x;
t898 = rM3x * m2;
t899 = cos_slope * t898;
t903 = Tds * d;
t910 = d * g;
t913 = t59 * t * pw;
t914 = t913 * t353;
t920 = d * t4;
t921 = t54 * t920;
t934 = X_(2) * g;
t935 = t94 * t934;
t938 = t82 * t934;
t940 = t59 * t105 * t57;
t943 = X2_(2) * Tds;
t944 = t54 * t943;
t948 = t855 * t50 - 0.2e1 * t883 * t50 + h1 * T1_(1) * cos_slope * t43 - t891 * t115 * t4 + t894 * t19 - t12 * t896 - t899 * t19 - 0.2e1 * t883 * t11 - 0.2e1 * t73 * pw * t57 * t614 * g * t903 - 0.2e1 * t914 * t910 * t224 - 0.2e1 * t914 * t910 * t329 + t59 * pw * m2 * t135 * t921 - 0.4e1 * t913 * t166 * t54 * t903 + 0.8e1 * t913 * t171 * t76 * t903 + 0.2e1 * t182 * t935 + 0.4e1 * t940 * t938 + 0.6e1 * t196 * t944 - t205 * t944;
t950 = t4 * X2_(2);
t951 = t54 * t950;
t954 = t4 * X_(2);
t955 = t54 * t954;
t958 = t76 * t950;
t960 = t76 * t954;
t962 = t154 * t943;
t966 = t59 * X3_(2) * t;
t967 = t966 * t85;
t970 = X_(2) * Tds;
t971 = t154 * t970;
t976 = t966 * t161;
t979 = t54 * t970;
t982 = t76 * t943;
t987 = t76 * t970;
t990 = X2_(2) * g;
t991 = t158 * t990;
t994 = t135 * t54;
t995 = X3_(2) * t29;
t996 = t59 * t995;
t997 = t996 * t85;
t1000 = t158 * t934;
t1003 = t94 * t990;
t1006 = X3_(2) * cos_slope * cos_theta;
t1007 = t1006 * t105;
t1009 = -0.8e1 * t940 * t1000 - t182 * t1003 - t1007 * t185 + 0.2e1 * t137 * t951 - 0.2e1 * t137 * t955 - t142 * t958 + t142 * t960 + 0.3e1 * t967 * t151 - 0.4e1 * t976 * t159 - 0.12e2 * t167 * t944 + 0.16e2 * t167 * t979 + 0.6e1 * t172 * t982 - 0.8e1 * t172 * t987 + 0.2e1 * t976 * t175 + 0.3e1 * t61 * t962 - 0.6e1 * t61 * t971 + 0.4e1 * t940 * t991 + 0.4e1 * t997 * t994;
t1010 = t82 * t990;
t1034 = I2 * X_(2);
t1035 = t81 * t1034;
t1041 = I3 * X2_(2);
t1042 = t81 * t1041;
t1045 = I3 * X_(2);
t1046 = t81 * t1045;
t1053 = -t1006 * t208 * t207 + 0.2e1 * t1006 * t220 * t219 - t966 * t57 * t175 + t966 * t226 * t225 + 0.2e1 * t216 * t1003 - 0.2e1 * t940 * t1010 - t232 * t1035 - 0.2e1 * t237 * t1035 + 0.3e1 * t232 * t1042 + 0.6e1 * t237 * t1042 - 0.3e1 * t232 * t1046 - 0.6e1 * t237 * t1046 - 0.6e1 * t196 * t979 + 0.2e1 * t205 * t979 - 0.3e1 * t211 * t982 + 0.4e1 * t211 * t987 - 0.4e1 * t216 * t935 + 0.2e1 * t967 * t225;
t1056 = g * t950;
t1057 = t259 * t467;
t1060 = g * t954;
t1075 = t68 * t943;
t1079 = t68 * t970;
t1089 = t7 * t934;
t1090 = t59 * t29;
t1094 = t7 * t990;
t1095 = t1090 * t161;
t1098 = t160 * t154;
t1099 = t59 * X3_(2);
t1100 = t1099 * t105;
t1108 = -0.2e1 * t913 * t57 * t55 * t903 + t1006 * t58 * t760 + 0.2e1 * t1090 * t71 * t1089 - 0.6e1 * t61 * t55 * t943 + 0.8e1 * t61 * t55 * t970 + 0.3e1 * t61 * t78 * t943 - 0.4e1 * t61 * t78 * t970 - 0.2e1 * t99 * t95 * t990 - 0.2e1 * t1057 * t1056 + 0.2e1 * t1057 * t1060 + t74 * t1075 - 0.2e1 * t74 * t1079 + 0.8e1 * t1095 * t1089 - 0.4e1 * t1095 * t1094 - 0.4e1 * t1100 * t1098 - 0.2e1 * t967 * t756 + t967 * t84;
t1114 = t141 * t76;
t1117 = t268 * t8;
t1133 = g * t970;
t1135 = g * t943;
t1138 = t1099 * t475;
t1150 = -0.2e1 * t1007 * t104 + 0.4e1 * t99 * t95 * t934 - 0.2e1 * t997 * t1114 + t1117 * t1056 - t1117 * t1060 - 0.5e1 * t652 * t1056 + t1099 * t166 * t774 + 0.4e1 * t655 * t1056 - 0.2e1 * t1099 * t171 * t780 + t1006 * t57 * t786 - t191 * t187 * t954 + t659 * t1133 - 0.6e1 * t661 * t1135 - 0.2e1 * t1138 * t308 + 0.8e1 * t661 * t1133 - 0.2e1 * t111 * t1075 - 0.2e1 * t1006 * t194 * t645 + 0.4e1 * t111 * t1079;
t1158 = t1090 * t57;
t1162 = t1099 * t220;
t1168 = t1090 * t166;
t1171 = t29 * t160;
t1172 = t1099 * t1171;
t1179 = t1090 * t171;
t1188 = t325 * t890;
t1192 = t59 * F1_(2) * t194;
t1202 = I2 * g;
t1203 = h1 * t1202;
t1207 = g * t1034;
t1208 = t1090 * t231;
t1211 = 0.2e1 * t283 * t301 * t1135 - 0.2e1 * t1138 * t300 * t81 + 0.2e1 * t1158 * t1094 + 0.6e1 * t1162 * m1 * t154 - 0.8e1 * t1158 * t1089 - 0.8e1 * t1168 * t6 * t990 - 0.8e1 * t1172 * t55 + 0.16e2 * t1168 * t6 * t934 + 0.4e1 * t1179 * h1 * t990 + 0.4e1 * t1172 * t78 - 0.8e1 * t1179 * h1 * t934 - t1188 * h4 * t19 - 0.4e1 * t1192 * h2 * t401 + 0.2e1 * t1192 * t77 * t240 + t1099 * t353 * t312 - t672 * t4 * t1034 + 0.2e1 * t1099 * t843 * t1203 - 0.2e1 * t1208 * t1207;
t1214 = t1090 * t236;
t1217 = t4 * t1041;
t1219 = t4 * t1045;
t1227 = g * t1041;
t1230 = g * t1045;
t1237 = Tds * H2x;
t1238 = t6 * t1237;
t1249 = Tds * M3x;
t1256 = -t325 * h4 * F1_(2) * t806 - 0.4e1 * t697 * h1 * t1237 + 0.2e1 * t697 * h1 * t1249 - 0.4e1 * t689 * t6 * t1249 + 0.4e1 * t1162 * t1203 - 0.4e1 * t1214 * t1207 + 0.2e1 * t1208 * t1227 - 0.2e1 * t1208 * t1230 + 0.4e1 * t1214 * t1227 - 0.4e1 * t1214 * t1230 - t672 * t1217 + t676 * t1217 + 0.2e1 * t681 * t1217 + t672 * t1219 - t676 * t1219 - 0.2e1 * t681 * t1219 + 0.8e1 * t689 * t1238 - 0.2e1 * t693 * t1238;
t1266 = t59 * pw;
t1270 = t1099 * t58;
t1276 = t70 * t154;
t1296 = t1099 * t194;
t1305 = pw * cos_slope * cos_theta * t103 * t187 * t920 + 0.2e1 * t1266 * t301 * g * t920 + t1270 * t579 + 0.2e1 * t1270 * t468 - 0.4e1 * t642 * t1079 - 0.2e1 * t1100 * t1276 - 0.6e1 * t1100 * t57 * t154 + 0.8e1 * t1100 * t166 * t54 - 0.4e1 * t1100 * t171 * t76 + t1099 * t57 * t267 + 0.4e1 * t652 * t1060 - 0.2e1 * t655 * t1060 - t1099 * t208 * t308 - 0.3e1 * t1296 * t151 + 0.14e2 * t528 * t944 + 0.2e1 * t1138 * t159 - 0.10e2 * t533 * t982;
t1326 = t256 * t1045;
t1330 = t76 * t1045;
t1331 = t1090 * t226;
t1334 = t1090 * t85;
t1340 = t * F1_(2);
t1341 = t325 * t1340;
t1346 = 0.2e1 * t1138 * t175 + t611 * t187 * t943 + 0.2e1 * t996 * t1276 - 0.4e1 * t1158 * t991 - 0.4e1 * t1162 * t994 + t325 * t995 * t185 + 0.2e1 * t1162 * t1114 - 0.2e1 * t1100 * t231 * t1202 - 0.4e1 * t1100 * t236 * t1202 + t542 * t1326 + 0.2e1 * t544 * t1326 + 0.2e1 * t1331 * t1330 + 0.4e1 * t1334 * t1330 + 0.2e1 * t1188 * t486 - t1188 * t490 + t1341 * t492 - t1341 * t548 - t1099 * t366 * t225;
t1356 = t283 * t353;
t1359 = t6 * t835;
t1368 = t59 * t1340;
t1380 = rH2x * t * cos_slope;
t1385 = t72 * t850;
t1388 = t625 * t1035 - 0.2e1 * t1296 * t225 + 0.2e1 * t627 * t1035 - 0.2e1 * t1296 * t515 * t224 - 0.2e1 * t1356 * t1046 - 0.4e1 * t354 * t1359 + t357 * t1359 + 0.2e1 * t361 * h1 * t835 - t1341 * t499 + 0.2e1 * t1368 * t6 * t329 + t1341 * t501 + 0.2e1 * t899 * t387 + cos_theta * t847 * t394 + 0.2e1 * t851 * t397 - t899 * t397 - 0.2e1 * t1380 * t402 - 0.4e1 * t1380 * t410 + 0.8e1 * t1385 * t420;
t1389 = t72 * t898;
t1430 = rM3x * t * cos_slope;
t1433 = t692 * m1 * rM3x * t712 - 0.2e1 * t441 * Tds * t859 - 0.2e1 * t441 * Tds * t861 - t441 * Tds * t863 + 0.3e1 * t441 * Tds * t872 - 0.2e1 * t692 * t847 * t712 + cos_theta * t854 * t95 - cos_theta * t882 * t95 - 0.2e1 * t1380 * t450 - 0.2e1 * t1380 * t456 - 0.4e1 * t1385 * t425 - 0.6e1 * t1389 * t420 + 0.3e1 * t1389 * t425 + 0.3e1 * t1430 * t456 - 0.4e1 * t855 * t428 + 0.4e1 * t883 * t428 + 0.2e1 * t855 * t436 - 0.2e1 * t883 * t436;
t1437 = t259 * t57;
t1471 = 0.8e1 * t1334 * t8 * t934 - 0.2e1 * t1334 * t8 * t990 - t1437 * t154 * t950 - 0.16e2 * t1095 * t1000 + 0.8e1 * t1095 * t938 + t523 * t958 - t523 * t960 + 0.6e1 * t525 * t971 - 0.16e2 * t528 * t979 + 0.4e1 * t568 * t951 - 0.4e1 * t568 * t955 - 0.2e1 * t573 * t958 + 0.2e1 * t573 * t960 - t581 * t971 + 0.6e1 * t587 * t962 - 0.8e1 * t587 * t971 - 0.2e1 * t600 * t951 + t600 * t955;
t1483 = t76 * t1034;
t1488 = t256 * t1041;
t1492 = t76 * t1041;
t1509 = 0.8e1 * t1158 * t1000 + t539 * t1003 + 0.2e1 * t1158 * t1010 + 0.2e1 * t1356 * t1035 + 0.2e1 * t1356 * t1042 - 0.3e1 * t625 * t1042 - 0.6e1 * t627 * t1042 + 0.3e1 * t625 * t1046 + 0.6e1 * t627 * t1046 - 0.4e1 * t1158 * t938 + 0.2e1 * t1331 * t1483 - 0.2e1 * t1331 * t1492 + 0.4e1 * t1334 * t1483 - 0.4e1 * t1334 * t1492 - t542 * t1488 - 0.2e1 * t544 * t1488 + 0.8e1 * t533 * t987 - 0.2e1 * t539 * t935;
t1540 = t1266 * t353;
t1547 = t7 * t1237;
t1557 = 0.2e1 * t1266 * t166 * t921 - 0.4e1 * t1266 * t171 * t76 * t920 + t1437 * t154 * t954 - 0.4e1 * t283 * pw * t160 * t300 * g * t903 + 0.2e1 * t642 * t1075 + 0.2e1 * t1006 * t148 * t645 + 0.8e1 * t1095 * t991 - 0.4e1 * t1095 * t1010 - 0.3e1 * t525 * t962 - t1006 * t592 * t615 + t1540 * t910 * t126 + t1540 * t910 * t43 + 0.2e1 * t891 * t342 - t891 * t484 - 0.2e1 * t367 * t1547 - 0.4e1 * t370 * t1547 + 0.2e1 * t354 * t6 * t896 - t361 * h1 * t896;
t1558 = t59 * t467;
t1570 = t59 * t1171;
t1581 = t7 * t1249;
t1591 = t * T1_(1) * cos_slope;
t1597 = 0.2e1 * t1558 * t1056 - 0.2e1 * t1558 * t1060 - t302 * t1056 + t59 * X3_(2) * t160 * t304 - 0.2e1 * t59 * t538 * t1089 + 0.4e1 * t1570 * t1094 + 0.4e1 * t996 * t1098 - 0.8e1 * t1570 * t1089 + 0.2e1 * t1368 * m2 * t115 * Tds - t367 * t1581 + 0.2e1 * t370 * t1581 - 0.4e1 * t851 * t387 - 0.2e1 * t894 * t387 + t894 * t397 + t1591 * t402 + 0.3e1 * t1430 * t410 + t1591 * t450 - t1591 * t456;
t1630 = -0.2e1 * I2 * t * cos_slope - 0.2e1 * I3 * t * cos_slope + 0.2e1 * t189 * t77 * Tds + m1 * cos_slope * t240 - 0.2e1 * cos_theta * t366 * t825 + 0.2e1 * t189 * t240 + cos_slope * t224 - 0.4e1 * t354 * t248 + t357 * t248 - 0.4e1 * t72 * t313 - 0.2e1 * t72 * t321 + cos_slope * t329 + 0.8e1 * t370 * t613 - 0.4e1 * t697;
t1633 = 0.1e1 / Tds;
f3_(1) = -0.1e1 / (m1 * cos_theta * t825 + I2 * cos_slope + I3 * cos_slope - 0.4e1 * t189 * t613 + 0.2e1 * cos_slope * t313 + cos_slope * t321 + 0.2e1 * t361) * t819 / t4 * (t52 + t131 + t199 + t253 + t317 + t373 + t419 + t463 + t508 + t555 + t603 + t636 + t680 + t722 + t769 + t810);
f3_(2) = -t1633 * t819 / t1630 * (t880 + t948 + t1009 + t1053 + t1108 + t1150 + t1211 + t1256 + t1305 + t1346 + t1388 + t1433 + t1471 + t1509 + t1557 + t1597);
f3_(3) = t1633 * (m2 * Tds + t * t226 + 0.2e1 * t148 - 0.2e1 * t194 - t366) * g * cos_slope;

F1_(1) = F1_(1);
F1_(2) = F1_(2);
F1_(3) = 0.0e0;

t4 = Tds ^ 2;
t5 = g * t4;
t6 = h1 ^ 2;
t7 = t6 * h1;
t9 = h2 * t7 * t5;
t10 = m1 * m2;
t11 = cos_slope ^ 2;
t12 = t11 * rg;
t14 = sin_slope * t12 * t10;
t16 = m2 ^ 2;
t17 = rg * t16;
t18 = sin_slope * t11;
t19 = t18 * t17;
t22 = h3 * t7;
t24 = m1 ^ 2;
t25 = rg * t24;
t26 = cos_slope * cos_theta;
t27 = sin_slope * t26;
t30 = m1 * t22;
t32 = m2 * rg;
t36 = h2 ^ 2;
t38 = t36 * t6 * t5;
t42 = g * Tds;
t45 = rg * t;
t49 = t * t32;
t53 = t11 * t4;
t54 = t7 * t53;
t59 = t7 * g;
t61 = h3 * m1;
t66 = g * X2_(1);
t69 = g * X_(1);
t72 = X2_(1) * t7;
t74 = g * m1;
t75 = t32 * t74;
t82 = -sin_theta * t24 * g * h3 * t54 - 0.2e1 * m2 * sin_theta * t61 * t59 * t53 - t27 * t45 * t24 * t22 * t42 + t27 * t25 * t22 * t5 + 0.2e1 * t27 * t32 * t30 * t5 - 0.2e1 * t27 * t49 * t30 * t42 + 0.4e1 * t75 * X_(1) * t7 * t53 - t25 * t66 * t54 + t25 * t69 * t54 - 0.4e1 * t75 * t72 * t53 + t14 * t38 - t14 * t9 + 0.2e1 * t19 * t38 - 0.2e1 * t19 * t9;
t91 = h2 * t6;
t93 = t11 * m2;
t95 = sin_theta * t93 * t61;
t98 = h3 * t91;
t100 = t27 * t10;
t103 = t4 * X2_(1);
t104 = t6 * g;
t105 = t104 * t103;
t106 = h2 * m1;
t107 = t11 * t32;
t108 = t107 * t106;
t111 = t4 * X_(1);
t112 = t104 * t111;
t115 = t16 * h2;
t116 = t12 * t115;
t121 = t36 * h1;
t124 = h3 * t121;
t127 = h1 * g;
t128 = t127 * t103;
t129 = m1 * t36;
t130 = t107 * t129;
t132 = t127 * t111;
t134 = t16 * t36;
t135 = t12 * t134;
t140 = -t18 * t10 * t38 + t100 * t124 * t5 - 0.2e1 * t100 * t98 * t5 - t95 * t121 * t5 - 0.4e1 * t17 * t66 * t54 + 0.4e1 * t17 * t69 * t54 + 0.3e1 * t95 * t91 * t5 + 0.3e1 * t108 * t105 + 0.6e1 * t116 * t105 - 0.3e1 * t108 * t112 - 0.6e1 * t116 * t112 - t130 * t128 - 0.2e1 * t135 * t128 + t130 * t132 + 0.2e1 * t135 * t132;
t142 = t22 * t42;
t143 = t * t24;
t144 = sin_theta * t11;
t147 = t11 * t;
t148 = sin_theta * t147;
t149 = t148 * t10;
t152 = t11 * Tds;
t153 = t72 * t152;
t157 = X_(1) * Tds;
t158 = t59 * t157;
t159 = t147 * t25;
t164 = t11 * t45;
t165 = t164 * t10;
t172 = t147 * t17;
t175 = t98 * t42;
t178 = t * t10;
t179 = t27 * t178;
t182 = X2_(1) * Tds;
t183 = h2 * t104;
t188 = m1 * t91 * t42;
t190 = t11 * X3_(1) * t;
t191 = t190 * t32;
t196 = t104 * t182;
t197 = t164 * t115;
t200 = 0.4e1 * t45 * t16 * g * t153 + t45 * t24 * g * t153 + t144 * t143 * t142 + 0.4e1 * t49 * t74 * t153 + 0.4e1 * t165 * t183 * t157 - 0.3e1 * t165 * t183 * t182 + 0.2e1 * t149 * t142 - 0.4e1 * t149 * t175 - t159 * t158 - 0.4e1 * t165 * t158 - 0.4e1 * t172 * t158 + 0.2e1 * t179 * t175 - t191 * t188 - 0.6e1 * t197 * t196;
t201 = t91 * t42;
t202 = t190 * t17;
t205 = t104 * t157;
t208 = h3 * t104;
t209 = t208 * t182;
t210 = cos_slope * t;
t211 = cos_theta * t210;
t212 = t211 * t25;
t214 = h3 * t6;
t216 = t24 * t214 * t42;
t218 = X3_(1) * cos_slope * cos_theta;
t222 = t211 * rg * t10;
t225 = m1 * t214;
t226 = t225 * t42;
t230 = t124 * t42;
t235 = t36 * t127;
t239 = m1 * t121 * t42;
t244 = t127 * t182;
t245 = t164 * t134;
t248 = t121 * t42;
t251 = t127 * t157;
t254 = t214 * t66;
t255 = t ^ 2;
t257 = cos_theta * cos_slope * t255;
t258 = t257 * t25;
t260 = -0.2e1 * t165 * t235 * t157 + t165 * t235 * t182 + t218 * t45 * t216 + 0.2e1 * t218 * t49 * t226 + 0.2e1 * t149 * t230 - 0.2e1 * t179 * t230 + t191 * t239 + 0.8e1 * t197 * t205 - 0.2e1 * t202 * t201 + 0.2e1 * t202 * t248 - t212 * t209 - 0.2e1 * t222 * t209 + 0.2e1 * t245 * t244 - 0.4e1 * t245 * t251 + t258 * t254;
t263 = t24 * h3;
t264 = t263 * t104;
t265 = t255 * rg;
t266 = t218 * t265;
t269 = t257 * t32;
t272 = m2 * t61;
t273 = t272 * t104;
t276 = t4 * I2;
t277 = t104 * t276;
t278 = m1 * rg;
t300 = t93 * t106;
t305 = g * t103;
t306 = t11 * t16;
t307 = t306 * t91;
t310 = 0.4e1 * t10 * t66 * t54 - 0.4e1 * t10 * t69 * t54 + 0.4e1 * t16 * t66 * t54 - 0.4e1 * t16 * t69 * t54 + t18 * t278 * t277 + 0.2e1 * t18 * t32 * t277 + 0.2e1 * t269 * t225 * t66 + t24 * t66 * t54 - t24 * t69 * t54 - 0.4e1 * t300 * t105 + 0.4e1 * t300 * t112 - t266 * t264 - 0.2e1 * t266 * t273 - 0.8e1 * t307 * t305;
t311 = g * t111;
t314 = t93 * t129;
t317 = t306 * t121;
t320 = h1 * t5;
t321 = t11 * X3_(1);
t326 = h1 * h2;
t327 = h3 * t326;
t328 = t327 * t5;
t331 = h2 * t127;
t333 = m2 * cos_slope;
t335 = cos_theta * t333 * t61;
t337 = t36 * h2;
t338 = t16 * t337;
t339 = t11 * t338;
t341 = t337 * t5;
t345 = t7 * t152;
t348 = g * t157;
t349 = t24 * t7;
t350 = t147 * t349;
t352 = m2 * t;
t356 = t147 * t10;
t359 = t * t16;
t363 = 0.8e1 * t307 * t311 + t314 * t128 - t314 * t132 + 0.5e1 * t317 * t305 - t321 * t134 * t320 - 0.4e1 * t317 * t311 + t218 * t10 * t328 - t335 * t331 * t111 - t339 * t305 + t11 * X3_(1) * t16 * t341 - t143 * t66 * t345 + t350 * t348 - 0.4e1 * t352 * t74 * t153 + 0.4e1 * t356 * t158 - 0.4e1 * t359 * t66 * t345;
t365 = t16 * t7;
t366 = t147 * t365;
t369 = t11 * t352;
t370 = t369 * t106;
t373 = t190 * t10;
t377 = t147 * t115;
t380 = t321 * t359;
t385 = t211 * t263;
t387 = t214 * t42;
t390 = t211 * t10;
t396 = t369 * t129;
t401 = t147 * t134;
t404 = -t218 * t143 * t387 - 0.2e1 * t218 * t352 * t226 + 0.3e1 * t370 * t196 + 0.6e1 * t377 * t196 + t385 * t196 + t373 * t201 + 0.2e1 * t380 * t201 - 0.4e1 * t370 * t205 - 0.8e1 * t377 * t205 + 0.2e1 * t390 * t209 - t396 * t244 - 0.2e1 * t401 * t244 - t373 * t248 + 0.2e1 * t396 * t251 + 0.4e1 * t366 * t348;
t410 = t211 * t272;
t412 = t327 * t42;
t418 = t255 * t24;
t419 = t26 * t418;
t424 = t257 * t10;
t427 = t61 * t104;
t428 = t255 * m2;
t432 = g * t276;
t433 = m1 * t6;
t436 = m2 * t6;
t441 = m2 * h2;
t442 = t18 * t441;
t444 = Tds * I2;
t445 = t127 * t444;
t446 = t148 * t61;
t448 = h3 * t127;
t450 = m1 * t;
t451 = t27 * t450;
t455 = -0.2e1 * t380 * t248 + 0.4e1 * t401 * t251 - t410 * t331 * t182 - t218 * t178 * t412 + 0.2e1 * t410 * t331 * t157 - t419 * t254 + t26 * X3_(1) * t255 * t264 - 0.2e1 * t424 * t254 + 0.2e1 * t218 * t428 * t427 - t18 * t433 * t432 - 0.2e1 * t18 * t436 * t432 + t442 * t127 * t276 + t446 * t445 - t451 * t448 * t444 + t190 * t278 * t445;
t459 = X_(1) * I2;
t460 = t42 * t459;
t461 = m1 * h1;
t462 = t164 * t461;
t466 = m2 * h1;
t467 = t164 * t466;
t470 = t4 * I3;
t471 = t127 * t470;
t477 = I3 * X2_(1);
t478 = t5 * t477;
t479 = t12 * t461;
t481 = I3 * X_(1);
t482 = t5 * t481;
t484 = t12 * t466;
t489 = Tds * I3;
t494 = t42 * t477;
t496 = t42 * t481;
t498 = t446 * t127 * t489 - t144 * t61 * t471 + t27 * t61 * t471 - t451 * t448 * t489 + 0.2e1 * t191 * t445 - t442 * t471 - t462 * t460 - 0.2e1 * t467 * t460 + t462 * t494 - t462 * t496 - t479 * t478 - 0.2e1 * t484 * t478 + t479 * t482 + 0.2e1 * t484 * t482;
t503 = t7 * t4;
t504 = h2 * t503;
t505 = F1_(1) * m2;
t506 = t11 * t505;
t508 = h3 * t503;
t512 = cos_slope * t4;
t513 = t7 * t512;
t514 = h4 * m1;
t515 = F1_(1) * cos_theta;
t518 = h4 * m2;
t522 = t6 * t4;
t523 = t36 * t522;
t525 = h2 * h4;
t526 = t525 * t522;
t527 = t26 * t505;
t530 = h1 * t4;
t531 = h4 * t36;
t532 = t531 * t530;
t534 = t7 * Tds;
t535 = t61 * t534;
t537 = t26 * t * F1_(1);
t539 = t514 * t534;
t541 = t518 * t534;
t544 = t6 * Tds;
t545 = t525 * t544;
t548 = F1_(1) * cos_slope * cos_theta * t352;
t551 = h1 * Tds;
t557 = t26 * m1 * F1_(1) * t508 + t321 * t441 * t432 - t515 * t514 * t513 - 0.2e1 * t515 * t518 * t513 + 0.2e1 * t548 * t531 * t551 + 0.2e1 * t467 * t494 - 0.2e1 * t467 * t496 - t506 * t504 + t506 * t523 + 0.3e1 * t527 * t526 - t527 * t532 - t537 * t535 + t537 * t539 + 0.2e1 * t537 * t541 - 0.4e1 * t548 * t545;
t560 = g * h2;
t561 = t93 * t560;
t565 = t147 * t461;
t570 = t147 * t466;
t573 = t4 * t477;
t575 = t11 * m1 * t127;
t577 = t4 * t481;
t579 = t93 * t127;
t590 = -0.2e1 * t321 * t352 * t445 - t321 * t450 * t445 - t561 * t4 * t459 + t565 * t460 + 0.2e1 * t570 * t460 - t565 * t494 - 0.2e1 * t570 * t494 + t565 * t496 - t561 * t573 + t561 * t577 + t575 * t573 + 0.2e1 * t579 * t573 - t575 * t577 - 0.2e1 * t579 * t577;
t593 = t4 * H2y;
t594 = m1 * t7;
t595 = cos_slope * t594;
t597 = m2 * t7;
t598 = cos_slope * t597;
t601 = t6 * t593;
t602 = cos_slope * t441;
t605 = cos_theta * t61;
t608 = m2 * t36;
t609 = cos_slope * t608;
t612 = Tds * H2y;
t613 = t7 * t612;
t614 = cos_slope * t450;
t617 = cos_slope * t352;
t620 = t6 * t612;
t621 = t210 * t441;
t624 = t * cos_theta;
t625 = t624 * t61;
t629 = t210 * t608;
t635 = h1 * h4;
t636 = t635 * t444;
t638 = h1 * t470;
t642 = t635 * t489;
t644 = -t26 * h4 * F1_(1) * t638 + t11 * F1_(1) * t6 * t276 + 0.2e1 * t609 * h1 * t593 - 0.4e1 * t629 * h1 * t612 + 0.2e1 * t570 * t496 + t537 * t636 + t537 * t642 + t595 * t593 + 0.2e1 * t598 * t593 - 0.4e1 * t602 * t601 + t605 * t601 - 0.2e1 * t614 * t613 - 0.4e1 * t617 * t613 + 0.8e1 * t621 * t620 - 0.2e1 * t625 * t620;
t647 = M3y * t7;
t653 = t4 * M3y;
t659 = Tds * M3y;
t660 = t7 * t659;
t670 = rH2y * m1;
t677 = rH2y * m2;
t678 = cos_slope * t677;
t687 = -t609 * h1 * t653 + 0.2e1 * t629 * h1 * t659 - m1 * t647 * t512 - 0.2e1 * m2 * t647 * t512 - rM3y * t594 * t512 - 0.2e1 * rM3y * t597 * t512 + cos_slope * t670 * t503 - T1_(2) * t594 * t512 - 0.2e1 * T1_(2) * t597 * t512 + 0.3e1 * t602 * t6 * t653 - 0.4e1 * t621 * t6 * t659 + 0.2e1 * t678 * t503 + t614 * t660 + 0.2e1 * t617 * t660;
t688 = h2 * t522;
t691 = rM3y * m2;
t692 = cos_slope * t691;
t696 = m2 * T1_(2) * cos_slope;
t699 = h3 * t522;
t702 = t36 * t530;
t707 = m1 * t534;
t709 = rH2y * t * cos_slope;
t713 = t7 * cos_slope * Tds;
t714 = rM3y * m1;
t718 = t * T1_(2) * cos_slope;
t720 = m2 * t534;
t728 = h2 * t544;
t729 = t210 * t677;
t732 = t210 * t691;
t735 = 0.2e1 * t * t691 * t713 + t * t714 * t713 + cos_theta * t670 * t699 - 0.4e1 * t678 * t688 + 0.2e1 * t678 * t702 + 0.3e1 * t692 * t688 + 0.3e1 * t696 * t688 - t692 * t702 - t696 * t702 - 0.2e1 * t709 * t707 + t718 * t707 - 0.4e1 * t709 * t720 + 0.2e1 * t718 * t720 + 0.8e1 * t729 * t728 - 0.3e1 * t732 * t728;
t738 = T1_(2) * cos_slope * t352;
t741 = h3 * t544;
t747 = t36 * t551;
t753 = t255 * rH2y;
t754 = cos_slope * t753;
t758 = m2 * t91;
t766 = m2 * t121;
t769 = H2y * I2;
t770 = cos_slope * t530;
t774 = h1 * t * cos_slope;
t777 = H2y * I3;
t779 = cos_theta * t255 * rM3y * t225 - 0.2e1 * t774 * Tds * t769 + cos_theta * t753 * t225 - 0.2e1 * t624 * t670 * t741 - t624 * t714 * t741 + t754 * t594 + 0.2e1 * t754 * t597 - 0.4e1 * t738 * t728 - 0.4e1 * t729 * t747 + t732 * t747 + 0.2e1 * t738 * t747 - 0.4e1 * t754 * t758 + 0.2e1 * t754 * t766 + t770 * t769 + t770 * t777;
t787 = h1 * rH2y * cos_slope;
t789 = h1 * t444;
t793 = I2 * h1;
t795 = I3 * M3y;
t806 = h1 * t489;
t813 = I3 * h1;
t815 = t774 * I2 * M3y * Tds - h1 * rM3y * cos_slope * t470 - h1 * T1_(2) * cos_slope * t470 + rM3y * t * cos_slope * t806 - 0.2e1 * t774 * Tds * t777 + t774 * Tds * t795 + t787 * t276 + t787 * t470 - 0.2e1 * t709 * t789 - 0.2e1 * t709 * t806 + t718 * t789 + t718 * t806 + t754 * t793 + t754 * t813 - t770 * t795;
t824 = 0.1e1 / t6 / cos_slope;
t830 = h1 * h3;
t840 = d * t4;
t841 = t104 * t840;
t846 = t11 * pw;
t863 = t4 * X2_(2);
t864 = g * t863;
t865 = t12 * t349;
t867 = t4 * X_(2);
t868 = g * t867;
t871 = t12 * t10;
t877 = t12 * t365;
t882 = t104 * t863;
t885 = t104 * t867;
t892 = t127 * t863;
t894 = t127 * t867;
t898 = t11 * pw * m2 * t106 * t841 + 0.2e1 * t846 * t115 * t841 - 0.4e1 * t846 * t134 * t127 * t840 + pw * cos_slope * cos_theta * t272 * t331 * t840 + 0.2e1 * t846 * t338 * g * t840 - t865 * t864 + t865 * t868 - 0.4e1 * t871 * t59 * t863 + 0.4e1 * t871 * t59 * t867 - 0.4e1 * t877 * t864 + 0.4e1 * t877 * t868 + 0.3e1 * t108 * t882 - 0.3e1 * t108 * t885 + 0.6e1 * t116 * t882 - 0.6e1 * t116 * t885 - t130 * t892 + t130 * t894 - 0.2e1 * t135 * t892;
t901 = Tds * d;
t904 = t11 * t * pw;
t928 = X2_(2) * Tds;
t929 = t59 * t928;
t932 = X_(2) * Tds;
t933 = t59 * t932;
t948 = t11 * X3_(2) * t;
t949 = t948 * t32;
t954 = t104 * t928;
t957 = t948 * t17;
t960 = t104 * t932;
t963 = 0.2e1 * t135 * t894 - 0.2e1 * t904 * t10 * t183 * t901 - 0.4e1 * t904 * t115 * t104 * t901 + 0.8e1 * t904 * t134 * t127 * t901 - 0.2e1 * t211 * pw * t10 * t327 * g * t901 - 0.4e1 * t147 * pw * t16 * t337 * g * t901 + 0.3e1 * t159 * t929 - 0.3e1 * t159 * t933 + 0.12e2 * t165 * t929 - 0.12e2 * t165 * t933 + 0.12e2 * t172 * t929 - 0.12e2 * t172 * t933 - 0.9e1 * t165 * t183 * t928 - t949 * t188 + 0.10e2 * t165 * t183 * t932 - 0.18e2 * t197 * t954 - 0.2e1 * t957 * t201 + 0.20e2 * t197 * t960;
t965 = t208 * t928;
t968 = X3_(2) * cos_slope * cos_theta;
t971 = t208 * t932;
t988 = t127 * t928;
t993 = t127 * t932;
t996 = X2_(2) * g;
t997 = t7 * t996;
t998 = t11 * t255;
t999 = t998 * t25;
t1002 = X_(2) * g;
t1003 = t7 * t1002;
t1007 = t998 * t32;
t1013 = t998 * t17;
t1018 = 0.8e1 * t1007 * t594 * t1002 - 0.8e1 * t1007 * t594 * t996 + 0.3e1 * t165 * t235 * t928 - 0.4e1 * t165 * t235 * t932 + t968 * t45 * t216 + 0.2e1 * t968 * t49 * t226 + 0.8e1 * t1013 * t1003 + 0.2e1 * t999 * t1003 - 0.8e1 * t1013 * t997 + t212 * t965 - 0.2e1 * t212 * t971 + 0.2e1 * t222 * t965 - 0.4e1 * t222 * t971 + t949 * t239 + 0.6e1 * t245 * t988 - 0.8e1 * t245 * t993 + 0.2e1 * t957 * t248 - 0.2e1 * t999 * t997;
t1019 = t91 * t996;
t1021 = t11 * t265 * t10;
t1024 = t106 * t104;
t1025 = X3_(2) * t255;
t1027 = t11 * t1025 * t32;
t1030 = t91 * t1002;
t1036 = t11 * X3_(2);
t1037 = t1036 * t265;
t1042 = t214 * t996;
t1044 = t968 * t265;
t1046 = t214 * t1002;
t1057 = t121 * t996;
t1060 = t129 * t127;
t1063 = t121 * t1002;
t1073 = 0.4e1 * t269 * t225 * t1002 + 0.4e1 * t1037 * t115 * t104 - 0.4e1 * t1037 * t134 * t127 - 0.2e1 * t269 * t225 * t996 + 0.12e2 * t1013 * t1019 - 0.16e2 * t1013 * t1030 - 0.4e1 * t1013 * t1057 + 0.8e1 * t1013 * t1063 + 0.6e1 * t1021 * t1019 - 0.8e1 * t1021 * t1030 - 0.2e1 * t1021 * t1057 + 0.4e1 * t1021 * t1063 + 0.2e1 * t1027 * t1024 - 0.2e1 * t1027 * t1060 - t258 * t1042 - t1044 * t264 - 0.2e1 * t1044 * t273 + 0.2e1 * t258 * t1046;
t1076 = t11 * t349;
t1079 = t93 * t594;
t1084 = t11 * t365;
t1110 = t968 * t10 * t328 - t1036 * t134 * t320 - t335 * t331 * t867 + t1076 * t864 - t1076 * t868 + 0.4e1 * t1079 * t864 - 0.4e1 * t1079 * t868 + 0.4e1 * t1084 * t864 - 0.4e1 * t1084 * t868 - 0.4e1 * t300 * t882 + 0.4e1 * t300 * t885 - 0.8e1 * t307 * t864 + 0.8e1 * t307 * t868 + t314 * t892 - t314 * t894 + 0.5e1 * t317 * t864 - 0.4e1 * t317 * t868 - t339 * t864;
t1114 = g * t928;
t1117 = g * t932;
t1130 = t948 * t10;
t1136 = t1036 * t359;
t1151 = t11 * X3_(2) * t16 * t341 - t968 * t143 * t387 - 0.2e1 * t968 * t352 * t226 - 0.3e1 * t350 * t1114 - 0.12e2 * t366 * t1114 + 0.3e1 * t350 * t1117 + 0.12e2 * t366 * t1117 + t1130 * t201 + 0.2e1 * t1136 * t201 - 0.12e2 * t356 * t929 + 0.12e2 * t356 * t933 + 0.11e2 * t370 * t954 - 0.12e2 * t370 * t960 + 0.22e2 * t377 * t954 - 0.24e2 * t377 * t960 - t385 * t954 + 0.2e1 * t385 * t960 - 0.2e1 * t390 * t965;
t1174 = t11 * t418;
t1179 = t998 * t10;
t1184 = t255 * t16;
t1185 = t11 * t1184;
t1192 = t1036 * t428;
t1195 = 0.2e1 * t147 * t338 * t1114 - 0.2e1 * t1136 * t337 * t42 - t968 * t178 * t412 + t410 * t331 * t928 - 0.2e1 * t1174 * t1003 - 0.8e1 * t1179 * t1003 - 0.8e1 * t1185 * t1003 - 0.6e1 * t1179 * t1019 - 0.2e1 * t1192 * t1024 - t1130 * t248 + 0.2e1 * t1174 * t997 + 0.8e1 * t1179 * t997 + 0.8e1 * t1185 * t997 + 0.4e1 * t390 * t971 - 0.3e1 * t396 * t988 + 0.4e1 * t396 * t993 - 0.12e2 * t401 * t988 + 0.12e2 * t401 * t993;
t1199 = t998 * t115;
t1202 = t1036 * t1184;
t1227 = t998 * t134;
t1235 = d * g;
t1237 = t846 * t441;
t1240 = t904 * t441;
t1245 = 0.8e1 * t1179 * t1030 - 0.12e2 * t1199 * t6 * t996 - 0.4e1 * t1202 * t183 + 0.16e2 * t1199 * t6 * t1002 + t419 * t1042 + t26 * t1025 * t264 - 0.2e1 * t419 * t1046 + 0.2e1 * t424 * t1042 + 0.2e1 * t968 * t428 * t427 - 0.4e1 * t424 * t1046 + 0.2e1 * t1179 * t1057 + 0.2e1 * t1192 * t1060 - 0.4e1 * t1179 * t1063 + 0.4e1 * t1227 * h1 * t996 + 0.4e1 * t1202 * t235 - 0.8e1 * t1227 * h1 * t1002 + t1237 * t1235 * t276 - 0.2e1 * t1240 * t1235 * t444 + t948 * t278 * t445;
t1249 = I2 * X_(2);
t1250 = t42 * t1249;
t1256 = I2 * g;
t1260 = t127 * t1249;
t1261 = t998 * t278;
t1271 = I3 * X2_(2);
t1272 = t5 * t1271;
t1274 = I3 * X_(2);
t1275 = t5 * t1274;
t1284 = t42 * t1271;
t1287 = t42 * t1274;
t1294 = t127 * t1271;
t1297 = -0.2e1 * t1037 * t461 * t1256 - 0.4e1 * t1037 * t466 * t1256 + t1237 * t1235 * t470 - 0.2e1 * t1240 * t1235 * t489 + 0.4e1 * t1007 * t1260 - t462 * t1250 - 0.2e1 * t467 * t1250 + 0.2e1 * t1261 * t1260 - 0.2e1 * t1261 * t1294 - t479 * t1272 - 0.2e1 * t484 * t1272 + t479 * t1275 + 0.2e1 * t484 * t1275 + 0.3e1 * t462 * t1284 + 0.6e1 * t467 * t1284 - 0.3e1 * t462 * t1287 - 0.6e1 * t467 * t1287 + 0.2e1 * t949 * t445;
t1298 = t127 * t1274;
t1305 = F1_(2) * m2;
t1306 = t11 * t1305;
t1309 = t26 * m1 * F1_(2);
t1311 = h4 * t503;
t1313 = t26 * t1305;
t1322 = t11 * F1_(2) * t352;
t1325 = t * F1_(2);
t1326 = t26 * t1325;
t1343 = 0.2e1 * t1261 * t1298 - 0.4e1 * t1007 * t1294 + 0.4e1 * t1007 * t1298 - t1306 * t504 + t1309 * t508 - t1309 * t1311 - 0.2e1 * t1313 * t1311 + t1306 * t523 + 0.3e1 * t1313 * t526 - t1313 * t532 + 0.2e1 * t1322 * h2 * t534 - t1326 * t535 + t1326 * t539 + 0.2e1 * t1326 * t541 - 0.2e1 * t1322 * t36 * t544 - 0.2e1 * F1_(2) * cos_slope * cos_theta * t352 * t545 + t1036 * t441 * t432 - t561 * t4 * t1249;
t1348 = t1036 * t352;
t1356 = t147 * t441;
t1359 = h1 * t1256;
t1360 = t255 * m1;
t1364 = g * t1249;
t1365 = t998 * t461;
t1370 = t998 * t466;
t1373 = t4 * t1271;
t1375 = t4 * t1274;
t1387 = 0.2e1 * t1036 * t1360 * t1359 - t1036 * t450 * t445 - 0.2e1 * t1348 * t560 * t444 + 0.4e1 * t1192 * t1359 + 0.2e1 * t1356 * t1250 + t565 * t1250 + 0.2e1 * t570 * t1250 - 0.3e1 * t565 * t1284 + 0.3e1 * t565 * t1287 - 0.2e1 * t1348 * t445 - 0.2e1 * t1365 * t1364 - 0.4e1 * t1370 * t1364 - t561 * t1373 + t575 * t1373 + 0.2e1 * t579 * t1373 + t561 * t1375 - t575 * t1375 - 0.2e1 * t579 * t1375;
t1396 = g * t1271;
t1399 = g * t1274;
t1406 = t4 * H2x;
t1410 = t6 * t1406;
t1417 = Tds * H2x;
t1418 = t7 * t1417;
t1423 = t6 * t1417;
t1431 = 0.2e1 * t609 * h1 * t1406 - 0.4e1 * t629 * h1 * t1417 + 0.2e1 * t1356 * t1284 - 0.6e1 * t570 * t1284 - 0.2e1 * t1356 * t1287 + 0.6e1 * t570 * t1287 + 0.2e1 * t1365 * t1396 - 0.2e1 * t1365 * t1399 + 0.4e1 * t1370 * t1396 - 0.4e1 * t1370 * t1399 + t595 * t1406 + 0.2e1 * t598 * t1406 - 0.4e1 * t602 * t1410 + t605 * t1410 - 0.2e1 * t614 * t1418 - 0.4e1 * t617 * t1418 + 0.8e1 * t621 * t1423 - 0.2e1 * t625 * t1423;
t1446 = t4 * M3x;
t1455 = Tds * M3x;
t1456 = t7 * t1455;
t1467 = t7 * M3x;
t1471 = cos_slope * t428;
t1478 = rH2x * m1;
t1481 = rM3x * m1;
t1484 = t11 * F1_(2) * t6 * t276 - 0.2e1 * t11 * t1325 * t6 * t444 - t1326 * t636 - t26 * h4 * F1_(2) * t638 + t1326 * t642 - t595 * t1446 - 0.2e1 * t598 * t1446 + 0.3e1 * t602 * t6 * t1446 - t609 * h1 * t1446 + 0.3e1 * t614 * t1456 + 0.6e1 * t617 * t1456 - 0.8e1 * t621 * t6 * t1455 + 0.2e1 * t629 * h1 * t1455 - 0.2e1 * cos_slope * t1360 * t1467 - 0.4e1 * t1471 * t1467 + 0.4e1 * t1471 * h2 * t6 * M3x + cos_slope * t1478 * t503 - cos_slope * t1481 * t503;
t1488 = rH2x * m2;
t1489 = cos_slope * t1488;
t1492 = rM3x * m2;
t1493 = cos_slope * t1492;
t1497 = m2 * T1_(1) * cos_slope;
t1513 = rH2x * t * cos_slope;
t1517 = rM3x * t * cos_slope;
t1521 = t * T1_(1) * cos_slope;
t1529 = t210 * t1488;
t1532 = m1 * T1_(1) * cos_slope * t503 + cos_theta * t1478 * t699 + 0.2e1 * t1489 * t503 - 0.4e1 * t1489 * t688 + 0.2e1 * t1489 * t702 - 0.2e1 * t1493 * t503 + 0.3e1 * t1493 * t688 - t1493 * t702 + 0.2e1 * t1497 * t503 - 0.3e1 * t1497 * t688 + t1497 * t702 - 0.2e1 * t1513 * t707 - 0.4e1 * t1513 * t720 + 0.3e1 * t1517 * t707 + 0.6e1 * t1517 * t720 - t1521 * t707 - 0.2e1 * t1521 * t720 + 0.8e1 * t1529 * t728;
t1534 = t210 * t1492;
t1550 = t255 * rH2x;
t1551 = cos_slope * t1550;
t1553 = t255 * rM3x;
t1554 = cos_slope * t1553;
t1573 = H2x * I2;
t1578 = 0.2e1 * T1_(1) * cos_slope * t352 * t728 - 0.2e1 * t774 * Tds * t1573 - 0.2e1 * t624 * t1478 * t741 + t624 * t1481 * t741 + cos_theta * t1550 * t225 - cos_theta * t1553 * t225 - 0.4e1 * t1529 * t747 - 0.9e1 * t1534 * t728 + 0.3e1 * t1534 * t747 + t1551 * t594 + 0.2e1 * t1551 * t597 - 0.4e1 * t1551 * t758 + 0.2e1 * t1551 * t766 - 0.2e1 * t1554 * t594 - 0.4e1 * t1554 * t597 + 0.6e1 * t1554 * t758 - 0.2e1 * t1554 * t766 + t770 * t1573;
t1579 = H2x * I3;
t1584 = I2 * M3x;
t1588 = cos_slope * t255 * h1;
t1592 = h1 * rH2x * cos_slope;
t1598 = I3 * M3x;
t1620 = -h1 * rM3x * cos_slope * t470 + h1 * T1_(1) * cos_slope * t470 - 0.2e1 * t774 * Tds * t1579 - t774 * Tds * t1584 + 0.3e1 * t774 * Tds * t1598 - 0.2e1 * t1513 * t789 - 0.2e1 * t1513 * t806 + 0.3e1 * t1517 * t806 + t1521 * t789 - t1521 * t806 + t1551 * t793 + t1551 * t813 - 0.2e1 * t1554 * t813 + t770 * t1579 + 0.2e1 * t1588 * t1584 - 0.2e1 * t1588 * t1598 + t1592 * t276 + t1592 * t470 - t770 * t1598;
t1653 = -0.2e1 * I2 * t * cos_slope - 0.2e1 * I3 * t * cos_slope + 0.2e1 * t333 * t36 * Tds + m1 * cos_slope * t544 - 0.2e1 * cos_theta * t450 * t830 - 0.2e1 * t210 * t433 - 0.4e1 * t210 * t436 + 0.8e1 * t617 * t326 + 0.2e1 * t333 * t544 + cos_slope * t444 + cos_slope * t489 - 0.4e1 * t602 * t551 + t605 * t551 - 0.4e1 * t629;
t1656 = 0.1e1 / Tds;
F2_(1) = -0.1e1 / (m1 * cos_theta * t830 + I2 * cos_slope + I3 * cos_slope - 0.4e1 * t333 * t326 + cos_slope * t433 + 0.2e1 * cos_slope * t436 + 0.2e1 * t609) * t824 / t4 * (t82 + t140 + t200 + t260 + t310 + t363 + t404 + t455 + t498 + t557 + t590 + t644 + t687 + t735 + t779 + t815);
F2_(2) = -t1656 * t824 / t1653 * (t898 + t963 + t1018 + t1073 + t1110 + t1151 + t1195 + t1245 + t1297 + t1343 + t1387 + t1431 + t1484 + t1532 + t1578 + t1620);
F2_(3) = -t1656 * (t278 + 0.2e1 * t32 - m1 - 0.2e1 * m2) * cos_slope * (Tds - t) * g;

t4 = Tds ^ 2;
t5 = g * t4;
t6 = h1 ^ 2;
t7 = t6 * h1;
t9 = h2 * t7 * t5;
t10 = m1 * m2;
t11 = cos_slope ^ 2;
t12 = t11 * rg;
t14 = sin_slope * t12 * t10;
t16 = m2 ^ 2;
t17 = rg * t16;
t18 = sin_slope * t11;
t19 = t18 * t17;
t22 = h2 ^ 2;
t24 = t22 * t6 * t5;
t28 = g * Tds;
t29 = h3 * t7;
t30 = m1 ^ 2;
t33 = rg * t;
t34 = cos_slope * cos_theta;
t35 = sin_slope * t34;
t40 = m2 * rg;
t41 = t * t40;
t47 = h2 * t6;
t48 = t47 * t5;
t49 = h3 * m1;
t50 = t11 * m2;
t52 = sin_theta * t50 * t49;
t54 = t4 * X2_(1);
t55 = t6 * g;
t56 = t55 * t54;
t57 = h2 * m1;
t58 = t11 * t40;
t59 = t58 * t57;
t61 = t4 * X_(1);
t62 = t55 * t61;
t64 = t16 * h2;
t65 = t12 * t64;
t70 = -0.2e1 * t35 * t41 * m1 * t29 * t28 - t35 * t33 * t30 * t29 * t28 + t18 * t10 * t24 - t14 * t24 + t14 * t9 - 0.2e1 * t19 * t24 + 0.2e1 * t19 * t9 + t52 * t48 + t59 * t56 + 0.2e1 * t65 * t56 - t59 * t62 - 0.2e1 * t65 * t62;
t71 = t22 * h1;
t74 = h3 * t71;
t78 = h1 * g;
t79 = t78 * t54;
t80 = m1 * t22;
t81 = t58 * t80;
t83 = t78 * t61;
t85 = t16 * t22;
t86 = t12 * t85;
t91 = t29 * t28;
t92 = t * t30;
t93 = sin_theta * t11;
t96 = t11 * t;
t97 = sin_theta * t96;
t98 = t97 * t10;
t101 = t30 * t7;
t102 = t101 * t28;
t103 = t11 * X3_(1);
t104 = t103 * t33;
t106 = X_(1) * Tds;
t107 = t7 * g;
t108 = t107 * t106;
t109 = rg * t30;
t110 = t96 * t109;
t112 = m1 * t7;
t113 = t112 * t28;
t115 = t11 * X3_(1) * t;
t116 = t115 * t40;
t119 = t11 * t33;
t120 = t119 * t10;
t123 = t16 * t7;
t124 = t123 * t28;
t127 = t35 * t10 * t74 * t5 - t52 * t71 * t5 + t93 * t92 * t91 + t104 * t102 + 0.4e1 * t104 * t124 - t110 * t108 - 0.4e1 * t120 * t108 + 0.4e1 * t116 * t113 - t81 * t79 - 0.2e1 * t86 * t79 + t81 * t83 + 0.2e1 * t86 * t83 + 0.2e1 * t98 * t91;
t129 = t96 * t17;
t133 = h3 * t47 * t28;
t136 = t * t10;
t137 = t35 * t136;
t140 = X2_(1) * Tds;
t141 = h2 * t55;
t145 = m1 * t47 * t28;
t151 = t55 * t140;
t152 = t119 * t64;
t155 = t47 * t28;
t156 = t115 * t17;
t159 = t55 * t106;
t162 = h3 * t55;
t163 = t162 * t140;
t164 = cos_slope * t;
t165 = cos_theta * t164;
t166 = t165 * t109;
t168 = h3 * t6;
t170 = t30 * t168 * t28;
t172 = X3_(1) * cos_slope * cos_theta;
t176 = t165 * rg * t10;
t179 = m1 * t168;
t180 = t179 * t28;
t184 = 0.4e1 * t120 * t141 * t106 - t120 * t141 * t140 + t172 * t33 * t170 + 0.2e1 * t172 * t41 * t180 - 0.4e1 * t129 * t108 - 0.3e1 * t116 * t145 + 0.2e1 * t137 * t133 - 0.4e1 * t98 * t133 - 0.2e1 * t152 * t151 + 0.8e1 * t152 * t159 - 0.6e1 * t156 * t155 - t166 * t163 - 0.2e1 * t176 * t163;
t185 = t74 * t28;
t190 = t22 * t78;
t194 = m1 * t71 * t28;
t199 = t78 * t140;
t200 = t119 * t85;
t203 = t71 * t28;
t206 = t78 * t106;
t209 = g * X2_(1);
t210 = t168 * t209;
t211 = t ^ 2;
t213 = cos_theta * cos_slope * t211;
t214 = t213 * t109;
t216 = t30 * h3;
t217 = t216 * t55;
t218 = t211 * rg;
t219 = t172 * t218;
t222 = t213 * t40;
t225 = m2 * t49;
t226 = t225 * t55;
t229 = t4 * I3;
t230 = t55 * t229;
t231 = m1 * rg;
t234 = -0.2e1 * t120 * t190 * t106 + t120 * t190 * t140 + 0.2e1 * t222 * t179 * t209 - t18 * t231 * t230 + t116 * t194 - 0.2e1 * t137 * t185 + 0.2e1 * t156 * t203 + 0.2e1 * t98 * t185 + 0.2e1 * t200 * t199 - 0.4e1 * t200 * t206 + t214 * t210 - t219 * t217 - 0.2e1 * t219 * t226;
t240 = t50 * t57;
t244 = g * t54;
t245 = t11 * t16;
t246 = t245 * t47;
t249 = t6 * t5;
t253 = t50 * t80;
t256 = t245 * t71;
t259 = h1 * t5;
t263 = h1 * h2;
t264 = h3 * t263;
t265 = t264 * t5;
t268 = h2 * t78;
t270 = m2 * cos_slope;
t272 = cos_theta * t270 * t49;
t274 = t22 * h2;
t275 = t16 * t274;
t276 = t11 * t275;
t278 = t103 * t10 * t48 + t172 * t10 * t265 + 0.2e1 * t103 * t64 * t249 - 0.3e1 * t103 * t85 * t259 - 0.2e1 * t18 * t40 * t230 - t272 * t268 * t61 - t240 * t56 - 0.2e1 * t246 * t244 + 0.3e1 * t256 * t244 - t276 * t244 + t253 * t79 - t253 * t83;
t279 = t274 * t5;
t283 = t7 * t28;
t286 = g * t106;
t287 = t96 * t101;
t289 = m2 * t;
t290 = t103 * t289;
t293 = t96 * t10;
t296 = t * t16;
t297 = t103 * t296;
t300 = t96 * t123;
t303 = t11 * t289;
t304 = t303 * t57;
t306 = t115 * t10;
t311 = t96 * t64;
t318 = t11 * X3_(1) * t16 * t279 - t103 * t92 * t283 + 0.4e1 * t293 * t108 - 0.4e1 * t290 * t113 + t304 * t151 + 0.2e1 * t311 * t151 + 0.6e1 * t297 * t155 + 0.3e1 * t306 * t155 - 0.4e1 * t304 * t159 - 0.8e1 * t311 * t159 - 0.4e1 * t297 * t283 + t287 * t286 + 0.4e1 * t300 * t286;
t320 = t165 * t216;
t322 = t168 * t28;
t325 = t165 * t10;
t331 = t303 * t80;
t336 = t96 * t85;
t344 = t165 * t225;
t346 = t264 * t28;
t352 = 0.2e1 * t344 * t268 * t106 - t172 * t136 * t346 - t344 * t268 * t140 - 0.2e1 * t172 * t289 * t180 - t172 * t92 * t322 + t320 * t151 + 0.2e1 * t325 * t163 - t331 * t199 - 0.2e1 * t336 * t199 - 0.2e1 * t297 * t203 - t306 * t203 + 0.2e1 * t331 * t206 + 0.4e1 * t336 * t206;
t353 = t211 * t30;
t354 = t34 * t353;
t359 = t213 * t10;
t362 = t49 * t55;
t363 = t211 * m2;
t367 = t4 * I2;
t369 = m2 * h2;
t370 = t18 * t369;
t372 = Tds * I2;
t373 = t78 * t372;
t374 = t97 * t49;
t376 = h3 * t78;
t378 = m1 * t;
t379 = t35 * t378;
t383 = X_(1) * I2;
t384 = t28 * t383;
t385 = m1 * h1;
t386 = t119 * t385;
t390 = m2 * h1;
t391 = t119 * t390;
t394 = g * t229;
t395 = m1 * t6;
t398 = m2 * t6;
t402 = t34 * X3_(1) * t211 * t217 + t115 * t231 * t373 + 0.2e1 * t172 * t363 * t362 + t18 * t395 * t394 + 0.2e1 * t18 * t398 * t394 + t370 * t78 * t367 - t379 * t376 * t372 + 0.2e1 * t116 * t373 - t354 * t210 - 0.2e1 * t359 * t210 + t374 * t373 - t386 * t384 - 0.2e1 * t391 * t384;
t406 = t78 * t229;
t412 = I3 * X2_(1);
t413 = t5 * t412;
t414 = t12 * t385;
t416 = I3 * X_(1);
t417 = t5 * t416;
t419 = t12 * t390;
t424 = Tds * I3;
t429 = t28 * t412;
t431 = t28 * t416;
t435 = t35 * t49 * t406 + t374 * t78 * t424 - t379 * t376 * t424 - t93 * t49 * t406 - t370 * t406 + t386 * t429 - t386 * t431 + 0.2e1 * t391 * t429 - t414 * t413 - 0.2e1 * t419 * t413 + t414 * t417 + 0.2e1 * t419 * t417;
t438 = t7 * t4;
t439 = h2 * t438;
t440 = F1_(1) * m2;
t441 = t11 * t440;
t443 = t6 * t4;
t444 = t22 * t443;
t446 = h2 * h4;
t447 = t446 * t443;
t448 = t34 * t440;
t450 = h1 * t4;
t451 = h4 * t22;
t452 = t451 * t450;
t454 = t7 * Tds;
t455 = t49 * t454;
t457 = t34 * t * F1_(1);
t460 = h4 * m1 * t454;
t463 = h4 * m2 * t454;
t466 = t6 * Tds;
t467 = t446 * t466;
t470 = F1_(1) * cos_slope * cos_theta * t289;
t473 = h1 * Tds;
t477 = g * t367;
t481 = g * h2;
t482 = t50 * t481;
t486 = t103 * t369 * t477 - t103 * t378 * t373 - t482 * t4 * t383 + 0.2e1 * t470 * t451 * t473 - 0.2e1 * t391 * t431 + t441 * t439 - t441 * t444 + t448 * t447 - t448 * t452 - t457 * t455 + t457 * t460 + 0.2e1 * t457 * t463 - 0.4e1 * t470 * t467;
t488 = t96 * t385;
t492 = t96 * t390;
t495 = t4 * t412;
t497 = t11 * m1 * t78;
t499 = t4 * t416;
t501 = t50 * t78;
t514 = -0.2e1 * t290 * t373 + t488 * t384 + 0.2e1 * t492 * t384 - t488 * t429 - 0.2e1 * t492 * t429 + t488 * t431 + 0.2e1 * t492 * t431 - t482 * t495 + t482 * t499 + t497 * t495 + 0.2e1 * t501 * t495 - t497 * t499 - 0.2e1 * t501 * t499;
t515 = t4 * H2y;
t516 = cos_slope * t112;
t518 = m2 * t7;
t519 = cos_slope * t518;
t522 = t6 * t515;
t523 = cos_slope * t369;
t526 = cos_theta * t49;
t529 = m2 * t22;
t530 = cos_slope * t529;
t533 = Tds * H2y;
t534 = t7 * t533;
t535 = cos_slope * t378;
t538 = cos_slope * t289;
t541 = t6 * t533;
t542 = t164 * t369;
t545 = t * cos_theta;
t546 = t545 * t49;
t550 = t164 * t529;
t553 = h1 * h4;
t554 = t553 * t372;
t559 = h1 * t229;
t563 = -t34 * h4 * F1_(1) * t559 - t11 * F1_(1) * t6 * t229 + 0.2e1 * t530 * h1 * t515 - 0.4e1 * t550 * h1 * t533 + t457 * t554 + t516 * t515 + 0.2e1 * t519 * t515 - 0.4e1 * t523 * t522 + t526 * t522 - 0.2e1 * t535 * t534 - 0.4e1 * t538 * t534 + 0.8e1 * t542 * t541 - 0.2e1 * t546 * t541;
t566 = t553 * t424;
t568 = t4 * M3y;
t573 = Tds * M3y;
t574 = t7 * t573;
t584 = rH2y * m1;
t587 = rH2y * m2;
t588 = cos_slope * t587;
t591 = h2 * t443;
t594 = rM3y * m2;
t595 = cos_slope * t594;
t598 = m2 * T1_(2) * cos_slope;
t600 = h3 * t443;
t603 = -t530 * h1 * t568 + 0.2e1 * t550 * h1 * t573 + cos_slope * t584 * t438 + t523 * t6 * t568 - 0.4e1 * t542 * t6 * t573 + cos_theta * t584 * t600 + 0.2e1 * t588 * t438 + t457 * t566 + t535 * t574 + 0.2e1 * t538 * t574 - 0.4e1 * t588 * t591 + t595 * t591 + t598 * t591;
t604 = t22 * t450;
t609 = m1 * t454;
t611 = rH2y * t * cos_slope;
t615 = t * T1_(2) * cos_slope;
t617 = m2 * t454;
t622 = h2 * t466;
t623 = t164 * t587;
t626 = t164 * t594;
t629 = T1_(2) * cos_slope * t289;
t632 = h3 * t466;
t639 = t22 * t473;
t642 = -t545 * m1 * rM3y * t632 - 0.2e1 * t545 * t584 * t632 + 0.2e1 * t588 * t604 - t595 * t604 - t598 * t604 - 0.2e1 * t611 * t609 + t615 * t609 - 0.4e1 * t611 * t617 + 0.2e1 * t615 * t617 + 0.8e1 * t623 * t622 - t626 * t622 - 0.4e1 * t629 * t622 - 0.4e1 * t623 * t639;
t647 = t211 * rH2y;
t648 = cos_slope * t647;
t652 = m2 * t47;
t660 = m2 * t71;
t663 = H2y * I2;
t664 = cos_slope * t450;
t668 = h1 * t * cos_slope;
t671 = H2y * I3;
t679 = t668 * I2 * M3y * Tds + cos_theta * t211 * rM3y * t179 - 0.2e1 * t668 * Tds * t663 - 0.2e1 * t668 * Tds * t671 + cos_theta * t647 * t179 + t648 * t112 + 0.2e1 * t648 * t518 + t626 * t639 + 0.2e1 * t629 * t639 - 0.4e1 * t648 * t652 + 0.2e1 * t648 * t660 + t664 * t663 + t664 * t671;
t681 = h1 * rH2y * cos_slope;
t683 = h1 * t372;
t687 = I2 * h1;
t689 = I3 * M3y;
t700 = h1 * t424;
t707 = I3 * h1;
t709 = -h1 * rM3y * cos_slope * t229 - h1 * T1_(2) * cos_slope * t229 + rM3y * t * cos_slope * t700 + t668 * Tds * t689 + t681 * t229 + t681 * t367 - 0.2e1 * t611 * t683 - 0.2e1 * t611 * t700 + t615 * t683 + t615 * t700 + t648 * t687 + t648 * t707 - t664 * t689;
t716 = 0.1e1 / cos_slope;
t717 = 0.1e1 / t6;
t724 = h1 * h3;
t734 = d * t4;
t735 = t55 * t734;
t740 = t11 * pw;
t757 = t4 * X2_(2);
t758 = t55 * t757;
t760 = t4 * X_(2);
t761 = t55 * t760;
t767 = t78 * t757;
t769 = t78 * t760;
t775 = Tds * d;
t778 = t11 * t * pw;
t790 = pw * cos_slope * cos_theta * t225 * t268 * t734 + t11 * pw * m2 * t57 * t735 + 0.2e1 * t740 * t275 * g * t734 - 0.2e1 * t778 * t10 * t141 * t775 - 0.4e1 * t778 * t64 * t55 * t775 - 0.4e1 * t740 * t85 * t78 * t734 + 0.8e1 * t778 * t85 * t78 * t775 + 0.2e1 * t740 * t64 * t735 + t59 * t758 - t59 * t761 + 0.2e1 * t65 * t758 - 0.2e1 * t65 * t761 - t81 * t767 - 0.2e1 * t86 * t767 + t81 * t769 + 0.2e1 * t86 * t769;
t803 = t11 * X3_(2);
t804 = t803 * t33;
t806 = X_(2) * Tds;
t807 = t107 * t806;
t810 = t11 * X3_(2) * t;
t811 = t810 * t40;
t820 = X2_(2) * Tds;
t829 = t55 * t820;
t832 = t810 * t17;
t835 = t55 * t806;
t838 = t162 * t820;
t841 = X3_(2) * cos_slope * cos_theta;
t844 = t162 * t806;
t847 = -0.2e1 * t165 * pw * t10 * t264 * g * t775 - 0.4e1 * t96 * pw * t16 * t274 * g * t775 + t804 * t102 - t110 * t807 + 0.4e1 * t811 * t113 - 0.4e1 * t120 * t807 + 0.4e1 * t804 * t124 - 0.4e1 * t129 * t807 - 0.3e1 * t120 * t141 * t820 - 0.3e1 * t811 * t145 + 0.6e1 * t120 * t141 * t806 - 0.6e1 * t152 * t829 - 0.6e1 * t832 * t155 + 0.12e2 * t152 * t835 + t166 * t838 + t841 * t33 * t170 - 0.2e1 * t166 * t844;
t863 = t78 * t820;
t868 = t78 * t806;
t871 = t30 * t107;
t872 = t803 * t218;
t875 = X_(2) * g;
t876 = t7 * t875;
t877 = t11 * t211;
t885 = t877 * t40;
t888 = t16 * t107;
t891 = t877 * t17;
t894 = X2_(2) * g;
t895 = t47 * t894;
t897 = t11 * t218 * t10;
t900 = -0.8e1 * t872 * t10 * t107 + 0.2e1 * t877 * t109 * t876 + 0.8e1 * t885 * t112 * t875 - 0.4e1 * t120 * t190 * t806 + 0.3e1 * t120 * t190 * t820 + 0.2e1 * t841 * t41 * t180 + 0.2e1 * t176 * t838 - 0.4e1 * t176 * t844 + t811 * t194 + 0.6e1 * t200 * t863 - 0.8e1 * t200 * t868 + 0.2e1 * t832 * t203 - 0.2e1 * t872 * t871 - 0.8e1 * t872 * t888 + 0.8e1 * t891 * t876 + 0.2e1 * t897 * t895;
t901 = t57 * t55;
t902 = X3_(2) * t211;
t903 = t11 * t902;
t904 = t903 * t40;
t907 = t47 * t875;
t917 = t168 * t894;
t919 = t841 * t218;
t921 = t168 * t875;
t932 = t71 * t894;
t935 = t80 * t78;
t938 = t71 * t875;
t948 = 0.4e1 * t222 * t179 * t875 - 0.2e1 * t222 * t179 * t894 + 0.12e2 * t872 * t64 * t55 - 0.4e1 * t872 * t85 * t78 - t214 * t917 + 0.2e1 * t214 * t921 - t919 * t217 - 0.2e1 * t919 * t226 + 0.4e1 * t891 * t895 - 0.16e2 * t891 * t907 - 0.4e1 * t891 * t932 + 0.8e1 * t891 * t938 - 0.8e1 * t897 * t907 - 0.2e1 * t897 * t932 + 0.4e1 * t897 * t938 + 0.6e1 * t904 * t901 - 0.2e1 * t904 * t935;
t954 = g * t757;
t977 = g * t806;
t979 = t803 * t289;
t984 = -t240 * t758 + t803 * t10 * t48 - 0.2e1 * t246 * t954 + 0.2e1 * t803 * t64 * t249 + t253 * t767 - t253 * t769 + 0.3e1 * t256 * t954 - 0.3e1 * t803 * t85 * t259 + t841 * t10 * t265 - t272 * t268 * t760 - t276 * t954 + t11 * X3_(2) * t16 * t279 - t803 * t92 * t283 + t287 * t977 - 0.4e1 * t979 * t113 + 0.4e1 * t293 * t807;
t985 = t803 * t296;
t992 = t810 * t10;
t1019 = -0.2e1 * t841 * t289 * t180 - t841 * t92 * t322 + 0.2e1 * t985 * t155 + t992 * t155 - t992 * t203 - 0.4e1 * t985 * t283 + 0.4e1 * t300 * t977 + 0.3e1 * t304 * t829 - 0.4e1 * t304 * t835 + 0.6e1 * t311 * t829 - 0.8e1 * t311 * t835 - t320 * t829 + 0.2e1 * t320 * t835 - 0.2e1 * t325 * t838 + 0.4e1 * t325 * t844 - 0.3e1 * t331 * t863 + 0.4e1 * t331 * t868;
t1044 = t803 * t363;
t1047 = t877 * t10;
t1052 = t211 * t16;
t1062 = 0.2e1 * t96 * t275 * g * t820 + 0.8e1 * t1044 * m1 * t107 - 0.8e1 * t11 * t1052 * t876 - 0.2e1 * t11 * t353 * t876 - t841 * t136 * t346 + t344 * t268 * t820 - 0.2e1 * t985 * t274 * t28 - 0.6e1 * t1044 * t901 - 0.8e1 * t1047 * t876 - 0.2e1 * t1047 * t895 + 0.8e1 * t1047 * t907 + 0.4e1 * t985 * t203 - 0.8e1 * t336 * t863 + 0.4e1 * t336 * t868 + 0.2e1 * t903 * t871 + 0.8e1 * t903 * t888;
t1064 = t877 * t64;
t1067 = t803 * t1052;
t1092 = t877 * t85;
t1100 = d * g;
t1102 = t740 * t369;
t1105 = t778 * t369;
t1108 = -0.8e1 * t1092 * h1 * t875 + 0.4e1 * t1092 * h1 * t894 + 0.16e2 * t1064 * t6 * t875 - 0.4e1 * t1064 * t6 * t894 + t1102 * t1100 * t367 - 0.2e1 * t1105 * t1100 * t372 + t34 * t902 * t217 + 0.2e1 * t841 * t363 * t362 + 0.2e1 * t1044 * t935 + 0.2e1 * t1047 * t932 - 0.4e1 * t1047 * t938 - 0.12e2 * t1067 * t141 + 0.4e1 * t1067 * t190 + t354 * t917 - 0.2e1 * t354 * t921 + 0.2e1 * t359 * t917 - 0.4e1 * t359 * t921;
t1114 = I2 * X_(2);
t1115 = t28 * t1114;
t1121 = I2 * g;
t1125 = t78 * t1114;
t1126 = t877 * t231;
t1136 = I3 * X2_(2);
t1137 = t5 * t1136;
t1139 = I3 * X_(2);
t1140 = t5 * t1139;
t1149 = t28 * t1136;
t1152 = t28 * t1139;
t1155 = t1102 * t1100 * t229 - 0.2e1 * t1105 * t1100 * t424 - 0.2e1 * t872 * t385 * t1121 - 0.4e1 * t872 * t390 * t1121 + t810 * t231 * t373 - t386 * t1115 - 0.2e1 * t391 * t1115 + 0.2e1 * t1126 * t1125 + 0.4e1 * t885 * t1125 - t414 * t1137 - 0.2e1 * t419 * t1137 + t414 * t1140 + 0.2e1 * t419 * t1140 + 0.3e1 * t386 * t1149 - 0.3e1 * t386 * t1152 + 0.2e1 * t811 * t373;
t1160 = t78 * t1136;
t1163 = t78 * t1139;
t1170 = F1_(2) * m2;
t1171 = t11 * t1170;
t1174 = t34 * t1170;
t1179 = t11 * F1_(2) * t289;
t1182 = t * F1_(2);
t1183 = t34 * t1182;
t1198 = 0.2e1 * F1_(2) * cos_slope * cos_theta * t289 * t467 - 0.2e1 * t1179 * h2 * t454 + 0.2e1 * t1179 * t22 * t466 + t803 * t369 * t477 - 0.2e1 * t1126 * t1160 + 0.2e1 * t1126 * t1163 + 0.6e1 * t391 * t1149 - 0.6e1 * t391 * t1152 - 0.4e1 * t885 * t1160 + 0.4e1 * t885 * t1163 + t1171 * t439 - t1171 * t444 + t1174 * t447 - t1174 * t452 + t1183 * t455 - t1183 * t460 - 0.2e1 * t1183 * t463;
t1212 = t96 * t369;
t1215 = h1 * t1121;
t1216 = t211 * m1;
t1220 = g * t1114;
t1221 = t877 * t385;
t1226 = t877 * t390;
t1229 = t4 * t1136;
t1231 = t4 * t1139;
t1238 = -t482 * t4 * t1114 + 0.2e1 * t803 * t1216 * t1215 - 0.2e1 * t979 * t481 * t372 - t803 * t378 * t373 + 0.4e1 * t1044 * t1215 + 0.2e1 * t1212 * t1115 + t488 * t1115 + 0.2e1 * t492 * t1115 - 0.2e1 * t1221 * t1220 - 0.4e1 * t1226 * t1220 - t482 * t1229 + t497 * t1229 + 0.2e1 * t501 * t1229 - t497 * t1231 - 0.2e1 * t501 * t1231 - 0.2e1 * t979 * t373;
t1252 = g * t1136;
t1255 = g * t1139;
t1262 = t4 * H2x;
t1266 = t6 * t1262;
t1273 = Tds * H2x;
t1274 = t7 * t1273;
t1277 = 0.2e1 * t530 * h1 * t1262 + 0.2e1 * t1212 * t1149 - 0.3e1 * t488 * t1149 - 0.6e1 * t492 * t1149 - 0.2e1 * t1212 * t1152 + 0.3e1 * t488 * t1152 + 0.6e1 * t492 * t1152 + 0.2e1 * t1221 * t1252 - 0.2e1 * t1221 * t1255 + 0.4e1 * t1226 * t1252 - 0.4e1 * t1226 * t1255 + t482 * t1231 + t516 * t1262 + 0.2e1 * t519 * t1262 - 0.4e1 * t523 * t1266 + t526 * t1266 - 0.2e1 * t535 * t1274;
t1282 = t6 * t1273;
t1302 = t4 * M3x;
t1307 = Tds * M3x;
t1308 = t7 * t1307;
t1315 = t7 * M3x;
t1319 = cos_slope * t363;
t1322 = -t34 * h4 * F1_(2) * t559 + 0.2e1 * t11 * t1182 * t6 * t424 - t11 * F1_(2) * t6 * t229 - 0.4e1 * t550 * h1 * t1273 - t530 * h1 * t1302 + 0.2e1 * t550 * h1 * t1307 + 0.2e1 * cos_slope * t1216 * t1315 + t523 * t6 * t1302 - t1183 * t554 + t1183 * t566 - 0.4e1 * t538 * t1274 + 0.8e1 * t542 * t1282 - 0.2e1 * t546 * t1282 - t535 * t1308 - 0.2e1 * t538 * t1308 + 0.4e1 * t1319 * t1315;
t1327 = rH2x * m1;
t1330 = rH2x * m2;
t1331 = cos_slope * t1330;
t1336 = rM3x * m2;
t1337 = cos_slope * t1336;
t1340 = m2 * T1_(1) * cos_slope;
t1349 = rH2x * t * cos_slope;
t1353 = t * T1_(1) * cos_slope;
t1359 = t164 * t1330;
t1362 = t164 * t1336;
t1369 = -0.4e1 * t1319 * h2 * t6 * M3x - 0.2e1 * T1_(1) * cos_slope * t289 * t622 + cos_slope * t1327 * t438 + cos_theta * t1327 * t600 + 0.2e1 * t1331 * t438 - 0.4e1 * t1331 * t591 + 0.2e1 * t1331 * t604 + t1337 * t591 - t1337 * t604 - t1340 * t591 + t1340 * t604 - 0.2e1 * t1349 * t609 - 0.4e1 * t1349 * t617 + t1353 * t609 + 0.2e1 * t1353 * t617 + 0.8e1 * t1359 * t622 - 0.3e1 * t1362 * t622;
t1381 = t211 * rH2x;
t1382 = cos_slope * t1381;
t1388 = t211 * rM3x;
t1389 = cos_slope * t1388;
t1400 = H2x * I2;
t1405 = H2x * I3;
t1410 = t545 * m1 * rM3x * t632 - 0.2e1 * t668 * Tds * t1400 - 0.2e1 * t668 * Tds * t1405 - 0.2e1 * t545 * t1327 * t632 + cos_theta * t1381 * t179 - cos_theta * t1388 * t179 + t1382 * t112 - 0.4e1 * t1359 * t639 + 0.3e1 * t1362 * t639 + 0.2e1 * t1382 * t518 - 0.4e1 * t1382 * t652 + 0.2e1 * t1382 * t660 + 0.2e1 * t1389 * t652 - 0.2e1 * t1389 * t660 + t664 * t1400 + t664 * t1405;
t1411 = I2 * M3x;
t1415 = cos_slope * t211 * h1;
t1419 = h1 * rH2x * cos_slope;
t1425 = I3 * M3x;
t1449 = -h1 * rM3x * cos_slope * t229 + h1 * T1_(1) * cos_slope * t229 + 0.3e1 * rM3x * t * cos_slope * t700 - t668 * Tds * t1411 + 0.3e1 * t668 * Tds * t1425 - 0.2e1 * t1349 * t683 - 0.2e1 * t1349 * t700 + t1353 * t683 - t1353 * t700 + t1382 * t687 + t1382 * t707 - 0.2e1 * t1389 * t707 + 0.2e1 * t1415 * t1411 - 0.2e1 * t1415 * t1425 + t1419 * t229 + t1419 * t367 - t664 * t1425;
t1483 = -0.2e1 * I2 * t * cos_slope - 0.2e1 * I3 * t * cos_slope + 0.2e1 * t270 * t22 * Tds + m1 * cos_slope * t466 - 0.2e1 * cos_theta * t378 * t724 - 0.2e1 * t164 * t395 - 0.4e1 * t164 * t398 + 0.8e1 * t538 * t263 + 0.2e1 * t270 * t466 + cos_slope * t372 + cos_slope * t424 - 0.4e1 * t523 * t473 + t526 * t473 - 0.4e1 * t550;
t1486 = 0.1e1 / Tds;
F3_(1) = 0.1e1 / (m1 * cos_theta * t724 + I2 * cos_slope + I3 * cos_slope - 0.4e1 * t270 * t263 + cos_slope * t395 + 0.2e1 * cos_slope * t398 + 0.2e1 * t530) * t717 * t716 / t4 * (t70 + t127 + t184 + t234 + t278 + t318 + t352 + t402 + t435 + t486 + t514 + t563 + t603 + t642 + t679 + t709);
F3_(2) = t1486 / t1483 * t717 * t716 * (t790 + t847 + t900 + t948 + t984 + t1019 + t1062 + t1108 + t1155 + t1198 + t1238 + t1277 + t1322 + t1369 + t1410 + t1449);
F3_(3) = -t1486 * (t231 + 0.2e1 * t40 - m1 - 0.2e1 * m2) * cos_slope * g * t;

t4 = cos_theta * h3;
t7 = h4 * cos_theta;
t10 = h3 * g;
t11 = m1 * t10;
t13 = rg * cos_slope * sin_theta;
t16 = rg * cos_theta * sin_slope;
t18 = m2 * t10;
t1_(1) = -F1_(2) * t4 - f1_(2) * t4 + F1_(2) * t7 - T1_(1);
t1_(2) = -h3 * sin_theta * f1_(3) - t13 * t11 + t11 * t16 - 0.2e1 * t13 * t18 + 0.2e1 * t16 * t18 + F1_(1) * t4 + f1_(1) * t4 - F1_(1) * t7 - T1_(2);
t1_(3) = sin_theta * (h3 * F1_(2) + h3 * f1_(2) - h4 * F1_(2));

t4 = 0.1e1 / h1;
t5 = d * h1;
t7 = pw * F2_(3) * Tds;
t9 = d * h2;
t14 = cos_slope * F2_(2);
t15 = h1 ^ 2;
t16 = Tds * t15;
t18 = h1 * h2;
t19 = Tds * t18;
t21 = h2 * cos_slope;
t25 = Tds * I2;
t30 = h1 * Tds;
t31 = F2_(3) * X2_(2);
t33 = F2_(3) * X_(2);
t35 = Tds * h2;
t49 = f2_(2) * h1 * Tds * t21 - pw * f2_(3) * Tds * t9 + M3x * Tds * h1 - t * M3x * h1 - h1 * rM3x * t + cos_slope * ddX2_(2) * t25 - cos_slope * ddX_(2) * t25 + X2_(2) * f2_(3) * t35 - X_(2) * f2_(3) * t35 + rM3x * t30 - t16 * t14 + t19 * t14 - t31 * t30 + t33 * t30 + t31 * t35 - t33 * t35 + t7 * t5 - t7 * t9;
t51 = 0.1e1 / Tds;
t53 = cos_slope * F2_(1);
t63 = F2_(3) * X2_(1);
t65 = F2_(3) * X_(1);
t80 = f2_(1) * h1 * Tds * t21 + M3y * Tds * h1 - t * M3y * h1 - h1 * rM3y * t + cos_slope * ddX2_(1) * t25 - cos_slope * ddX_(1) * t25 + X2_(1) * f2_(3) * t35 - X_(1) * f2_(3) * t35 + rM3y * t30 - t16 * t53 + t19 * t53 - t63 * t30 + t65 * t30 + t63 * t35 - t65 * t35;
t83 = I2 * ddX2_(1);
t84 = d * pw;
t85 = t * t84;
t89 = I3 * ddX_(1);
t90 = Tds * d;
t94 = X3_(2) * F3_(1);
t96 = X_(2) * Tds;
t99 = X3_(1) * F3_(2);
t101 = X_(1) * Tds;
t105 = F2_(1) * t;
t107 = t15 * X_(2);
t110 = F2_(2) * t;
t112 = t15 * X_(1);
t114 = t * t15;
t121 = X2_(2) * h1;
t123 = h2 * F2_(1) * t;
t125 = X_(2) * h1;
t127 = -t85 * I2 * ddX_(1) - pw * t90 * t89 - t * F3_(1) * t107 + t * F3_(2) * t112 - F3_(2) * t15 * t101 + t105 * t15 * X2_(2) - t110 * t15 * X2_(1) + F3_(1) * t15 * t96 - t105 * t107 + t110 * t112 + t94 * t114 - t99 * t114 - t123 * t121 + t123 * t125 - t94 * t16 + t99 * t16 + t85 * t83 + t85 * t89;
t128 = X2_(1) * h1;
t130 = h2 * F2_(2) * t;
t133 = h2 * f2_(1) * t;
t136 = I2 * X2_(1);
t144 = ddX_(1) * t;
t147 = X_(1) * t;
t155 = I3 * ddX_(2);
t161 = I3 * X_(2);
t164 = t * X3_(1);
t166 = t * X3_(2);
t170 = t144 * I2 * X2_(2) - t144 * I2 * X_(2) - t147 * I2 * ddX2_(2) + t147 * I2 * ddX_(2) + Tds * X3_(1) * t155 + ddX_(1) * Tds * t161 - Tds * X3_(2) * t89 + ddX2_(2) * t * t136 - ddX_(2) * t * t136 - X2_(2) * t * t83 + X_(2) * t * t83 - t101 * t155 - t133 * t121 + t133 * t125 + t130 * t128 - t144 * t161 + t147 * t155 - t164 * t155 + t166 * t89;
t181 = h1 * t90;
t182 = pw * h2;
t189 = Tds * t15 * sin_theta;
t197 = t15 * d;
t199 = pw * F2_(1) * t;
t201 = t * pw;
t202 = F3_(1) * t201;
t204 = f2_(1) * t201;
t206 = f3_(1) * t201;
t208 = h2 * t5;
t213 = h3 * t15;
t215 = t * F1_(2) * sin_theta;
t222 = -Tds * t15 * f1_(2) * h3 * sin_theta + Tds * t15 * f2_(1) * t84 - Tds * t15 * f3_(1) * t84 - F3_(1) * pw * t15 * t90 + t * f1_(2) * sin_theta * t213 - t189 * h3 * F1_(2) - t215 * h4 * t15 + t189 * h4 * F1_(2) + F3_(1) * t182 * t181 + f3_(1) * t182 * t181 - t199 * t197 + t202 * t197 - t204 * t197 + t206 * t197 + t199 * t208 - t202 * t208 + t204 * t208 - t206 * t208 + t215 * t213;
t243 = X_(1) * h1;
t247 = t * h2;
t254 = h2 * f2_(2);
t269 = h2 * X3_(2) * F3_(1) * t30 - h2 * X3_(1) * F3_(2) * t30 - h2 * f3_(2) * X3_(1) * t30 + h2 * f3_(1) * X3_(2) * t30 + t * f3_(2) * X3_(1) * t18 - t * f3_(1) * X3_(2) * t18 + t * t128 * t254 - t * t243 * t254 + F3_(2) * t18 * t101 + f3_(2) * t18 * t101 + F3_(1) * t247 * t125 + f3_(1) * t247 * t125 + F3_(2) * t164 * t18 - F3_(1) * t166 * t18 - F3_(1) * t18 * t96 - f3_(1) * t18 * t96 - F3_(2) * t247 * t243 - f3_(2) * t247 * t243 - t130 * t243;
t2_(1) = t51 * t49 * t4;
t2_(2) = -t51 * t80 * t4;
t2_(3) = t51 / t15 * (t127 + t170 + t222 + t269);

t4 = 0.1e1 / h1;
t5 = d * h1;
t7 = pw * F3_(3) * Tds;
t9 = d * h2;
t14 = cos_slope * F3_(2);
t15 = h1 ^ 2;
t16 = Tds * t15;
t18 = h1 * h2;
t19 = Tds * t18;
t21 = h2 * cos_slope;
t25 = Tds * I3;
t29 = F3_(3) * Tds;
t31 = h1 * Tds;
t32 = F3_(3) * X_(2);
t34 = h2 * X3_(2);
t36 = Tds * h2;
t38 = h2 * f3_(3);
t39 = X3_(2) * Tds;
t45 = -f3_(2) * h1 * Tds * t21 - pw * f3_(3) * Tds * t9 + t * M3x * h1 + t29 * h1 * X3_(2) + cos_slope * ddX_(2) * t25 + X_(2) * f3_(3) * t36 + t16 * t14 - t19 * t14 - t29 * t34 - t32 * t31 + t32 * t36 - t39 * t38 + t7 * t5 - t7 * t9;
t47 = 0.1e1 / Tds;
t49 = cos_slope * F3_(1);
t59 = F3_(3) * X_(1);
t61 = h2 * X3_(1);
t64 = X3_(1) * Tds;
t70 = -f3_(1) * h1 * Tds * t21 - t * M3y * h1 + t29 * h1 * X3_(1) + cos_slope * ddX_(1) * t25 + X_(1) * f3_(3) * t36 + t16 * t49 - t19 * t49 - t29 * t61 - t59 * t31 + t59 * t36 - t64 * t38;
t73 = Tds * d;
t77 = t15 * d;
t79 = pw * F2_(1) * t;
t81 = t * pw;
t82 = F3_(1) * t81;
t84 = f2_(1) * t81;
t86 = f3_(1) * t81;
t88 = h3 * t15;
t94 = t * F1_(2) * sin_theta;
t96 = I2 * ddX2_(1);
t98 = d * pw * t;
t102 = I3 * ddX_(1);
t108 = X_(2) * Tds;
t113 = X_(1) * Tds;
t122 = -F3_(1) * pw * t15 * t73 - t79 * t77 + t82 * t77 - t84 * t77 + t86 * t77 + t * f1_(2) * sin_theta * t88 - t94 * h4 * t15 + t98 * t96 - t98 * I2 * ddX_(1) - pw * t73 * t102 + t98 * t102 + F3_(1) * t34 * t31 - F3_(1) * t18 * t108 - F3_(2) * t61 * t31 + F3_(2) * t18 * t113 - h2 * f3_(2) * X3_(1) * t31 + h2 * f3_(1) * X3_(2) * t31;
t127 = X2_(2) * h1;
t129 = h2 * F2_(1) * t;
t131 = X_(2) * h1;
t133 = X2_(1) * h1;
t135 = h2 * F2_(2) * t;
t137 = X_(1) * h1;
t139 = t * X3_(2);
t142 = t * h2;
t145 = t * X3_(1);
t150 = h2 * f2_(2);
t154 = h2 * f2_(1) * t;
t169 = t * f3_(2) * X3_(1) * t18 - t * f3_(1) * X3_(2) * t18 + t * t133 * t150 - t * t137 * t150 - f3_(1) * t18 * t108 + f3_(2) * t18 * t113 + F3_(1) * t142 * t131 + f3_(1) * t142 * t131 - F3_(2) * t142 * t137 - f3_(2) * t142 * t137 - F3_(1) * t139 * t18 + F3_(2) * t145 * t18 - t129 * t127 - t154 * t127 + t129 * t131 + t154 * t131 + t135 * t133 - t135 * t137;
t171 = h1 * t73;
t172 = pw * h2;
t177 = h2 * t5;
t183 = X3_(2) * F3_(1);
t187 = X3_(1) * F3_(2);
t192 = F2_(1) * t;
t194 = t15 * X_(2);
t197 = F2_(2) * t;
t199 = t15 * X_(1);
t201 = t * t15;
t205 = -t * F3_(1) * t194 + F3_(1) * t15 * t108 - F3_(2) * t15 * t113 + t192 * t15 * X2_(2) - t197 * t15 * X2_(1) + F3_(1) * t172 * t171 + f3_(1) * t172 * t171 - t183 * t16 + t187 * t16 + t79 * t177 - t82 * t177 + t84 * t177 - t86 * t177 + t183 * t201 - t192 * t194 + t199 * t197 + t94 * t88;
t209 = I2 * X2_(1);
t217 = ddX_(1) * t;
t220 = X_(1) * t;
t228 = I3 * ddX_(2);
t232 = I3 * X_(2);
t239 = t217 * I2 * X2_(2) - t217 * I2 * X_(2) - t220 * I2 * ddX2_(2) + t220 * I2 * ddX_(2) + ddX_(1) * Tds * t232 + t * F3_(2) * t199 + ddX2_(2) * t * t209 - ddX_(2) * t * t209 - X2_(2) * t * t96 + X_(2) * t * t96 + t139 * t102 - t39 * t102 - t113 * t228 - t145 * t228 - t187 * t201 - t217 * t232 + t220 * t228 + t64 * t228;
t3_(1) = -t47 * t45 * t4;
t3_(2) = t47 * t70 * t4;
t3_(3) = -t47 / t15 * (t122 + t169 + t205 + t239);

T1_(1) = T1_(1);
T1_(2) = T1_(2);
T1_(3) = 0.0e0;

t4 = 0.1e1 / Tds;
t18 = h1 ^ 2;
t19 = t18 * d;
t28 = d * h1;
t29 = pw * h2;
t38 = h3 * t18;
t39 = F1_(2) * sin_theta;
t45 = I2 * d;
t48 = -t39 * h4 * t18 - pw * F2_(1) * t19 + pw * F3_(1) * t19 - pw * f2_(1) * t19 + pw * f3_(1) * t19 + pw * ddX2_(1) * t45 + F2_(1) * t29 * t28 - F3_(1) * t29 * t28 + f2_(1) * t29 * t28 - f3_(1) * t29 * t28 + f1_(2) * sin_theta * t38 + t39 * t38;
t49 = pw * ddX_(1);
t53 = F2_(1) * t18;
t56 = F2_(2) * t18;
t67 = h1 * h2;
t74 = t49 * I3 * d + F3_(1) * X3_(2) * t18 - X_(2) * F3_(1) * t18 - F3_(2) * X3_(1) * t18 + X_(1) * F3_(2) * t18 - F2_(1) * X2_(2) * t67 + F2_(1) * X_(2) * t67 + F2_(2) * X2_(1) * t67 - t49 * t45 + X2_(2) * t53 - X_(2) * t53 - X2_(1) * t56 + X_(1) * t56;
t101 = h2 * f3_(2) * h1 * X3_(1) - F2_(2) * X_(1) * t67 - X3_(2) * F3_(1) * t67 + F3_(1) * X_(2) * t67 + X3_(1) * F3_(2) * t67 - F3_(2) * X_(1) * t67 + X2_(1) * f2_(2) * t67 - X2_(2) * f2_(1) * t67 - f3_(1) * X3_(2) * t67 - X_(1) * f2_(2) * t67 - X_(1) * f3_(2) * t67 + X_(2) * f2_(1) * t67;
t104 = I2 * X2_(1);
t107 = X2_(2) * I2;
t110 = X_(1) * I2;
t113 = I2 * X_(2);
t124 = -I3 * X3_(1) * ddX_(2) + I3 * X3_(2) * ddX_(1) + I3 * X_(1) * ddX_(2) - I3 * X_(2) * ddX_(1) + X_(2) * f3_(1) * t67 + ddX2_(2) * t104 - ddX_(2) * t104 - ddX2_(1) * t107 + ddX_(1) * t107 - ddX2_(2) * t110 + ddX_(2) * t110 + ddX2_(1) * t113 - ddX_(1) * t113;
T2_(1) = -(Tds * M3x - M3x * t + Tds * rM3x - rM3x * t) * t4;
T2_(2) = t4 * (Tds * M3y - M3y * t + Tds * rM3y - rM3y * t);
T2_(3) = t4 / t18 * (t48 + t74 + t101 + t124) * (Tds - t);

t4 = 0.1e1 / Tds;
t5 = t4 * t;
t8 = h1 ^ 2;
t9 = t8 * d;
t18 = d * h1;
t19 = pw * h2;
t28 = h3 * t8;
t29 = F1_(2) * sin_theta;
t35 = I2 * d;
t38 = -t29 * h4 * t8 + pw * ddX2_(1) * t35 - pw * F2_(1) * t9 + pw * F3_(1) * t9 - pw * f2_(1) * t9 + pw * f3_(1) * t9 + F2_(1) * t19 * t18 - F3_(1) * t19 * t18 + f2_(1) * t19 * t18 - f3_(1) * t19 * t18 + f1_(2) * sin_theta * t28 + t29 * t28;
t39 = pw * ddX_(1);
t43 = F2_(1) * t8;
t46 = F2_(2) * t8;
t57 = h1 * h2;
t64 = t39 * I3 * d - F2_(1) * X2_(2) * t57 + F2_(1) * X_(2) * t57 + F2_(2) * X2_(1) * t57 + F3_(1) * X3_(2) * t8 - X_(2) * F3_(1) * t8 - F3_(2) * X3_(1) * t8 + X_(1) * F3_(2) * t8 - t39 * t35 + X2_(2) * t43 - X_(2) * t43 - X2_(1) * t46 + X_(1) * t46;
t91 = h2 * f3_(2) * h1 * X3_(1) - F2_(2) * X_(1) * t57 - X3_(2) * F3_(1) * t57 + F3_(1) * X_(2) * t57 + X3_(1) * F3_(2) * t57 - F3_(2) * X_(1) * t57 + X2_(1) * f2_(2) * t57 - X2_(2) * f2_(1) * t57 - f3_(1) * X3_(2) * t57 - X_(1) * f2_(2) * t57 - X_(1) * f3_(2) * t57 + X_(2) * f2_(1) * t57;
t94 = I2 * X2_(1);
t97 = X2_(2) * I2;
t100 = X_(1) * I2;
t103 = I2 * X_(2);
t114 = -I3 * X3_(1) * ddX_(2) + I3 * X3_(2) * ddX_(1) + I3 * X_(1) * ddX_(2) - I3 * X_(2) * ddX_(1) + X_(2) * f3_(1) * t57 - ddX2_(2) * t100 + ddX_(2) * t100 + ddX2_(1) * t103 - ddX_(1) * t103 + ddX2_(2) * t94 - ddX_(2) * t94 - ddX2_(1) * t97 + ddX_(1) * t97;
T3_(1) = M3x * t5;
T3_(2) = M3y * t5;
T3_(3) = t4 / t8 * (t38 + t64 + t91 + t114) * t;

t4 = dX_(1) ^ 2;
t6 = h1 ^ 2;
t9 = m2 * t6;
t11 = h1 * h2;
t18 = h2 ^ 2;
t19 = m2 * t18;
t20 = dX2_(1) ^ 2;
t23 = dX2_(1) * dX_(1);
t26 = cos_slope ^ 2;
t27 = t26 * I2;
t33 = t26 * I3;
t36 = 0.5000000000e0 * t6 * t4 * m1 + t9 * t4 + m2 * dX2_(1) * dX_(1) * t11 - 0.2e1 * t4 * m2 * t11 + 0.5000000000e0 * t20 * t19 - t23 * t19 + t4 * t19 + 0.5000000000e0 * t20 * t27 - t23 * t27 + 0.5000000000e0 * t4 * t27 + 0.5000000000e0 * t4 * t33;
t37 = 0.1e1 / t6;
t39 = dX_(2) ^ 2;
t50 = dX2_(2) ^ 2;
t53 = dX2_(2) * dX_(2);
t63 = 0.5000000000e0 * t6 * t39 * m1 + t39 * t9 + m2 * dX2_(2) * dX_(2) * t11 - 0.2e1 * t39 * m2 * t11 + 0.5000000000e0 * t50 * t19 - t19 * t53 + t39 * t19 + 0.5000000000e0 * t50 * t27 - t53 * t27 + 0.5000000000e0 * t39 * t27 + 0.5000000000e0 * t39 * t33;
K_(1) = t37 * t36;
K_(2) = t37 * t63;
K_(3) = 0.0e0;

out.X = X_; 
out.x2 = x2_; 
out.x3 = x3_; 
out.y1 = y1_; 
out.y2 = y2_; 
out.y3 = y3_; 
out.X3 = X3_; 
out.X2 = X2_; 
out.X1 = X1_; 
out.com = com_; 
out.dcom = dcom_; 
out.dX = dX_; 
out.dX2 = dX2_; 
out.X0 = X0_; 
out.ddX = ddX_; 
out.ddX2 = ddX2_; 
out.f1 = f1_; 
out.f2 = f2_; 
out.f3 = f3_; 
out.F1 = F1_; 
out.F2 = F2_; 
out.F3 = F3_; 
out.t1 = t1_; 
out.t2 = t2_; 
out.t3 = t3_; 
out.T1 = T1_; 
out.T2 = T2_; 
out.T3 = T3_; 
out.K = K_; 
