function [W,H] = nmf_projgrad(A,W0,H0,maxiter)

s = size(A);
f = @(B,C) norm(A - B*C)^2/(2*s(1)*s(2));

% Project W0 and H0 if necessary
W0 = max(W0,0); H0 = max(H0,0);

% Gradients of starting value
g_W0 = % ... FILL IN
g_H0 = % ... FILL IN
g0 = [g_W0; g_H0'];

W = inf; H = inf; g = g0;

c1 = 1e-2; beta = .1; tol = 1e-4; i=1;

while norm(max(g,0),'fro') > tol*norm(g0,'fro') && i < maxiter
    fprintf(1,[num2str(i) ' '])
    if mod(i,10) == 0
        fprintf(1,'\n')
    end
    %% Projected gradient step for W
    alphaW = % ... FILL IN
    W = % ... FILL IN
   
    W0 = W;
    g_H0 = % ... FILL IN
    
    %% Projected gradient step for H
    alphaH = % ... FILL IN
    H = % ... FILL IN
    
    %% new gradients
    H0 = H;
    g_W0 = % ... FILL IN
    g_H0 = % ... FILL IN
    g = [g_W0; g_H0'];

    i = i+1;
end
end