%% Main
function ex13problem2

%% Load images
cd('Images');
len = 38
im_nums = [1:13,15:39];
A = [];
for i = im_nums
    a = mat2gray(imread( ['yaleB' num2str(i, '%.2i') '_P00A+000E+00.pgm']));
    A = [A,a(:)];
end

s = size(a)
cd('../');

%% Choose rank and starting values
k=8;
rng(11);
W0 = rand(s(1)*s(2),k);
H0 = rand(k,len);

%% Run NMF
[W,H] = nmf_projgrad(A,W0,H0,100);

%% Plots

% All persons
for i=1:len
    subplot(3,13,i);
    imshow(mat2gray(reshape(A(:,i),s(1),s(2))));
end
set(gcf,'NextPlot','add'); axes; h = title(sprintf('Please enlarge me!'));
set(gca,'Visible','off'); set(h,'Visible','on');

% Face basis
figure(2);
for i=1:k
   subplot(2,ceil(k/2),i);
   imshow(reshape(W(:,i),s(1),s(2)),[]);
end
set(gcf,'NextPlot','add'); axes; h = title(sprintf('Face basis for rank %i',k));
set(gca,'Visible','off'); set(h,'Visible','on');

% Decomposition for one person
person = 1;
m = max(W*H(:,person));

figure(3);
subplot(3,ceil(k/2),1);
imshow(mat2gray(reshape(A(:,person),s(1),s(2))),[]);
title(sprintf('Person %i',person));
subplot(3,ceil(k/2),2)
imshow(reshape(W*H(:,person),s(1),s(2)),[0 m]);
title(sprintf('his/her rank %i approximation',k))
for i=1:k
    subplot(3,ceil(k/2),ceil(k/2)+i);
    imshow(reshape(W(:,i)*H(i,person),s(1),s(2)),[0 m]);
end
set(gcf,'NextPlot','add'); axes; h = title('Decomposition');
set(gca,'Visible','off'); set(h,'Visible','on');

end


