% Load the dataset to get matrices A, b and the exact
% solution xexact
load('adult.mat')

% Regularization parameter
sigma = 1;

% Lipschitz constant
L = %TODO%

% strong convexity parameter
mu = %TODO%

% TODO: PUT FUNCTION AND GRADIENT HERE %
f = @(x) ...
df = @(x) ...

% get "exact" solution from the dataset mat file
fxexact = f(xexact)

opts.maxiter = 1200; % We will need many iterations!
opts.tol = 1e-6;

x0 = rand( size(A,2), 1 );

[X_GD,  fX_GD ] = GD ( f, df, x0, 2/(L+mu) , opts );
[X_AGD, fX_AGD] = AGD( f, df, x0, mu, L    , opts );

semilogy( 1:length(fX_GD), fX_GD - fxexact, '-or' )
hold on
semilogy( 1:length(fX_AGD),fX_AGD - fxexact,'-ob' )
xlabel('Number of Iterations')
ylabel('f(x_k) - f(x^*)')

legend('GD','AGD')

