rng(11);

% set up least squares problem
n = 500;
p = 10;
A = rand( n, p );
x = rand( p, 1 );
noise = 1e-5*randn( n, 1 );
b = A*x + noise;

% obtain the exact minimizer by direct least squares solver (as the noise is gaussian)
% Note that due to the noise, x is not the same as x_exact
x_exact = A\b;

% Definition of function, derivative and Hessian
f = @(x)  % TODO % 
df = @(x) % TODO %
H =       % TODO % 

fx_exact = f(x_exact);

% Compute Lipschitz constant L and strong convexity parameter mu exactly 
L = % TODO % 
mu = % TODO % 

opts.maxiter = 70;
opts.tol = 1e-6;

% starting guess
x0 = rand( p, 1 );

% Run GD and AGD
[X_GD,  fX_GD ]       = GD ( f, df, x0, 2/(L+mu) , opts );
[X_AGD, fX_AGD]       = AGD( f, df, x0, mu, L    , opts );
% Run AGD again with "wrong" constants
[X_AGD_07, fX_AGD_07] = AGD( f, df, x0, mu, 0.7*L, opts );
[X_AGD_2, fX_AGD_2]   = AGD( f, df, x0, mu, 2*L  , opts );

% Check for convergence:
norm( x_exact - X_GD(:,end) )
norm( x_exact - X_AGD(:,end) )
norm( x_exact - X_AGD_07(:,end) )
norm( x_exact - X_AGD_2(:,end) )

% Plot convergence 
semilogy( 1:length(fX_GD), fX_GD - fx_exact, '-xr' )
hold on
semilogy( 1:length(fX_AGD),    fX_AGD - fx_exact,    '-og' )
semilogy( 1:length(fX_AGD_07), fX_AGD_07 - fx_exact, '-oc' )
semilogy( 1:length(fX_AGD_2) , fX_AGD_2 - fx_exact,  '-om' )

% TODO: ADD THEORETICAL BOUNDS %
k = 1:opts.maxiter;
%semilogy( k, %Fill in bound for GD% , '--k')
%semilogy( k, %Fill in bound for AGD%... , '-k')

l = legend('GD', 'AGD(L,\mu)', 'AGD(0.7 L,\mu', 'AGD(2 L), \mu)', 'Bound for GD', 'Bound for AGD')
set(l,'location','SouthWest')

hold off
