function [X,fX] = GD( f, df, x0, alpha, opts );
    % load default values for option parameters if not set by user
    if ~exist( 'opts', 'var');     opts = struct();       end
    if ~isfield( opts, 'tol');     opts.tol = 1e-6;       end
    if ~isfield( opts, 'maxiter'); opts.maxiter = 1000;   end

    X(:,1) = x0;
    fX(:,1) = f(x0);

    xk = x0;
    gk = df(x0);

    k = 1;
    while norm(gk) > opts.tol && k < opts.maxiter
        % perform step
        xk = xk - alpha * gk;
        
        % prepare next step
        gk = df(xk);
        X(:,k+1) = xk;
        fX(:,k+1) = f(xk);

        k = k + 1;
    end

end
