;******************************************************************************
;                                                                             *
;    Filename: lincam_demon.asm                                               *
;    Date: 14/03/2006                                                         *
;    File Version: 1.0                                                        *
;                                                                             *
;    Authors: Christophe Winter                                               *
;             Eric Seuret                                                     *
;                                                                             * 
;******************************************************************************
;                                                                             *
; Programme de dmonstration de l'utilisation de la librairie de la camra    *
; linaire. Le robot doit toujours viser la lumire qu'on lui prsente.       *
;                                                                             *
;******************************************************************************

;Les moteurs sont branchs sur le PORTD 7-6 et 5-4
;La camra est branche sur le PORTA (voir lcamMarco.asm)

.include	"m8535def.inc"
.include	"definitions.asm"
.include	"macros.asm"
.include	"lcamMacro.asm"	

.dseg
.org		0x60
lcam_buffer:	.byte	102 	;buffer pour les pixels de la camera
.cseg

reset:
	LDSP	RAMEND
	
	;initialisation des port pour les moteur
	OUTI	DDRD, 0xFF		; Set PORTD as output
	OUTI	PORTD, 0x00

	OUTI	DDRB,0xFF		; configure PortB: LED output, rest input
	OUTI	PORTB, 0x00

	;initialisation de la camra linaire
	LSETUP_PORTS
	
	rcall	lreset				;on fait un reset de la camera
	LSETUP	0, 31, 0, 27, 0, 30	;gain rgler pour notre optique
	WAIT_MS 2
	
	rjmp 	main

.include	"lcam.asm"

main:
	WAIT_MS	50		
	rcall	lstart
	WAIT_US	400					;400 us est un assez bon temps d'intgration
	rcall	lstop
	rcall	lgetpic				;Rsultat dans r0

	mov		r16, r0

	cpi		r16, 0				;Pas de pic de  lumire donc stop
	breq	stop

	cpi		r16, 10				;Pic  gauche, on y vas
	brlo	tourne_gauche		

	cpi		r16, 16				;Pic  droite, on y vas
	brsh	tourne_droite

	rjmp	stop				;Pic viser c'est parfait

tourne_gauche:
	;Tourne  gauche
	OUTI	PORTD, 0x90
	rjmp 	main

tourne_droite:
	;Tourne  droite
	OUTI	PORTD, 0x60
	rjmp	main

stop:
	;stop
	OUTI	PORTD, 0x00
	rjmp	main



