;******************************************************************************
;                                                                             *
;    Filename: lcamMacro.asm                                                  *
;    Date: 23/01/2006                                                         *
;    File Version: 1.0                                                        *
;                                                                             *
;    Authors: Christophe Winter                                               *
;             Fabrizio Lo Conte                                               *
;             Eric Seuret                                                     *
;                                                                             * 
;******************************************************************************
;                                                                             *
; Contient les macros de la libraire lcam. Cette libraire permet l'acquisi-   *
; tion de donne par une camera linaire TSL3301 de TAOS.                     *
;                                                                             *
;******************************************************************************

;-----Configuration
.equ 	LCAM_PORT 	= 		PORTA 	; Port sur lequel la cam est branche
.equ 	LCAM_DDR	= 		DDRA	; DDR du port sur lequel la cam est branche
.equ 	LCAM_PIN	=		PINA	; Port sur lequel la cam est branche

.equ 	LCAM_SDIN 	= 		3		; Pin du port sur lequel le SDIN de la cam est branch JAUNE
.equ	LCAM_SDOUT 	=		4		; Pin du port sur lequel le SDOUT de la cam est branch BLEU
.equ 	LCAM_SCLK 	=		5		; Pin du port sur lequel le SDCLK de la cam est branch VERT

.def 	LCAM_PARAM 	=		r18
.def	LCAM_ITER1 	=		r19
.def 	LCAM_ITER2 	= 		r20
.def	LCAM_WORK	=		r21


;-----Pulse
;Sort un pulse sur le sclk
.macro LPULSE
	sbi		LCAM_PORT, LCAM_SCLK
	nop
	cbi		LCAM_PORT, LCAM_SCLK
.endmacro


;-----Pulse plusieurs fois
;Sort n pulse sur sclk (n tant un paramtre de la macro)
.macro LPULSEN
	push	LCAM_ITER1

	ldi		LCAM_ITER1, @0					;for 1 to @0
lpulsen_next:
	sbi		LCAM_PORT, LCAM_SCLK	
	dec		LCAM_ITER1
	cbi		LCAM_PORT, LCAM_SCLK
	brne	lpulsen_next					;endfor

	pop		LCAM_ITER1
.endmacro

;-----Configuration ATmega
;Configure les ports de l'ATmega en tenant comptes des prcdentes configurations
.macro	LSETUP_PORTS

	sbi 	LCAM_DDR, LCAM_SDIN
	sbi 	LCAM_DDR, LCAM_SCLK
	cbi		LCAM_DDR, LCAM_SDOUT
	cbi		LCAM_PORT, LCAM_SCLK 			; Pour en tre sur
	
.endmacro

;-----Configuration "standard" de la TSL3301
;Configure la TSL3301 d'un manire "standard" (comme donn dans le Designer's Notebook de TAOS)
.macro	LSETUP_STD
	push	LCAM_PARAM

	ldi 	LCAM_PARAM, 0x40 				;Left offset
	rcall 	lsend
	ldi		LCAM_PARAM, 0 				
	rcall 	lsend
	ldi 	LCAM_PARAM, 0x41 				;Left gain
	rcall 	lsend
	ldi 	LCAM_PARAM, 15 				
	rcall 	lsend
	ldi 	LCAM_PARAM, 0x42 				;Middle offset
	rcall 	lsend
	ldi 	LCAM_PARAM, 0 				
	rcall 	lsend
	ldi 	LCAM_PARAM, 0x43 				;Middle gain
	rcall 	lsend
	ldi 	LCAM_PARAM, 15 				
	rcall 	lsend
	ldi 	LCAM_PARAM, 0x44 				;Right offset
	rcall 	lsend
	ldi 	LCAM_PARAM, 0 				
	rcall 	lsend
	ldi 	LCAM_PARAM, 0x45 				;Right gain
	rcall 	lsend
	ldi 	LCAM_PARAM, 15 				
	rcall 	lsend

	pop		LCAM_PARAM
.endmacro


;-----Configuration de la TSL3301
;Configure la TSL3301 selon les paramtres donn. Les paramtres sont (dans l'ordre) :
;[left offset] [left gain] [middle offset] [middle gain] [right offset] [right gain] 
.macro	LSETUP
	push	LCAM_PARAM

	ldi 	LCAM_PARAM, 0x40 				;Left offset
	rcall 	lsend
	ldi		LCAM_PARAM,	@0
	rcall 	lsend
	ldi 	LCAM_PARAM, 0x41 				;Left gain
	rcall 	lsend
	ldi 	LCAM_PARAM,	@1
	rcall 	lsend
	ldi 	LCAM_PARAM, 0x42 				;Middle offset
	rcall 	lsend
	ldi 	LCAM_PARAM, @2
	rcall 	lsend
	ldi 	LCAM_PARAM, 0x43 				;Middle gain
	rcall 	lsend
	ldi 	LCAM_PARAM, @3
	rcall 	lsend
	ldi 	LCAM_PARAM, 0x44 				;Right offset
	rcall 	lsend
	ldi 	LCAM_PARAM, @4 
	rcall 	lsend
	ldi 	LCAM_PARAM, 0x45 				;Right gain
	rcall 	lsend
	ldi 	LCAM_PARAM, @5 
	rcall 	lsend

	pop		LCAM_PARAM
.endmacro




