;******************************************************************************
;                                                                             *
;    Filename: lcam.asm                                                       *
;    Date: 14/03/2006                                                         *
;    File Version: 1.1                                                        *
;                                                                             *
;    Authors: Christophe Winter                                               *
;             Fabrizio Lo Conte                                               *
;             Eric Seuret                                                     *
;                                                                             * 
;******************************************************************************
;                                                                             *
; Contient les fonctions de la libraire lcam. Cette libraire permet l'acqui-  *
; sition de donne par une camera linaire TSL3301 de TAOS.                   *
;                                                                             *
;******************************************************************************

;-----Envoi de donne/instruction
;Envoie  la camra linaire le byte stocker dans le registre LCAM_PARAM
lsend:
	push	LCAM_ITER1
	push	LCAM_WORK

	;Start bit (SDIN  0)
	cbi 	LCAM_PORT, LCAM_SDIN
	LPULSE
	
	ldi 	LCAM_ITER1, 8					;for 1 to 8
lsend_next:									;envoi des 8 bits (LSB en premier)
	bst		LCAM_PARAM, 0				
	in		LCAM_WORK, LCAM_PIN
	bld		LCAM_WORK, LCAM_SDIN
	out 	LCAM_PORT, LCAM_WORK			;SDIN = LCAM_PARAM.0
	LPULSE
	ror		LCAM_PARAM						;LCAM_PARAM rotate right one
	dec		LCAM_ITER1
	brne	lsend_next						;endfor

	;Stop bit (SDIN  1)
	sbi		LCAM_PORT, LCAM_SDIN
	LPULSE

	pop		LCAM_WORK
	pop		LCAM_ITER1
	ret


;-----Reset
;Assure que la TSL3301 soit oprationnelle
lreset:
	push	LCAM_PARAM

	cbi		LCAM_PORT, LCAM_SCLK
	
	cbi		LCAM_PORT, LCAM_SDIN			;SDIN = 0				
	LPULSEN	30 								;30 impulsions sur sclk

	sbi		LCAM_PORT, LCAM_SDIN			;SDIN = 1
	LPULSEN	10								;10 Impulsions sur sclk

	ldi 	LCAM_PARAM, 0x1B
	rcall	lsend							;Commande de Reset

	LPULSEN 	5							;5 impulsions sur sclk

	ldi 	LCAM_PARAM, 0X5F
	rcall	lsend							;Ecriture du mode register
	ldi 	LCAM_PARAM, 0x00
	rcall	lsend							;Clear mode register(single chip, not sleep)

	pop 	LCAM_PARAM
	ret

;-----Fin combin
;Combine un lendintegration avec un lread et un lreadout
;Affecte : x 
lstop:
	rcall	lendintegration
	rcall	lreadout
	rcall	lread
	ret


;-----Intgration
;Demande  la camra de prendre une image.
lstart:
	push	LCAM_PARAM

	ldi 	LCAM_PARAM,0x08					;Commande STARTInt
	rcall 	lsend
	LPULSEN	22 								;22 Impulsion sur sclk(ncessaire)
	
	pop		LCAM_PARAM
	ret

;-----Fin d'intgration
;Demande  la camra de terminer l'intgration une fois le temps d'exposition souhaiter termin
lendintegration:
	push 	LCAM_PARAM

	ldi 	LCAM_PARAM,0x10					;Commande SAMPLEInt
	rcall 	lsend
	LPULSEN	5 								;5 Impulsions ncessaires
	
	pop 	LCAM_PARAM
	ret

;-----Prparation de l'envoie des donne
;Donne  la camra l'odre de se prparer  envyer les donne et attends qu'elle soit prte
lreadout:
	push	LCAM_PARAM

	ldi 	LCAM_PARAM, 0x02				;Commande READPixel
	rcall 	lsend			

	sbis	LCAM_PIN, LCAM_SDOUT			;Boucle d'attente que la camra soit prte
	rjmp 	lreadout_end
lreadout_next:	
	LPULSE
	nop
	sbic	LCAM_PIN, LCAM_SDOUT
	rjmp	lreadout_next

lreadout_end:
	pop		LCAM_PARAM
	ret



;-----Lecture des donne
;Une fois la camra prte, lit les 102 pixels et les stock en SRAM (addresse lcam_buffer)
;Affecte x
lread:
	push	LCAM_PARAM
	push	LCAM_WORK
	push	LCAM_ITER1
	push	LCAM_ITER2

	ldi 	xl, low(lcam_buffer)
	ldi 	xh, high(lcam_buffer)
	

	ldi 	LCAM_ITER1, 102					;for 1 to 102
lread_nextpixel:
	ldi 	LCAM_PARAM, 0					;rception d'un pixel (LSB en premier)
	
	ldi 	LCAM_ITER2, 8					;for 1 to 8
	LPULSE
	clc
lread_nextbit:
	ror 	LCAM_PARAM						;Rotate right LCAM_PARAM
	in 		LCAM_WORK, LCAM_PIN
	bst		LCAM_WORK, LCAM_SDOUT
	bld		LCAM_PARAM, 7					;LCAM_PARAM.7 = SDOUT
	LPULSE
	dec 	LCAM_ITER2
	brne 	lread_nextbit					;endfor
	LPULSE

	st 		X+, LCAM_PARAM					;sauvegarde le pixel
	dec 	LCAM_ITER1
	brne 	lread_nextpixel					;endfor


	pop		LCAM_ITER2
	pop		LCAM_ITER1
	pop		LCAM_WORK
	pop		LCAM_PARAM
	ret

;-----Le pic de plus haute valeur
;partage les 102 pixels en 25 zones de 4 pixels (ignorant les pixels extrmes)
;et retourne sur r0 le numro de la zone la 
;pluslumineuse (moyenne).
;Affecte : r0, x, y
lgetpic:
	push	r1
	push	r2
	push	r30
	push	r31

	ldi 	xl, low(lcam_buffer+1)
	ldi 	xh, high(lcam_buffer+1)

	ldi 	yl, low(lcam_buffer)
	ldi 	yh, high(lcam_buffer)

	
	;Cration des groupes
	ldi		r31, 25							;for 1 to 25
lgetpic_nextgroup:
	clr		r1
	
	ldi		r30, 4							;for 1 to 4
lgetpic_nextpixel:
	ld		r0, X+
	
	lsr		r0
	lsr		r0								;division par quatre : deux dcalage  droite

	add 	r1, r0							;on le premier quart

	dec		r30
	brne	lgetpic_nextpixel				;endfor

	st		y+, r1
	
	dec		r31
	brne	lgetpic_nextgroup

	
	;Recherche du plus haut groupe
	ldi 	yl, low(lcam_buffer)
	ldi 	yh, high(lcam_buffer)
	
	clr		r0
	clr		r31								;for 1 to 25
	clr		r2
	ldi		r30, 0xFF

lgetpic_nextgroup1:
	inc		r31
	ld		r1, y+
	cp		r1, r2

	brlo	lgetpic_smaller	
	mov		r0, r31
	mov		r2, r1

lgetpic_smaller:
	cp		r1, r30

	brsh	lgetpic_none
	mov		r30, r1

lgetpic_none:
	cpi		r31, 25
	brne	lgetpic_nextgroup1				;endfor

	cp 		r2, r30
	brne	lgetpic_end	
	clr		r0	

lgetpic_end:

	pop		r31
	pop		r30
	pop		r2
	pop		r1
	ret





	
