
;******************************************************************************
;                                                                             *
;    Filename: lincam_demon.asm                                               *
;    Date: 14/03/2006                                                         *
;    File Version: 1.0                                                        *
;                                                                             *
;    Authors: Christophe Winter                                               *
;             Eric Seuret                                                     *
;                                                                             * 
;******************************************************************************
;                                                                             *
; Programme de dmonstration de l'utilisation de la librairie de la camra    *
; linaire. Le robot doit toujours viser la lumire qu'on lui prsente.       *
;                                                                             *
;******************************************************************************

;Les moteurs sont branchs sur le PORTD 7-6 et 5-4
;La camra est branche sur le PORTA (voir lcamMarco.asm)

.include	"m8535def.inc"
.include	"definitions.asm"
.include	"macros.asm"
.include	"lcamMacro.asm"


.org	0				; reset vector
	rjmp	reset
.org	URXCaddr			; USART receive complete
	rjmp	UART_rxc
.org	UDREaddr			; USART data registry empty
	rjmp	UART_dre
.org	0x15				; end of vector table

.include	"monitor_lib.asm"	

reset:
	LDSP	RAMEND
	

	OUTI	DDRB,0xFF		; configure PortB: LED output, rest input
	OUTI	PORTB, 0x00

	OUTI	DDRD,0x00		; configure PortD: all input
	
	rcall	monitor_init		; initialize Monitor (also UART and Interrupts)

	;initialisation de la camra linaire
	LSETUP_PORTS
	
	rcall	lreset				;on fait un reset de la camera
	LSETUP_STD
	WAIT_MS 2
	
	rjmp 	main

.include	"lcam.asm"

main:
	WAIT_MS	50		
	rcall	lstart
	WAIT_US	400					;400 us est un assez bon temps d'intgration
	rcall	lstop
	rcall	lgetpic				;Rsultat dans r0

	sts		data0, r0

	rjmp	main





