; File: ir_mon.asm
; Programme pour lire un capteur de facon analogique.
; Il envoye sur l'interface PrismeMonitor la valeur lue et dessine une image (camlin)
; PORTA 0: input analigique
; PORTB 0: controle des capteurs
; PORTB 2: LED verte
; PORTC: 8 LED
; PORTD 0,1: PC

; Integr avec le
; PRisme Monitor
; Version 0.99
; (c) 2005 by Freddy


; === basic includes ===

.include 	"m8535def.inc"		; include AVR port/bit definitions
.include 	"definitions.asm"	; include register/constant definitions
.include 	"macros.asm"		; include macro definitions


; === interrupt vector table ===

.org	0				; reset vector
	rjmp	reset
.org	URXCaddr			; USART receive complete
	rjmp	UART_rxc
.org	UDREaddr			; USART data registry empty
	rjmp	UART_dre
.org	0x15				; end of vector table


; === interrupt service routine ===

	; PUT YOUR INTERRUPT SERVICE ROUTINES HERE


; === initialisation ===

reset:	
	LDSP	RAMEND			; Load Stack Pointer (SP)
	
	OUTI	ADCSR,(1<<ADEN)+6	; AD Enable, PS=CK/64
	
	OUTI	DDRA,0x00		; configure PortA: all input
	OUTI	DDRB,0x0F		; configure PortB: LED output, rest input
	OUTI	DDRC,0xFF		; configure PortC: all input
	OUTI	DDRD,0x00		; configure PortD: all input
	
	rcall	monitor_init		; initialize Monitor (also UART and Interrupts)

	cbi	PORTB,2			; clear LED


	ldi		r26, LinCam
	clr		r27
	rjmp	main			; end of initialisation


; === auxiliary includes ===

.include 	"monitor_lib.asm"	; include Monitor module
.include	"adc.asm"

; === main code ===

main:
	WAIT_MS	50			; Retard de lecture

; ___ Lecture analogique du capteur ___
	OUTI	ADMUX,0			; Selectionne le PIN 0 du port analogique (A)
	rcall	adc			; Conversion AD
	sts		data0,a0		; Envoye la valeur lue (a0) dans la case data0
	sts		gauge1,a0		; et dans gauge1 du PrismeMonitor

; ___ Effet oscillo dans lincam ___
	st		x+, a0		
	cpi		xl,(LinCam+102)
	brlo	PC+2
	ldi		xl, LinCam

; ___ Effet sur les leds ___
	cpi		a0, 64		; Comparaison
	brsh	low				; Saute si a0 est plus grand ou gale
	OUTI	PORTC, 0b11		; Allume les 2 premieres leds
	rjmp	main				; main loop
low:
	cpi		a0, 128
	brsh	middle
	OUTI	PORTC, 0b1100
	rjmp	main
middle:
	cpi		a0, 192
	brsh	high
	OUTI	PORTC, 0b110000
	rjmp	main
high:
	OUTI	PORTC, 0b11000000
	rjmp	main				; main loop


; === sub-routine includes ===

	; PUT SUB-ROUTINES HERE


; === lookup tables ===

	; PUT LOOKUP TABLES HERE

