; file: adc.asm   
; analogic-digital converter library
; pour la lecture des dapteurs IR avec reduction
; de la lumiere ambiente.
; Alessandro Ambuehl et Cyntia Duc
; 10-6-2004
; Modifi en janvier 2007 par A. Ambuehl
;
; ___Utilisation:___
; __Connections:__
; PORTA: port analogique avc 8 entres
; PORTB 0: Controle de la led ir des LED IR
;
; __Programme:__
; 1.	dans reset il faut ajouter:
;		LDSP	RAMEND			; stack pointer
;		OUTI	ADCSR,(1<<ADEN)+6	; AD Enable, PS=CK/64
;		OUTI	ADMUX,0			; Selectionne le PIN 0
;
; 2.	inclure ce fichier APRES le "rjmp main" et avant le main:
;
; 3.	Pour lire une valeur il faut ecrire ces 2 commandes:
; 		OUTI	ADMUX,0			; Selectionne le PIN 0 du PORTA
;		rcall	adc				; Lance la conversion
; La valeur lue est donne dans a0 (8 bit)
	
; === adc ===
; in: -
; out: a0
; mod: ADCSR, SREG, PORTB 0
; use: a1, a2 ,a3
; ===========

adc:	
	PUSH3	a1, a2, a3	; Sauve la valeur de a1, a2, a3 dans la pile	
	
	CLR4	a3,a2,a1,a0	; Met le registre a  0

; __Valeur de la lumiere ambiante__
	sbi	ADCSR,ADSC	; AD start conversion
	WP1	ADCSR,ADSC	; Attend si ADIF=0
	in	a0,ADCL		; Met le byte de poids faible dans a0
	in	a1,ADCH		; Met le byte de poids fort dans a1
	
; __Conversion 10bit --> 8bit__	
	ror	a1		; Copie le bit '8' dans le carry et dcale  droite les autres
	ror	a0		; Copie le carry dans le bit 7 et dcale  droite les autres
	ror	a1		; Copie le bit '9' dans le carry ...
	ror	a0		; Copie le carry dans le bit 7 ...
	
	cbi	PORTB,0		; Allume la LED IR (B0)
	WAIT_US	200		; Attend que le pH reagit
	
; __Valeur lumiere ambiante + reflexion__
	sbi	ADCSR,ADSC	; AD start conversion
	WP1	ADCSR,ADSC	; Attend si ADIF=0
	in	a2,ADCL		; Lit le byte de poids faible dans a2
	in	a3,ADCH		; Lit le byte de poids fort dans a3

	sbi	PORTB,0		; Eteind la LED IR
	WAIT_US	50		; Attend que le pH reagit
	
; __Conversion 10bit --> 8bit__
	ror	a3		; Copie le bit '8' dans le carry et dcale  droite les autres
	ror	a2		; Copie le carry dans le bit 7 et dcale  droite les autres
	ror	a3		; Copie le bit '9' dans le carry ...
	ror	a2		; Copie le carry dans le bit 7 ...

; __Valeur de la refexion__
	sub	a0,a2		; Soustrait a2  a0
	brcc	PC+2		; Branchement si a0-a2 > 0
	clr	a0		; Met a0  '0'
	
	POP3	a1, a2, a3	; a1, a2, a3 remis  l'tat sauvegard dans la pile

	ret
