#include <prismino.h>

// We have to declare this variable "volatile" as is can change states inside an interrupt,
// the compiler might "cache" the value instead of always making sure it reads the variable value in memory
volatile uint8_t stop = 0;

// Interrupt vector for Pin Change
ISR(PCINT0_vect)
{
  setSpeed(0, 0);
}

void button()
{
  setSpeed(100, 100);
}

// Arduino already declared this interrupt vector, so we cannot use it this way :(
/*ISR(INT6_vect)
{
  setSpeed(100, 100);
}*/

void setup()
{
  // Make pin "13" output current (actually it's bit 7 in PORTC)
  DDRC |= _BV(7);
  // This is equivalent to DDRC = DDRC | (1 << 7), it sets the bit 7 in DDRC (Data Direction Register C) to 1 (output)
  // You can always do it the Arduino way: pinMode(13, OUTPUT), but that's not cool enough...
  
  // Turn on IR emitters
  PORTC |= _BV(7);
  
  // First enable the button pull-up
  PORTE |= _BV(6);
  
  // The Arduino way to set up an interrupt is to call attachInterrupt()
  // Make the code call a function when we push the shield button
  attachInterrupt(4, button, FALLING);
  
  // Alternativly you can also call the Robopoly shortcut, which is basically the same as above
  //buttonCallback();
  // This shortcut also takes care of the pull-up setting
  
  // The embedded systems engieer does it this way (datasheet p. 80)
  // Interrupt on falling edge
  //EICRB |= _BV(ISC61);
  // Enable button interrupt
  //EIMSK |= _BV(INT6);
  
  // Enable Pin Change interrupts (datasheet p. 81)
  PCICR |= _BV(PCIE0);
  // Enable Pin Change on pins PCINT1 (PB1) and PCINT3 (PB3) (datasheet p. 82)
  PCMSK0 |= _BV(PCINT3) | _BV(PCINT1);
}

void loop()
{
  delay(500);
}
